/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.text.similarity.SimilarityInput;
import org.apache.commons.text.similarity.SimilarityScore;

public class JaroWinklerSimilarity
implements SimilarityScore<Double> {
    static final JaroWinklerSimilarity INSTANCE = new JaroWinklerSimilarity();

    protected static int[] matches(CharSequence first, CharSequence second) {
        return JaroWinklerSimilarity.matches(SimilarityInput.input(first), SimilarityInput.input(second));
    }

    protected static <E> int[] matches(SimilarityInput<E> first, SimilarityInput<E> second) {
        int i2;
        SimilarityInput<E> min2;
        SimilarityInput<E> max2;
        if (first.length() > second.length()) {
            max2 = first;
            min2 = second;
        } else {
            max2 = second;
            min2 = first;
        }
        int range = Math.max(max2.length() / 2 - 1, 0);
        int[] matchIndexes = new int[min2.length()];
        Arrays.fill(matchIndexes, -1);
        boolean[] matchFlags = new boolean[max2.length()];
        int matches = 0;
        block0: for (int mi = 0; mi < min2.length(); ++mi) {
            E c1 = min2.at(mi);
            int xn = Math.min(mi + range + 1, max2.length());
            for (int xi = Math.max(mi - range, 0); xi < xn; ++xi) {
                if (matchFlags[xi] || !c1.equals(max2.at(xi))) continue;
                matchIndexes[mi] = xi;
                matchFlags[xi] = true;
                ++matches;
                continue block0;
            }
        }
        Object[] ms1 = new Object[matches];
        Object[] ms2 = new Object[matches];
        int si = 0;
        for (i2 = 0; i2 < min2.length(); ++i2) {
            if (matchIndexes[i2] == -1) continue;
            ms1[si] = min2.at(i2);
            ++si;
        }
        si = 0;
        for (i2 = 0; i2 < max2.length(); ++i2) {
            if (!matchFlags[i2]) continue;
            ms2[si] = max2.at(i2);
            ++si;
        }
        int halfTranspositions = 0;
        for (int mi = 0; mi < ms1.length; ++mi) {
            if (ms1[mi].equals(ms2[mi])) continue;
            ++halfTranspositions;
        }
        int prefix = 0;
        for (int mi = 0; mi < Math.min(4, min2.length()) && first.at(mi).equals(second.at(mi)); ++mi) {
            ++prefix;
        }
        return new int[]{matches, halfTranspositions, prefix};
    }

    @Override
    public Double apply(CharSequence left, CharSequence right) {
        return this.apply(SimilarityInput.input(left), SimilarityInput.input(right));
    }

    @Override
    public <E> Double apply(SimilarityInput<E> left, SimilarityInput<E> right) {
        double defaultScalingFactor = 0.1;
        if (left == null || right == null) {
            throw new IllegalArgumentException("CharSequences must not be null");
        }
        if (Objects.equals(left, right)) {
            return 1.0;
        }
        int[] mtp = JaroWinklerSimilarity.matches(left, right);
        double m2 = mtp[0];
        if (m2 == 0.0) {
            return 0.0;
        }
        double j2 = (m2 / (double)left.length() + m2 / (double)right.length() + (m2 - (double)mtp[1] / 2.0) / m2) / 3.0;
        return j2 < 0.7 ? j2 : j2 + 0.1 * (double)mtp[2] * (1.0 - j2);
    }
}

