/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import java.util.Arrays;
import org.apache.commons.text.similarity.EditDistance;
import org.apache.commons.text.similarity.SimilarityInput;

public class LevenshteinDistance
implements EditDistance<Integer> {
    private static final LevenshteinDistance INSTANCE = new LevenshteinDistance();
    private final Integer threshold;

    public static LevenshteinDistance getDefaultInstance() {
        return INSTANCE;
    }

    private static <E> int limitedCompare(SimilarityInput<E> left, SimilarityInput<E> right, int threshold) {
        if (left == null || right == null) {
            throw new IllegalArgumentException("CharSequences must not be null");
        }
        if (threshold < 0) {
            throw new IllegalArgumentException("Threshold must not be negative");
        }
        int n2 = left.length();
        int m2 = right.length();
        if (n2 == 0) {
            return m2 <= threshold ? m2 : -1;
        }
        if (m2 == 0) {
            return n2 <= threshold ? n2 : -1;
        }
        if (n2 > m2) {
            SimilarityInput<E> tmp = left;
            left = right;
            right = tmp;
            n2 = m2;
            m2 = right.length();
        }
        if (m2 - n2 > threshold) {
            return -1;
        }
        int[] p = new int[n2 + 1];
        int[] d2 = new int[n2 + 1];
        int boundary = Math.min(n2, threshold) + 1;
        for (int i2 = 0; i2 < boundary; ++i2) {
            p[i2] = i2;
        }
        Arrays.fill(p, boundary, p.length, Integer.MAX_VALUE);
        Arrays.fill(d2, Integer.MAX_VALUE);
        for (int j2 = 1; j2 <= m2; ++j2) {
            int max2;
            E rightJ = right.at(j2 - 1);
            d2[0] = j2;
            int min2 = Math.max(1, j2 - threshold);
            int n3 = max2 = j2 > Integer.MAX_VALUE - threshold ? n2 : Math.min(n2, j2 + threshold);
            if (min2 > 1) {
                d2[min2 - 1] = Integer.MAX_VALUE;
            }
            int lowerBound = Integer.MAX_VALUE;
            for (int i3 = min2; i3 <= max2; ++i3) {
                d2[i3] = left.at(i3 - 1).equals(rightJ) ? p[i3 - 1] : 1 + Math.min(Math.min(d2[i3 - 1], p[i3]), p[i3 - 1]);
                lowerBound = Math.min(lowerBound, d2[i3]);
            }
            if (lowerBound > threshold) {
                return -1;
            }
            int[] tempD = p;
            p = d2;
            d2 = tempD;
        }
        if (p[n2] <= threshold) {
            return p[n2];
        }
        return -1;
    }

    private static <E> int unlimitedCompare(SimilarityInput<E> left, SimilarityInput<E> right) {
        int i2;
        if (left == null || right == null) {
            throw new IllegalArgumentException("CharSequences must not be null");
        }
        int n2 = left.length();
        int m2 = right.length();
        if (n2 == 0) {
            return m2;
        }
        if (m2 == 0) {
            return n2;
        }
        if (n2 > m2) {
            SimilarityInput<E> tmp = left;
            left = right;
            right = tmp;
            n2 = m2;
            m2 = right.length();
        }
        int[] p = new int[n2 + 1];
        for (i2 = 0; i2 <= n2; ++i2) {
            p[i2] = i2;
        }
        for (int j2 = 1; j2 <= m2; ++j2) {
            int upperLeft = p[0];
            E rightJ = right.at(j2 - 1);
            p[0] = j2;
            for (i2 = 1; i2 <= n2; ++i2) {
                int upper2 = p[i2];
                int cost = left.at(i2 - 1).equals(rightJ) ? 0 : 1;
                p[i2] = Math.min(Math.min(p[i2 - 1] + 1, p[i2] + 1), upperLeft + cost);
                upperLeft = upper2;
            }
        }
        return p[n2];
    }

    @Deprecated
    public LevenshteinDistance() {
        this(null);
    }

    public LevenshteinDistance(Integer threshold) {
        if (threshold != null && threshold < 0) {
            throw new IllegalArgumentException("Threshold must not be negative");
        }
        this.threshold = threshold;
    }

    @Override
    public Integer apply(CharSequence left, CharSequence right) {
        return this.apply(SimilarityInput.input(left), SimilarityInput.input(right));
    }

    @Override
    public <E> Integer apply(SimilarityInput<E> left, SimilarityInput<E> right) {
        if (this.threshold != null) {
            return LevenshteinDistance.limitedCompare(left, right, this.threshold);
        }
        return LevenshteinDistance.unlimitedCompare(left, right);
    }

    public Integer getThreshold() {
        return this.threshold;
    }
}

