/*
 * Decompiled with CFR 0.152.
 */
package org.bridj;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.bridj.CLong;
import org.bridj.NativeConstants;
import org.bridj.NativeObject;
import org.bridj.Pointer;
import org.bridj.SizeT;

class EllipsisHelper {
    static ThreadLocal<IntBuffer[]> holders = new ThreadLocal<IntBuffer[]>(){

        @Override
        protected IntBuffer[] initialValue() {
            return new IntBuffer[1];
        }
    };

    EllipsisHelper() {
    }

    public static IntBuffer unrollEllipsis(Object[] args) {
        IntBuffer[] holder = holders.get();
        int n2 = args.length;
        IntBuffer buf = holder[0];
        if (buf == null || buf.capacity() < n2) {
            buf = holder[0] = ByteBuffer.allocateDirect(n2 * 4).asIntBuffer();
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            NativeConstants.ValueType type2;
            Object arg = args[i2];
            if (arg == null || arg instanceof Pointer) {
                type2 = NativeConstants.ValueType.ePointerValue;
            } else if (arg instanceof Integer) {
                type2 = NativeConstants.ValueType.eIntValue;
            } else if (arg instanceof Long) {
                type2 = NativeConstants.ValueType.eLongValue;
            } else if (arg instanceof Short) {
                type2 = NativeConstants.ValueType.eShortValue;
            } else if (arg instanceof Double) {
                type2 = NativeConstants.ValueType.eDoubleValue;
            } else if (arg instanceof Float) {
                type2 = NativeConstants.ValueType.eFloatValue;
            } else if (arg instanceof Byte) {
                type2 = NativeConstants.ValueType.eByteValue;
            } else if (arg instanceof Boolean) {
                type2 = NativeConstants.ValueType.eBooleanValue;
            } else if (arg instanceof Character) {
                type2 = NativeConstants.ValueType.eWCharValue;
            } else if (arg instanceof SizeT) {
                type2 = NativeConstants.ValueType.eSizeTValue;
                args[i2] = arg = Long.valueOf(((SizeT)arg).longValue());
            } else if (arg instanceof CLong) {
                type2 = NativeConstants.ValueType.eCLongValue;
                args[i2] = arg = Long.valueOf(((CLong)arg).longValue());
            } else if (arg instanceof NativeObject) {
                type2 = NativeConstants.ValueType.eNativeObjectValue;
            } else {
                throw new IllegalArgumentException("Argument type not handled in variable argument calls  : " + arg + " (" + arg.getClass().getName() + ")");
            }
            buf.put(i2, type2.ordinal());
        }
        return buf;
    }
}

