/*
 * Decompiled with CFR 0.152.
 */
package org.bridj.cpp.std;

import java.lang.reflect.Type;
import java.util.NoSuchElementException;
import org.bridj.BridJ;
import org.bridj.Pointer;
import org.bridj.ann.Field;
import org.bridj.ann.Struct;
import org.bridj.ann.Template;
import org.bridj.cpp.CPPObject;
import org.bridj.cpp.CPPRuntime;
import org.bridj.cpp.std.STL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Template(value={Type.class})
@Struct(customizer=STL.class)
public class vector<T>
extends CPPObject {
    @Deprecated
    @Field(value=0)
    public Pointer<T> _M_start() {
        return this.io.getPointerField(this, 0);
    }

    @Deprecated
    @Field(value=1)
    public Pointer<T> _M_finish() {
        return this.io.getPointerField(this, 1);
    }

    @Deprecated
    @Field(value=2)
    public Pointer<T> _M_end_of_storage() {
        return this.io.getPointerField(this, 2);
    }

    public vector(Type t) {
        super((Void)null, -2, t);
    }

    public vector(Pointer<? extends vector<T>> peer, Type t) {
        super((Pointer<? extends CPPObject>)peer, new Object[]{t});
        if (!this.isValid()) {
            throw new RuntimeException("Invalid vector internal data ! Are you trying to use an unsupported version of the STL ?");
        }
    }

    protected boolean isValid() {
        long start = Pointer.getPeer(this._M_start());
        long finish = Pointer.getPeer(this._M_finish());
        long eos = Pointer.getPeer(this._M_end_of_storage());
        if (start == 0L || finish == 0L || eos == 0L) {
            return false;
        }
        return start <= finish && finish <= eos;
    }

    private void checkNotEmpty() {
        this.checkIndex(0L);
    }

    private void checkIndex(long i2) {
        long size = this.size();
        if (i2 < 0L || i2 >= size) {
            throw new NoSuchElementException("index " + i2 + " (size = " + size + ")");
        }
    }

    public boolean empty() {
        return this.size() == 0L;
    }

    public T get(long index) {
        this.checkIndex(index);
        Pointer p = this._M_start().as(this.T());
        return (T)p.get(index);
    }

    public T get(int index) {
        return this.get((long)index);
    }

    public T front() {
        return this.get(0);
    }

    public T back() {
        return this.get(this.size() - 1L);
    }

    public void push_back(T value) {
        throw new UnsupportedOperationException();
    }

    protected Type T() {
        CPPRuntime.getInstance();
        return (Type)CPPRuntime.getTemplateParameters(this, vector.class)[0];
    }

    protected long byteSize() {
        return this._M_finish().getPeer() - this._M_start().getPeer();
    }

    public long size() {
        long byteSize = this.byteSize();
        long elementSize = BridJ.sizeOf(this.T());
        return byteSize / elementSize;
    }
}

