/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.jlargearrays;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.math3.util.FastMath;
import pl.edu.icm.jlargearrays.ConcurrencyUtils;
import pl.edu.icm.jlargearrays.LargeArray;
import pl.edu.icm.jlargearrays.LargeArrayType;
import pl.edu.icm.jlargearrays.LargeArrayUtils;
import pl.edu.icm.jlargearrays.MemoryCounter;
import sun.misc.Cleaner;

public class LogicLargeArray
extends LargeArray {
    private static final long serialVersionUID = 3135411647668758832L;
    private byte[] data;

    public LogicLargeArray(long length) {
        this(length, true);
    }

    public LogicLargeArray(long length, boolean zeroNativeMemory) {
        this.type = LargeArrayType.LOGIC;
        this.sizeof = 1L;
        if (length <= 0L) {
            throw new IllegalArgumentException(length + " is not a positive long value");
        }
        this.length = length;
        if (length > (long)LogicLargeArray.getMaxSizeOf32bitArray()) {
            this.ptr = LargeArrayUtils.UNSAFE.allocateMemory(this.length * this.sizeof);
            if (zeroNativeMemory) {
                this.zeroNativeMemory(length);
            }
            Cleaner.create((Object)this, (Runnable)new LargeArray.Deallocator(this.ptr, this.length, this.sizeof));
            MemoryCounter.increaseCounter(this.length * this.sizeof);
        } else {
            this.data = new byte[(int)length];
        }
    }

    public LogicLargeArray(long length, byte constantValue) {
        this.type = LargeArrayType.LOGIC;
        this.sizeof = 1L;
        if (length <= 0L) {
            throw new IllegalArgumentException(length + " is not a positive long value");
        }
        this.length = length;
        this.isConstant = true;
        this.data = new byte[]{constantValue != 0 ? (byte)1 : 0};
    }

    public LogicLargeArray(byte[] data) {
        this.type = LargeArrayType.LOGIC;
        this.sizeof = 1L;
        this.length = data.length;
        for (int i2 = 0; i2 < data.length; ++i2) {
            if (data[i2] == 0 || data[i2] == 1) continue;
            throw new IllegalArgumentException("The array contans values different than 0 and 1.");
        }
        this.data = data;
    }

    public LogicLargeArray(boolean[] data) {
        this.type = LargeArrayType.LOGIC;
        this.sizeof = 1L;
        this.length = data.length;
        this.data = new byte[data.length];
        for (int i2 = 0; i2 < data.length; ++i2) {
            this.data[i2] = data[i2] ? (byte)1 : 0;
        }
    }

    @Override
    public LogicLargeArray clone() {
        if (this.isConstant) {
            return new LogicLargeArray(this.length, this.getByte(0L));
        }
        LogicLargeArray v = new LogicLargeArray(this.length, false);
        LargeArrayUtils.arraycopy(this, 0L, v, 0L, this.length);
        return v;
    }

    @Override
    public boolean equals(Object o2) {
        if (super.equals(o2)) {
            LogicLargeArray la = (LogicLargeArray)o2;
            return this.data == la.data;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 29 * super.hashCode() + (this.data != null ? this.data.hashCode() : 0);
    }

    @Override
    public final Byte get(long i2) {
        return this.getByte(i2);
    }

    @Override
    public final Byte getFromNative(long i2) {
        return LargeArrayUtils.UNSAFE.getByte(this.ptr + i2);
    }

    @Override
    public final boolean getBoolean(long i2) {
        if (this.ptr != 0L) {
            return LargeArrayUtils.UNSAFE.getByte(this.ptr + i2) != 0;
        }
        if (this.isConstant) {
            return this.data[0] != 0;
        }
        return this.data[(int)i2] != 0;
    }

    @Override
    public final byte getByte(long i2) {
        if (this.ptr != 0L) {
            return LargeArrayUtils.UNSAFE.getByte(this.ptr + i2);
        }
        if (this.isConstant) {
            return this.data[0];
        }
        return this.data[(int)i2];
    }

    @Override
    public final short getUnsignedByte(long i2) {
        return this.getByte(i2);
    }

    @Override
    public final short getShort(long i2) {
        if (this.ptr != 0L) {
            return LargeArrayUtils.UNSAFE.getByte(this.ptr + i2);
        }
        if (this.isConstant) {
            return this.data[0];
        }
        return this.data[(int)i2];
    }

    @Override
    public final int getInt(long i2) {
        if (this.ptr != 0L) {
            return LargeArrayUtils.UNSAFE.getByte(this.ptr + i2);
        }
        if (this.isConstant) {
            return this.data[0];
        }
        return this.data[(int)i2];
    }

    @Override
    public final long getLong(long i2) {
        if (this.ptr != 0L) {
            return LargeArrayUtils.UNSAFE.getByte(this.ptr + i2);
        }
        if (this.isConstant) {
            return this.data[0];
        }
        return this.data[(int)i2];
    }

    @Override
    public final float getFloat(long i2) {
        if (this.ptr != 0L) {
            return LargeArrayUtils.UNSAFE.getByte(this.ptr + i2);
        }
        if (this.isConstant) {
            return this.data[0];
        }
        return this.data[(int)i2];
    }

    @Override
    public final double getDouble(long i2) {
        if (this.ptr != 0L) {
            return LargeArrayUtils.UNSAFE.getByte(this.ptr + i2);
        }
        if (this.isConstant) {
            return this.data[0];
        }
        return this.data[(int)i2];
    }

    @Override
    public final boolean[] getBooleanData(boolean[] a2, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len2 = (long)FastMath.ceil((double)(endPos - startPos) / (double)step);
        if (len2 > 0x40000000L) {
            return null;
        }
        boolean[] out = a2 != null && (long)a2.length >= len2 ? a2 : new boolean[(int)len2];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i2 = startPos; i2 < endPos; i2 += step) {
                byte v = LargeArrayUtils.UNSAFE.getByte(this.ptr + i2);
                out[idx++] = v == 1;
            }
        } else if (this.isConstant) {
            boolean elem = this.data[0] != 0;
            for (long i3 = startPos; i3 < endPos; i3 += step) {
                out[idx++] = elem;
            }
        } else {
            for (long i4 = startPos; i4 < endPos; i4 += step) {
                byte v = this.data[(int)i4];
                out[idx++] = v != 0;
            }
        }
        return out;
    }

    @Override
    public final boolean[] getBooleanData() {
        if (this.length > 0x40000000L) {
            return null;
        }
        boolean[] out = new boolean[(int)this.length];
        if (this.ptr != 0L) {
            int i2 = 0;
            while ((long)i2 < this.length) {
                byte v = LargeArrayUtils.UNSAFE.getByte(this.ptr + this.sizeof * (long)i2);
                out[i2] = v != 0;
                ++i2;
            }
        } else if (this.isConstant) {
            boolean elem = this.data[0] != 0;
            int i3 = 0;
            while ((long)i3 < this.length) {
                out[i3] = elem;
                ++i3;
            }
        } else {
            int i4 = 0;
            while ((long)i4 < this.length) {
                out[i4] = this.data[i4] != 0;
                ++i4;
            }
        }
        return out;
    }

    public final byte[] getData() {
        return this.data;
    }

    @Override
    public final byte[] getByteData() {
        if (this.length > 0x40000000L) {
            return null;
        }
        byte[] out = new byte[(int)this.length];
        if (this.ptr != 0L) {
            int i2 = 0;
            while ((long)i2 < this.length) {
                out[i2] = LargeArrayUtils.UNSAFE.getByte(this.ptr + this.sizeof * (long)i2);
                ++i2;
            }
        } else if (this.isConstant) {
            byte elem = this.data[0];
            int i3 = 0;
            while ((long)i3 < this.length) {
                out[i3] = elem;
                ++i3;
            }
        } else {
            System.arraycopy(this.data, 0, out, 0, (int)this.length);
        }
        return out;
    }

    @Override
    public final byte[] getByteData(byte[] a2, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len2 = (long)FastMath.ceil((double)(endPos - startPos) / (double)step);
        if (len2 > 0x40000000L) {
            return null;
        }
        byte[] out = a2 != null && (long)a2.length >= len2 ? a2 : new byte[(int)len2];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i2 = startPos; i2 < endPos; i2 += step) {
                out[idx++] = LargeArrayUtils.UNSAFE.getByte(this.ptr + i2);
            }
        } else if (this.isConstant) {
            for (long i3 = startPos; i3 < endPos; i3 += step) {
                out[idx++] = this.data[0];
            }
        } else {
            for (long i4 = startPos; i4 < endPos; i4 += step) {
                out[idx++] = this.data[(int)i4];
            }
        }
        return out;
    }

    @Override
    public final short[] getShortData() {
        if (this.length > 0x40000000L) {
            return null;
        }
        short[] out = new short[(int)this.length];
        if (this.ptr != 0L) {
            int i2 = 0;
            while ((long)i2 < this.length) {
                out[i2] = LargeArrayUtils.UNSAFE.getByte(this.ptr + this.sizeof * (long)i2);
                ++i2;
            }
        } else if (this.isConstant) {
            byte elem = this.data[0];
            int i3 = 0;
            while ((long)i3 < this.length) {
                out[i3] = elem;
                ++i3;
            }
        } else {
            int i4 = 0;
            while ((long)i4 < this.length) {
                out[i4] = this.data[i4];
                ++i4;
            }
        }
        return out;
    }

    @Override
    public final short[] getShortData(short[] a2, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len2 = (long)FastMath.ceil((double)(endPos - startPos) / (double)step);
        if (len2 > 0x40000000L) {
            return null;
        }
        short[] out = a2 != null && (long)a2.length >= len2 ? a2 : new short[(int)len2];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i2 = startPos; i2 < endPos; i2 += step) {
                out[idx++] = LargeArrayUtils.UNSAFE.getByte(this.ptr + i2);
            }
        } else if (this.isConstant) {
            for (long i3 = startPos; i3 < endPos; i3 += step) {
                out[idx++] = this.data[0];
            }
        } else {
            for (long i4 = startPos; i4 < endPos; i4 += step) {
                out[idx++] = this.data[(int)i4];
            }
        }
        return out;
    }

    @Override
    public final int[] getIntData() {
        if (this.length > 0x40000000L) {
            return null;
        }
        int[] out = new int[(int)this.length];
        if (this.ptr != 0L) {
            int i2 = 0;
            while ((long)i2 < this.length) {
                out[i2] = LargeArrayUtils.UNSAFE.getByte(this.ptr + this.sizeof * (long)i2);
                ++i2;
            }
        } else if (this.isConstant) {
            int elem = this.data[0];
            int i3 = 0;
            while ((long)i3 < this.length) {
                out[i3] = elem;
                ++i3;
            }
        } else {
            int i4 = 0;
            while ((long)i4 < this.length) {
                out[i4] = this.data[i4];
                ++i4;
            }
        }
        return out;
    }

    @Override
    public final int[] getIntData(int[] a2, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len2 = (long)FastMath.ceil((double)(endPos - startPos) / (double)step);
        if (len2 > 0x40000000L) {
            return null;
        }
        int[] out = a2 != null && (long)a2.length >= len2 ? a2 : new int[(int)len2];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i2 = startPos; i2 < endPos; i2 += step) {
                out[idx++] = LargeArrayUtils.UNSAFE.getByte(this.ptr + i2);
            }
        } else if (this.isConstant) {
            for (long i3 = startPos; i3 < endPos; i3 += step) {
                out[idx++] = this.data[0];
            }
        } else {
            for (long i4 = startPos; i4 < endPos; i4 += step) {
                out[idx++] = this.data[(int)i4];
            }
        }
        return out;
    }

    @Override
    public final long[] getLongData() {
        if (this.length > 0x40000000L) {
            return null;
        }
        long[] out = new long[(int)this.length];
        if (this.ptr != 0L) {
            int i2 = 0;
            while ((long)i2 < this.length) {
                out[i2] = LargeArrayUtils.UNSAFE.getByte(this.ptr + this.sizeof * (long)i2);
                ++i2;
            }
        } else if (this.isConstant) {
            byte elem = this.data[0];
            int i3 = 0;
            while ((long)i3 < this.length) {
                out[i3] = elem;
                ++i3;
            }
        } else {
            int i4 = 0;
            while ((long)i4 < this.length) {
                out[i4] = this.data[i4];
                ++i4;
            }
        }
        return out;
    }

    @Override
    public final long[] getLongData(long[] a2, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len2 = (long)FastMath.ceil((double)(endPos - startPos) / (double)step);
        if (len2 > 0x40000000L) {
            return null;
        }
        long[] out = a2 != null && (long)a2.length >= len2 ? a2 : new long[(int)len2];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i2 = startPos; i2 < endPos; i2 += step) {
                out[idx++] = LargeArrayUtils.UNSAFE.getByte(this.ptr + i2);
            }
        } else if (this.isConstant) {
            for (long i3 = startPos; i3 < endPos; i3 += step) {
                out[idx++] = this.data[0];
            }
        } else {
            for (long i4 = startPos; i4 < endPos; i4 += step) {
                out[idx++] = this.data[(int)i4];
            }
        }
        return out;
    }

    @Override
    public final float[] getFloatData() {
        if (this.length > 0x40000000L) {
            return null;
        }
        float[] out = new float[(int)this.length];
        if (this.ptr != 0L) {
            int i2 = 0;
            while ((long)i2 < this.length) {
                out[i2] = LargeArrayUtils.UNSAFE.getByte(this.ptr + this.sizeof * (long)i2);
                ++i2;
            }
        } else if (this.isConstant) {
            float elem = this.data[0];
            int i3 = 0;
            while ((long)i3 < this.length) {
                out[i3] = elem;
                ++i3;
            }
        } else {
            int i4 = 0;
            while ((long)i4 < this.length) {
                out[i4] = this.data[i4];
                ++i4;
            }
        }
        return out;
    }

    @Override
    public final float[] getFloatData(float[] a2, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len2 = (long)FastMath.ceil((double)(endPos - startPos) / (double)step);
        if (len2 > 0x40000000L) {
            return null;
        }
        float[] out = a2 != null && (long)a2.length >= len2 ? a2 : new float[(int)len2];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i2 = startPos; i2 < endPos; i2 += step) {
                out[idx++] = LargeArrayUtils.UNSAFE.getByte(this.ptr + i2);
            }
        } else if (this.isConstant) {
            for (long i3 = startPos; i3 < endPos; i3 += step) {
                out[idx++] = this.data[0];
            }
        } else {
            for (long i4 = startPos; i4 < endPos; i4 += step) {
                out[idx++] = this.data[(int)i4];
            }
        }
        return out;
    }

    @Override
    public final double[] getDoubleData() {
        if (this.length > 0x40000000L) {
            return null;
        }
        double[] out = new double[(int)this.length];
        if (this.ptr != 0L) {
            int i2 = 0;
            while ((long)i2 < this.length) {
                out[i2] = LargeArrayUtils.UNSAFE.getByte(this.ptr + this.sizeof * (long)i2);
                ++i2;
            }
        } else if (this.isConstant) {
            double elem = this.data[0];
            int i3 = 0;
            while ((long)i3 < this.length) {
                out[i3] = elem;
                ++i3;
            }
        } else {
            int i4 = 0;
            while ((long)i4 < this.length) {
                out[i4] = this.data[i4];
                ++i4;
            }
        }
        return out;
    }

    @Override
    public final double[] getDoubleData(double[] a2, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len2 = (long)FastMath.ceil((double)(endPos - startPos) / (double)step);
        if (len2 > 0x40000000L) {
            return null;
        }
        double[] out = a2 != null && (long)a2.length >= len2 ? a2 : new double[(int)len2];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i2 = startPos; i2 < endPos; i2 += step) {
                out[idx++] = LargeArrayUtils.UNSAFE.getByte(this.ptr + i2);
            }
        } else if (this.isConstant) {
            for (long i3 = startPos; i3 < endPos; i3 += step) {
                out[idx++] = this.data[0];
            }
        } else {
            for (long i4 = startPos; i4 < endPos; i4 += step) {
                out[idx++] = this.data[(int)i4];
            }
        }
        return out;
    }

    @Override
    public final void setToNative(long i2, Object value) {
        LargeArrayUtils.UNSAFE.putByte(this.ptr + i2, (Byte)value);
    }

    @Override
    public final void setBoolean(long i2, boolean value) {
        if (this.ptr != 0L) {
            LargeArrayUtils.UNSAFE.putByte(this.ptr + i2, value ? (byte)1 : 0);
        } else {
            if (this.isConstant) {
                throw new IllegalAccessError("Constant arrays cannot be modified.");
            }
            this.data[(int)i2] = value ? (byte)1 : 0;
        }
    }

    @Override
    public final void setByte(long i2, byte value) {
        if (value < 0 || value > 1) {
            throw new IllegalArgumentException("The value has to be 0 or 1.");
        }
        if (this.ptr != 0L) {
            LargeArrayUtils.UNSAFE.putByte(this.ptr + i2, value);
        } else {
            if (this.isConstant) {
                throw new IllegalAccessError("Constant arrays cannot be modified.");
            }
            this.data[(int)i2] = value;
        }
    }

    @Override
    public final void setUnsignedByte(long i2, short value) {
        this.setShort(i2, value);
    }

    @Override
    public final void setShort(long i2, short value) {
        if (value < 0 || value > 1) {
            throw new IllegalArgumentException("The value has to be 0 or 1.");
        }
        if (this.ptr != 0L) {
            LargeArrayUtils.UNSAFE.putByte(this.ptr + i2, (byte)value);
        } else {
            if (this.isConstant) {
                throw new IllegalAccessError("Constant arrays cannot be modified.");
            }
            this.data[(int)i2] = (byte)value;
        }
    }

    @Override
    public final void setInt(long i2, int value) {
        if (value < 0 || value > 1) {
            throw new IllegalArgumentException("The value has to be 0 or 1.");
        }
        if (this.ptr != 0L) {
            LargeArrayUtils.UNSAFE.putByte(this.ptr + i2, (byte)value);
        } else {
            if (this.isConstant) {
                throw new IllegalAccessError("Constant arrays cannot be modified.");
            }
            this.data[(int)i2] = (byte)value;
        }
    }

    @Override
    public final void setLong(long i2, long value) {
        if (value < 0L || value > 1L) {
            throw new IllegalArgumentException("The value has to be 0 or 1.");
        }
        if (this.ptr != 0L) {
            LargeArrayUtils.UNSAFE.putByte(this.ptr + i2, (byte)value);
        } else {
            if (this.isConstant) {
                throw new IllegalAccessError("Constant arrays cannot be modified.");
            }
            this.data[(int)i2] = (byte)value;
        }
    }

    @Override
    public final void setFloat(long i2, float value) {
        if ((double)value != 0.0 && (double)value != 1.0) {
            throw new IllegalArgumentException("The value has to be 0 or 1.");
        }
        if (this.ptr != 0L) {
            LargeArrayUtils.UNSAFE.putByte(this.ptr + i2, (byte)value);
        } else {
            if (this.isConstant) {
                throw new IllegalAccessError("Constant arrays cannot be modified.");
            }
            this.data[(int)i2] = (byte)value;
        }
    }

    @Override
    public final void setDouble(long i2, double value) {
        if (value != 0.0 && value != 1.0) {
            throw new IllegalArgumentException("The value has to be 0 or 1.");
        }
        if (this.ptr != 0L) {
            LargeArrayUtils.UNSAFE.putByte(this.ptr + i2, (byte)value);
        } else {
            if (this.isConstant) {
                throw new IllegalAccessError("Constant arrays cannot be modified.");
            }
            this.data[(int)i2] = (byte)value;
        }
    }

    public LogicLargeArray and(final LogicLargeArray array) {
        if (array == null || array.length() != this.length) {
            throw new IllegalArgumentException("array == null || array.length() != length");
        }
        final LogicLargeArray out = new LogicLargeArray(array.length(), false);
        int nthreads = (int)FastMath.min(this.length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads <= 2 || this.length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long i2 = 0L; i2 < this.length; ++i2) {
                out.setByte(i2, (byte)(this.getByte(i2) & array.getByte(i2)));
            }
        } else {
            long i3;
            long k2 = this.length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j2 = 0; j2 < nthreads; ++j2) {
                final long firstIdx = (long)j2 * k2;
                final long lastIdx = j2 == nthreads - 1 ? this.length : firstIdx + k2;
                threads[j2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                            out.setByte(k2, (byte)(LogicLargeArray.this.getByte(k2) & array.getByte(k2)));
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                for (i3 = 0L; i3 < this.length; ++i3) {
                    out.setByte(i3, (byte)(this.getByte(i3) & array.getByte(i3)));
                }
            }
            catch (ExecutionException ex) {
                for (i3 = 0L; i3 < this.length; ++i3) {
                    out.setByte(i3, (byte)(this.getByte(i3) & array.getByte(i3)));
                }
            }
        }
        return out;
    }

    public LogicLargeArray or(final LogicLargeArray array) {
        if (array == null || array.length() != this.length) {
            throw new IllegalArgumentException("array == null || array.length() != length");
        }
        final LogicLargeArray out = new LogicLargeArray(array.length(), false);
        int nthreads = (int)FastMath.min(this.length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads <= 2 || this.length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long i2 = 0L; i2 < this.length; ++i2) {
                out.setByte(i2, (byte)(this.getByte(i2) | array.getByte(i2)));
            }
        } else {
            long i3;
            long k2 = this.length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j2 = 0; j2 < nthreads; ++j2) {
                final long firstIdx = (long)j2 * k2;
                final long lastIdx = j2 == nthreads - 1 ? this.length : firstIdx + k2;
                threads[j2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                            out.setByte(k2, (byte)(LogicLargeArray.this.getByte(k2) | array.getByte(k2)));
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                for (i3 = 0L; i3 < this.length; ++i3) {
                    out.setByte(i3, (byte)(this.getByte(i3) | array.getByte(i3)));
                }
            }
            catch (ExecutionException ex) {
                for (i3 = 0L; i3 < this.length; ++i3) {
                    out.setByte(i3, (byte)(this.getByte(i3) | array.getByte(i3)));
                }
            }
        }
        return out;
    }

    public LogicLargeArray xor(final LogicLargeArray array) {
        if (array == null || array.length() != this.length) {
            throw new IllegalArgumentException("array == null || array.length() != length");
        }
        final LogicLargeArray out = new LogicLargeArray(array.length(), false);
        int nthreads = (int)FastMath.min(this.length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads <= 2 || this.length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long i2 = 0L; i2 < this.length; ++i2) {
                out.setByte(i2, (byte)(this.getByte(i2) ^ array.getByte(i2)));
            }
        } else {
            long i3;
            long k2 = this.length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j2 = 0; j2 < nthreads; ++j2) {
                final long firstIdx = (long)j2 * k2;
                final long lastIdx = j2 == nthreads - 1 ? this.length : firstIdx + k2;
                threads[j2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                            out.setByte(k2, (byte)(LogicLargeArray.this.getByte(k2) ^ array.getByte(k2)));
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                for (i3 = 0L; i3 < this.length; ++i3) {
                    out.setByte(i3, (byte)(this.getByte(i3) ^ array.getByte(i3)));
                }
            }
            catch (ExecutionException ex) {
                for (i3 = 0L; i3 < this.length; ++i3) {
                    out.setByte(i3, (byte)(this.getByte(i3) ^ array.getByte(i3)));
                }
            }
        }
        return out;
    }

    public LogicLargeArray not() {
        final LogicLargeArray out = new LogicLargeArray(this.length, false);
        int nthreads = (int)FastMath.min(this.length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads <= 2 || this.length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long i2 = 0L; i2 < this.length; ++i2) {
                out.setByte(i2, (byte)(1 - this.getByte(i2)));
            }
        } else {
            long i3;
            long k2 = this.length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j2 = 0; j2 < nthreads; ++j2) {
                final long firstIdx = (long)j2 * k2;
                final long lastIdx = j2 == nthreads - 1 ? this.length : firstIdx + k2;
                threads[j2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                            out.setByte(k2, (byte)(1 - LogicLargeArray.this.getByte(k2)));
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                for (i3 = 0L; i3 < this.length; ++i3) {
                    out.setByte(i3, (byte)(1 - this.getByte(i3)));
                }
            }
            catch (ExecutionException ex) {
                for (i3 = 0L; i3 < this.length; ++i3) {
                    out.setByte(i3, (byte)(1 - this.getByte(i3)));
                }
            }
        }
        return out;
    }
}

