/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.jlargearrays;

import java.io.UnsupportedEncodingException;
import org.apache.commons.math3.util.FastMath;
import pl.edu.icm.jlargearrays.LargeArray;
import pl.edu.icm.jlargearrays.LargeArrayType;
import pl.edu.icm.jlargearrays.LargeArrayUtils;
import pl.edu.icm.jlargearrays.MemoryCounter;
import pl.edu.icm.jlargearrays.ShortLargeArray;
import sun.misc.Cleaner;

public class StringLargeArray
extends LargeArray {
    private static final long serialVersionUID = -4096759496772248522L;
    private String[] data;
    private ShortLargeArray stringLengths;
    private int maxStringLength;
    private long size;
    private byte[] byteArray;
    private static final String CHARSET = "UTF-8";
    private static final int CHARSET_SIZE = 4;

    public StringLargeArray(long length) {
        this(length, 100);
    }

    public StringLargeArray(long length, int maxStringLength) {
        this(length, maxStringLength, true);
    }

    public StringLargeArray(long length, int maxStringLength, boolean zeroNativeMemory) {
        this.type = LargeArrayType.STRING;
        this.sizeof = 1L;
        if (length <= 0L) {
            throw new IllegalArgumentException(length + " is not a positive long value.");
        }
        if (maxStringLength <= 0) {
            throw new IllegalArgumentException(maxStringLength + " is not a positive int value.");
        }
        this.length = length;
        this.size = length * (long)maxStringLength * 4L;
        this.maxStringLength = maxStringLength;
        if (length > (long)StringLargeArray.getMaxSizeOf32bitArray()) {
            this.ptr = LargeArrayUtils.UNSAFE.allocateMemory(this.size * this.sizeof);
            if (zeroNativeMemory) {
                this.zeroNativeMemory(this.size);
            }
            Cleaner.create((Object)this, (Runnable)new LargeArray.Deallocator(this.ptr, this.size, this.sizeof));
            MemoryCounter.increaseCounter(this.size * this.sizeof);
            this.stringLengths = new ShortLargeArray(length);
            this.byteArray = new byte[maxStringLength * 4];
        } else {
            this.data = new String[(int)length];
        }
    }

    public StringLargeArray(long length, String constantValue) {
        this.type = LargeArrayType.STRING;
        this.sizeof = 1L;
        if (length <= 0L) {
            throw new IllegalArgumentException(length + " is not a positive long value");
        }
        this.length = length;
        this.isConstant = true;
        this.data = new String[]{constantValue};
    }

    public StringLargeArray(String[] data) {
        this.type = LargeArrayType.STRING;
        this.sizeof = 1L;
        this.length = data.length;
        this.data = data;
    }

    @Override
    public StringLargeArray clone() {
        if (this.isConstant) {
            return new StringLargeArray(this.length, this.get(0L));
        }
        StringLargeArray v = new StringLargeArray(this.length, FastMath.max(1, this.maxStringLength), false);
        LargeArrayUtils.arraycopy(this, 0L, v, 0L, this.length);
        return v;
    }

    @Override
    public boolean equals(Object o2) {
        if (super.equals(o2)) {
            boolean res;
            StringLargeArray la = (StringLargeArray)o2;
            boolean bl = res = this.maxStringLength == la.maxStringLength && this.data == la.data;
            if (this.stringLengths != null && la.stringLengths != null) {
                return res && this.stringLengths.equals(la.stringLengths);
            }
            if (this.stringLengths == la.stringLengths) {
                return res;
            }
            return false;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 29 * super.hashCode() + (this.data != null ? this.data.hashCode() : 0);
        hash = 29 * hash + (this.maxStringLength ^ this.maxStringLength >>> 16);
        return 29 * hash + (this.stringLengths != null ? this.stringLengths.hashCode() : 0);
    }

    @Override
    public final String get(long i2) {
        if (this.ptr != 0L) {
            int strLen = this.stringLengths.getShort(i2);
            if (strLen < 0) {
                return null;
            }
            long offset = this.sizeof * i2 * (long)this.maxStringLength * 4L;
            for (int j2 = 0; j2 < strLen; ++j2) {
                this.byteArray[j2] = LargeArrayUtils.UNSAFE.getByte(this.ptr + offset + this.sizeof * (long)j2);
            }
            try {
                return new String(this.byteArray, 0, strLen, CHARSET);
            }
            catch (UnsupportedEncodingException ex) {
                return null;
            }
        }
        if (this.isConstant) {
            return this.data[0];
        }
        return this.data[(int)i2];
    }

    @Override
    public final String getFromNative(long i2) {
        int strLen = this.stringLengths.getShort(i2);
        if (strLen < 0) {
            return null;
        }
        long offset = this.sizeof * i2 * (long)this.maxStringLength * 4L;
        for (int j2 = 0; j2 < strLen; ++j2) {
            this.byteArray[j2] = LargeArrayUtils.UNSAFE.getByte(this.ptr + offset + this.sizeof * (long)j2);
        }
        try {
            return new String(this.byteArray, 0, strLen, CHARSET);
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
    }

    @Override
    public final boolean getBoolean(long i2) {
        String s = this.get(i2);
        return s != null ? s.length() != 0 : false;
    }

    @Override
    public final byte getByte(long i2) {
        String s = this.get(i2);
        return (byte)(s != null ? s.length() : 0);
    }

    @Override
    public final short getUnsignedByte(long i2) {
        String s = this.get(i2);
        return (short)(s != null ? 0xFF & s.length() : 0);
    }

    @Override
    public final short getShort(long i2) {
        String s = this.get(i2);
        return (short)(s != null ? s.length() : 0);
    }

    @Override
    public final int getInt(long i2) {
        String s = this.get(i2);
        return s != null ? s.length() : 0;
    }

    @Override
    public final long getLong(long i2) {
        String s = this.get(i2);
        return s != null ? s.length() : 0;
    }

    @Override
    public final float getFloat(long i2) {
        String s = this.get(i2);
        return s != null ? s.length() : 0;
    }

    @Override
    public final double getDouble(long i2) {
        String s = this.get(i2);
        return s != null ? s.length() : 0;
    }

    public final String[] getData() {
        return this.data;
    }

    @Override
    public final boolean[] getBooleanData() {
        if (this.length > 0x40000000L) {
            return null;
        }
        boolean[] out = new boolean[(int)this.length];
        if (this.ptr != 0L) {
            int i2 = 0;
            while ((long)i2 < this.length) {
                short strLen = this.stringLengths.getShort(i2);
                out[i2] = strLen != 0;
                ++i2;
            }
        } else if (this.isConstant) {
            boolean elem = this.data[0] != null ? this.data[0].length() != 0 : false;
            int i3 = 0;
            while ((long)i3 < this.length) {
                out[i3] = elem;
                ++i3;
            }
        } else {
            int i4 = 0;
            while ((long)i4 < this.length) {
                out[i4] = this.data[i4] != null ? this.data[i4].length() != 0 : false;
                ++i4;
            }
        }
        return out;
    }

    @Override
    public final boolean[] getBooleanData(boolean[] a2, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len2 = (long)FastMath.ceil((double)(endPos - startPos) / (double)step);
        if (len2 > 0x40000000L) {
            return null;
        }
        boolean[] out = a2 != null && (long)a2.length >= len2 ? a2 : new boolean[(int)len2];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i2 = startPos; i2 < endPos; i2 += step) {
                short strLen = this.stringLengths.getShort(i2);
                out[idx++] = strLen > 0;
            }
        } else if (this.isConstant) {
            boolean elem = this.data[0] != null ? this.data[0].length() != 0 : false;
            for (long i3 = startPos; i3 < endPos; i3 += step) {
                out[idx++] = elem;
            }
        } else {
            for (long i4 = startPos; i4 < endPos; i4 += step) {
                int v = this.data[(int)i4] != null ? this.data[(int)i4].length() : 0;
                out[idx++] = v != 0;
            }
        }
        return out;
    }

    @Override
    public final byte[] getByteData() {
        if (this.length > 0x40000000L) {
            return null;
        }
        byte[] out = new byte[(int)this.length];
        if (this.ptr != 0L) {
            int i2 = 0;
            while ((long)i2 < this.length) {
                out[i2] = (byte)this.stringLengths.getShort(i2);
                ++i2;
            }
        } else if (this.isConstant) {
            byte elem = (byte)(this.data[0] != null ? this.data[0].length() : 0);
            int i3 = 0;
            while ((long)i3 < this.length) {
                out[i3] = elem;
                ++i3;
            }
        } else {
            int i4 = 0;
            while ((long)i4 < this.length) {
                out[i4] = (byte)(this.data[i4] != null ? this.data[i4].length() : 0);
                ++i4;
            }
        }
        return out;
    }

    @Override
    public final byte[] getByteData(byte[] a2, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len2 = (long)FastMath.ceil((double)(endPos - startPos) / (double)step);
        if (len2 > 0x40000000L) {
            return null;
        }
        byte[] out = a2 != null && (long)a2.length >= len2 ? a2 : new byte[(int)len2];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i2 = startPos; i2 < endPos; i2 += step) {
                out[idx++] = (byte)this.stringLengths.getShort(i2);
            }
        } else if (this.isConstant) {
            for (long i3 = startPos; i3 < endPos; i3 += step) {
                out[idx++] = (byte)(this.data[0] != null ? this.data[0].length() : 0);
            }
        } else {
            for (long i4 = startPos; i4 < endPos; i4 += step) {
                out[idx++] = (byte)(this.data[(int)i4] != null ? this.data[(int)i4].length() : 0);
            }
        }
        return out;
    }

    @Override
    public final short[] getShortData() {
        if (this.length > 0x40000000L) {
            return null;
        }
        short[] out = new short[(int)this.length];
        if (this.ptr != 0L) {
            int i2 = 0;
            while ((long)i2 < this.length) {
                out[i2] = this.stringLengths.getShort(i2);
                ++i2;
            }
        } else if (this.isConstant) {
            short elem = (short)(this.data[0] != null ? this.data[0].length() : 0);
            int i3 = 0;
            while ((long)i3 < this.length) {
                out[i3] = elem;
                ++i3;
            }
        } else {
            int i4 = 0;
            while ((long)i4 < this.length) {
                out[i4] = (short)(this.data[i4] != null ? this.data[i4].length() : 0);
                ++i4;
            }
        }
        return out;
    }

    @Override
    public final short[] getShortData(short[] a2, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len2 = (long)FastMath.ceil((double)(endPos - startPos) / (double)step);
        if (len2 > 0x40000000L) {
            return null;
        }
        short[] out = a2 != null && (long)a2.length >= len2 ? a2 : new short[(int)len2];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i2 = startPos; i2 < endPos; i2 += step) {
                out[idx++] = this.stringLengths.getShort(i2);
            }
        } else if (this.isConstant) {
            for (long i3 = startPos; i3 < endPos; i3 += step) {
                out[idx++] = (short)(this.data[0] != null ? this.data[0].length() : 0);
            }
        } else {
            for (long i4 = startPos; i4 < endPos; i4 += step) {
                out[idx++] = (short)(this.data[(int)i4] != null ? this.data[(int)i4].length() : 0);
            }
        }
        return out;
    }

    @Override
    public final int[] getIntData() {
        if (this.length > 0x40000000L) {
            return null;
        }
        int[] out = new int[(int)this.length];
        if (this.ptr != 0L) {
            int i2 = 0;
            while ((long)i2 < this.length) {
                out[i2] = this.stringLengths.getShort(i2);
                ++i2;
            }
        } else if (this.isConstant) {
            int elem = this.data[0] != null ? this.data[0].length() : 0;
            int i3 = 0;
            while ((long)i3 < this.length) {
                out[i3] = elem;
                ++i3;
            }
        } else {
            int i4 = 0;
            while ((long)i4 < this.length) {
                out[i4] = this.data[i4] != null ? this.data[i4].length() : 0;
                ++i4;
            }
        }
        return out;
    }

    @Override
    public final int[] getIntData(int[] a2, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len2 = (long)FastMath.ceil((double)(endPos - startPos) / (double)step);
        if (len2 > 0x40000000L) {
            return null;
        }
        int[] out = a2 != null && (long)a2.length >= len2 ? a2 : new int[(int)len2];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i2 = startPos; i2 < endPos; i2 += step) {
                out[idx++] = this.stringLengths.getShort(i2);
            }
        } else if (this.isConstant) {
            for (long i3 = startPos; i3 < endPos; i3 += step) {
                out[idx++] = this.data[0] != null ? this.data[0].length() : 0;
            }
        } else {
            for (long i4 = startPos; i4 < endPos; i4 += step) {
                out[idx++] = this.data[(int)i4] != null ? this.data[(int)i4].length() : 0;
            }
        }
        return out;
    }

    @Override
    public final long[] getLongData() {
        if (this.length > 0x40000000L) {
            return null;
        }
        long[] out = new long[(int)this.length];
        if (this.ptr != 0L) {
            int i2 = 0;
            while ((long)i2 < this.length) {
                out[i2] = this.stringLengths.getShort(i2);
                ++i2;
            }
        } else if (this.isConstant) {
            int elem = this.data[0] != null ? this.data[0].length() : 0;
            int i3 = 0;
            while ((long)i3 < this.length) {
                out[i3] = elem;
                ++i3;
            }
        } else {
            int i4 = 0;
            while ((long)i4 < this.length) {
                out[i4] = this.data[i4] != null ? (long)this.data[i4].length() : 0L;
                ++i4;
            }
        }
        return out;
    }

    @Override
    public final long[] getLongData(long[] a2, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len2 = (long)FastMath.ceil((double)(endPos - startPos) / (double)step);
        if (len2 > 0x40000000L) {
            return null;
        }
        long[] out = a2 != null && (long)a2.length >= len2 ? a2 : new long[(int)len2];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i2 = startPos; i2 < endPos; i2 += step) {
                out[idx++] = this.stringLengths.getShort(i2);
            }
        } else if (this.isConstant) {
            for (long i3 = startPos; i3 < endPos; i3 += step) {
                out[idx++] = this.data[0] != null ? this.data[0].length() : 0;
            }
        } else {
            for (long i4 = startPos; i4 < endPos; i4 += step) {
                out[idx++] = this.data[(int)i4] != null ? this.data[(int)i4].length() : 0;
            }
        }
        return out;
    }

    @Override
    public final float[] getFloatData() {
        if (this.length > 0x40000000L) {
            return null;
        }
        float[] out = new float[(int)this.length];
        if (this.ptr != 0L) {
            int i2 = 0;
            while ((long)i2 < this.length) {
                out[i2] = this.stringLengths.getShort(i2);
                ++i2;
            }
        } else if (this.isConstant) {
            int elem = this.data[0] != null ? this.data[0].length() : 0;
            int i3 = 0;
            while ((long)i3 < this.length) {
                out[i3] = elem;
                ++i3;
            }
        } else {
            int i4 = 0;
            while ((long)i4 < this.length) {
                out[i4] = this.data[i4] != null ? (float)this.data[i4].length() : 0.0f;
                ++i4;
            }
        }
        return out;
    }

    @Override
    public final float[] getFloatData(float[] a2, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len2 = (long)FastMath.ceil((double)(endPos - startPos) / (double)step);
        if (len2 > 0x40000000L) {
            return null;
        }
        float[] out = a2 != null && (long)a2.length >= len2 ? a2 : new float[(int)len2];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i2 = startPos; i2 < endPos; i2 += step) {
                out[idx++] = this.stringLengths.getShort(i2);
            }
        } else if (this.isConstant) {
            for (long i3 = startPos; i3 < endPos; i3 += step) {
                out[idx++] = this.data[0] != null ? (float)this.data[0].length() : 0.0f;
            }
        } else {
            for (long i4 = startPos; i4 < endPos; i4 += step) {
                out[idx++] = this.data[(int)i4] != null ? this.data[(int)i4].length() : 0;
            }
        }
        return out;
    }

    @Override
    public final double[] getDoubleData() {
        if (this.length > 0x40000000L) {
            return null;
        }
        double[] out = new double[(int)this.length];
        if (this.ptr != 0L) {
            int i2 = 0;
            while ((long)i2 < this.length) {
                out[i2] = this.stringLengths.getShort(i2);
                ++i2;
            }
        } else if (this.isConstant) {
            int elem = this.data[0] != null ? this.data[0].length() : 0;
            int i3 = 0;
            while ((long)i3 < this.length) {
                out[i3] = elem;
                ++i3;
            }
        } else {
            int i4 = 0;
            while ((long)i4 < this.length) {
                out[i4] = this.data[i4] != null ? (double)this.data[i4].length() : 0.0;
                ++i4;
            }
        }
        return out;
    }

    @Override
    public final double[] getDoubleData(double[] a2, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len2 = (long)FastMath.ceil((double)(endPos - startPos) / (double)step);
        if (len2 > 0x40000000L) {
            return null;
        }
        double[] out = a2 != null && (long)a2.length >= len2 ? a2 : new double[(int)len2];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i2 = startPos; i2 < endPos; i2 += step) {
                out[idx++] = this.stringLengths.getShort(i2);
            }
        } else if (this.isConstant) {
            for (long i3 = startPos; i3 < endPos; i3 += step) {
                out[idx++] = this.data[0] != null ? (double)this.data[0].length() : 0.0;
            }
        } else {
            for (long i4 = startPos; i4 < endPos; i4 += step) {
                out[idx++] = this.data[(int)i4] != null ? this.data[(int)i4].length() : 0;
            }
        }
        return out;
    }

    @Override
    public final void setToNative(long i2, Object o2) {
        if (o2 == null) {
            this.stringLengths.setShort(i2, (short)-1);
        } else {
            byte[] tmp;
            if (!(o2 instanceof String)) {
                throw new IllegalArgumentException(o2 + " is not a string.");
            }
            String s = (String)o2;
            if (s.length() > this.maxStringLength) {
                throw new IllegalArgumentException("String  " + s + " is too long.");
            }
            try {
                tmp = s.getBytes(CHARSET);
            }
            catch (UnsupportedEncodingException ex) {
                return;
            }
            int strLen = tmp.length;
            if (strLen > Short.MAX_VALUE) {
                throw new IllegalArgumentException("String  " + s + " is too long.");
            }
            this.stringLengths.setShort(i2, (short)strLen);
            long offset = this.sizeof * i2 * (long)this.maxStringLength * 4L;
            for (int j2 = 0; j2 < strLen; ++j2) {
                LargeArrayUtils.UNSAFE.putByte(this.ptr + offset + this.sizeof * (long)j2, tmp[j2]);
            }
        }
    }

    @Override
    public final void set(long i2, Object o2) {
        if (o2 == null) {
            if (this.ptr != 0L) {
                this.stringLengths.setShort(i2, (short)-1);
            } else {
                if (this.isConstant) {
                    throw new IllegalAccessError("Constant arrays cannot be modified.");
                }
                this.data[(int)i2] = null;
            }
        } else {
            if (!(o2 instanceof String)) {
                throw new IllegalArgumentException(o2 + " is not a string.");
            }
            String s = (String)o2;
            if (this.ptr != 0L) {
                byte[] tmp;
                if (s.length() > this.maxStringLength) {
                    throw new IllegalArgumentException("String  " + s + " is too long.");
                }
                try {
                    tmp = s.getBytes(CHARSET);
                }
                catch (UnsupportedEncodingException ex) {
                    return;
                }
                int strLen = tmp.length;
                if (strLen > Short.MAX_VALUE) {
                    throw new IllegalArgumentException("String  " + s + " is too long.");
                }
                this.stringLengths.setShort(i2, (short)strLen);
                long offset = this.sizeof * i2 * (long)this.maxStringLength * 4L;
                for (int j2 = 0; j2 < strLen; ++j2) {
                    LargeArrayUtils.UNSAFE.putByte(this.ptr + offset + this.sizeof * (long)j2, tmp[j2]);
                }
            } else {
                if (this.isConstant) {
                    throw new IllegalAccessError("Constant arrays cannot be modified.");
                }
                this.data[(int)i2] = s;
            }
        }
    }

    @Override
    public final void set_safe(long i2, Object o2) {
        if (i2 < 0L || i2 >= this.length) {
            throw new ArrayIndexOutOfBoundsException(Long.toString(i2));
        }
        this.set(i2, o2);
    }

    @Override
    public final void setBoolean(long i2, boolean value) {
        this.set(i2, Boolean.toString(value));
    }

    @Override
    public final void setByte(long i2, byte value) {
        this.set(i2, Byte.toString(value));
    }

    @Override
    public final void setUnsignedByte(long i2, short value) {
        this.setShort(i2, value);
    }

    @Override
    public final void setShort(long i2, short value) {
        this.set(i2, Short.toString(value));
    }

    @Override
    public final void setInt(long i2, int value) {
        this.set(i2, Integer.toString(value));
    }

    @Override
    public final void setLong(long i2, long value) {
        this.set(i2, Long.toString(value));
    }

    @Override
    public final void setFloat(long i2, float value) {
        this.set(i2, Float.toString(value));
    }

    @Override
    public final void setDouble(long i2, double value) {
        this.set(i2, Double.toString(value));
    }

    public int getMaxStringLength() {
        return this.maxStringLength;
    }
}

