/*
 * Decompiled with CFR 0.152.
 */
package scala.math;

import java.io.Serializable;
import java.math.BigInteger;
import scala.math.BigInt;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Random;

public final class BigInt$
implements Serializable {
    public static final BigInt$ MODULE$ = new BigInt$();
    private static final BigInteger scala$math$BigInt$$longMinValueBigInteger = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInt longMinValue = new BigInt(MODULE$.scala$math$BigInt$$longMinValueBigInteger(), Long.MIN_VALUE);
    private static final int minCached = -1024;
    private static final int maxCached = 1024;
    private static final BigInt[] cache = new BigInt[maxCached - minCached + 1];
    private static final BigInteger scala$math$BigInt$$minusOne = BigInteger.valueOf(-1L);

    public BigInteger scala$math$BigInt$$longMinValueBigInteger() {
        return scala$math$BigInt$$longMinValueBigInteger;
    }

    private BigInt longMinValue() {
        return longMinValue;
    }

    private BigInt getCached(int i2) {
        int offset = i2 - minCached;
        BigInt n2 = cache[offset];
        if (n2 == null) {
            BigInt$.cache[offset] = n2 = new BigInt(null, i2);
        }
        return n2;
    }

    public BigInteger scala$math$BigInt$$minusOne() {
        return scala$math$BigInt$$minusOne;
    }

    public BigInt apply(int i2) {
        if (minCached <= i2 && i2 <= maxCached) {
            return this.getCached(i2);
        }
        return this.apply((long)i2);
    }

    public BigInt apply(long l2) {
        if ((long)minCached <= l2 && l2 <= (long)maxCached) {
            return this.getCached((int)l2);
        }
        if (l2 == Long.MIN_VALUE) {
            return this.longMinValue();
        }
        return new BigInt(null, l2);
    }

    public BigInt apply(byte[] x) {
        return this.apply(new BigInteger(x));
    }

    public BigInt apply(int signum, byte[] magnitude) {
        return this.apply(new BigInteger(signum, magnitude));
    }

    public BigInt apply(int bitlength, int certainty, Random rnd) {
        return this.apply(new BigInteger(bitlength, certainty, rnd.self()));
    }

    public BigInt apply(int numbits, Random rnd) {
        return this.apply(new BigInteger(numbits, rnd.self()));
    }

    public BigInt apply(String x) {
        return this.apply(new BigInteger(x));
    }

    public BigInt apply(String x, int radix) {
        return this.apply(new BigInteger(x, radix));
    }

    public BigInt apply(BigInteger x) {
        if (x.bitLength() <= 63) {
            long l2 = x.longValue();
            if ((long)minCached <= l2 && l2 <= (long)maxCached) {
                return this.getCached((int)l2);
            }
            return new BigInt(x, l2);
        }
        return new BigInt(x, Long.MIN_VALUE);
    }

    public BigInt probablePrime(int bitLength, Random rnd) {
        return this.apply(BigInteger.probablePrime(bitLength, rnd.self()));
    }

    public BigInt int2bigInt(int i2) {
        return this.apply(i2);
    }

    public BigInt long2bigInt(long l2) {
        return this.apply(l2);
    }

    public BigInt javaBigInteger2bigInt(BigInteger x) {
        return this.apply(x);
    }

    public long scala$math$BigInt$$longGcd(long a2, long b2) {
        long minDeltaOrZero;
        if (a2 == 0L) {
            return b2;
        }
        if (b2 == 0L) {
            return a2;
        }
        int aTwos = Long.numberOfTrailingZeros(a2);
        long a1 = a2 >> aTwos;
        int bTwos = Long.numberOfTrailingZeros(b2);
        for (long b1 = b2 >> bTwos; a1 != b1; b1 += minDeltaOrZero, a1 >>= Long.numberOfTrailingZeros(a1)) {
            long delta = a1 - b1;
            minDeltaOrZero = delta & delta >> 63;
            a1 = delta - minDeltaOrZero - minDeltaOrZero;
        }
        return a1 << Math.min(aTwos, bTwos);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(BigInt$.class);
    }

    private BigInt$() {
    }
}

