/*
 * Decompiled with CFR 0.152.
 */
package totoro.ocelot.brain.entity.sound_card;

import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import totoro.ocelot.brain.Settings$;
import totoro.ocelot.brain.entity.sound_card.ADSREnvelope;
import totoro.ocelot.brain.entity.sound_card.AmplitudeModulator;
import totoro.ocelot.brain.entity.sound_card.AudioProcess;
import totoro.ocelot.brain.entity.sound_card.FrequencyModulator;
import totoro.ocelot.brain.entity.sound_card.SignalGenerator;
import totoro.ocelot.brain.entity.sound_card.SignalGenerator$;
import totoro.ocelot.brain.entity.sound_card.SignalGenerator$Square$;
import totoro.ocelot.brain.nbt.NBTTagCompound;

@ScalaSignature(bytes="\u0006\u0005\u0005}c\u0001\u0002\u0013&\u0001ABQa\u000e\u0001\u0005\u0002aBqa\u000f\u0001A\u0002\u0013\u0005A\bC\u0004A\u0001\u0001\u0007I\u0011A!\t\r\u001d\u0003\u0001\u0015)\u0003>\u0011\u001dA\u0005\u00011A\u0005\u0002%Cq!\u0014\u0001A\u0002\u0013\u0005a\n\u0003\u0004Q\u0001\u0001\u0006KA\u0013\u0005\b#\u0002\u0001\r\u0011\"\u0001J\u0011\u001d\u0011\u0006\u00011A\u0005\u0002MCa!\u0016\u0001!B\u0013Q\u0005b\u0002,\u0001\u0001\u0004%\t!\u0013\u0005\b/\u0002\u0001\r\u0011\"\u0001Y\u0011\u0019Q\u0006\u0001)Q\u0005\u0015\"91\f\u0001a\u0001\n\u0003a\u0006b\u00021\u0001\u0001\u0004%\t!\u0019\u0005\u0007G\u0002\u0001\u000b\u0015B/\t\u000f\u0011\u0004\u0001\u0019!C\u00019\"9Q\r\u0001a\u0001\n\u00031\u0007B\u00025\u0001A\u0003&Q\fC\u0004j\u0001\u0001\u0007I\u0011\u0001/\t\u000f)\u0004\u0001\u0019!C\u0001W\"1Q\u000e\u0001Q!\nuCqA\u001c\u0001A\u0002\u0013\u0005q\u000eC\u0004w\u0001\u0001\u0007I\u0011A<\t\re\u0004\u0001\u0015)\u0003q\u0011\u001dQ\b\u00011A\u0005\u0002mD\u0011\"!\u0001\u0001\u0001\u0004%\t!a\u0001\t\u000f\u0005\u001d\u0001\u0001)Q\u0005y\"I\u0011\u0011\u0002\u0001A\u0002\u0013\u0005\u00111\u0002\u0005\n\u0003+\u0001\u0001\u0019!C\u0001\u0003/A\u0001\"a\u0007\u0001A\u0003&\u0011Q\u0002\u0005\b\u0003;\u0001A\u0011AA\u0010\u0011%\ty\u0003AI\u0001\n\u0003\t\t\u0004C\u0004\u0002H\u0001!\t!!\u0013\t\u000f\u0005e\u0003\u0001\"\u0001\u0002\\\ta\u0011)\u001e3j_\u000eC\u0017M\u001c8fY*\u0011aeJ\u0001\u000bg>,h\u000eZ0dCJ$'B\u0001\u0015*\u0003\u0019)g\u000e^5us*\u0011!fK\u0001\u0006EJ\f\u0017N\u001c\u0006\u0003Y5\naa\\2fY>$(\"\u0001\u0018\u0002\rQ|Go\u001c:p\u0007\u0001\u0019\"\u0001A\u0019\u0011\u0005I*T\"A\u001a\u000b\u0003Q\nQa]2bY\u0006L!AN\u001a\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0011\b\u0005\u0002;\u00015\tQ%A\u0005hK:,'/\u0019;peV\tQ\b\u0005\u0002;}%\u0011q(\n\u0002\u0010'&<g.\u00197HK:,'/\u0019;pe\u0006iq-\u001a8fe\u0006$xN]0%KF$\"AQ#\u0011\u0005I\u001a\u0015B\u0001#4\u0005\u0011)f.\u001b;\t\u000f\u0019\u001b\u0011\u0011!a\u0001{\u0005\u0019\u0001\u0010J\u0019\u0002\u0015\u001d,g.\u001a:bi>\u0014\b%A\u0005ge\u0016\fX/\u001a8dsV\t!\n\u0005\u00023\u0017&\u0011Aj\r\u0002\u0006\r2|\u0017\r^\u0001\u000eMJ,\u0017/^3oGf|F%Z9\u0015\u0005\t{\u0005b\u0002$\u0007\u0003\u0003\u0005\rAS\u0001\u000bMJ,\u0017/^3oGf\u0004\u0013AB8gMN,G/\u0001\u0006pM\u001a\u001cX\r^0%KF$\"A\u0011+\t\u000f\u0019K\u0011\u0011!a\u0001\u0015\u00069qN\u001a4tKR\u0004\u0013A\u0002<pYVlW-\u0001\u0006w_2,X.Z0%KF$\"AQ-\t\u000f\u0019c\u0011\u0011!a\u0001\u0015\u00069ao\u001c7v[\u0016\u0004\u0013AB5t\u001fB,g.F\u0001^!\t\u0011d,\u0003\u0002`g\t9!i\\8mK\u0006t\u0017AC5t\u001fB,gn\u0018\u0013fcR\u0011!I\u0019\u0005\b\r>\t\t\u00111\u0001^\u0003\u001dI7o\u00149f]\u0002\nq![:G[6{G-A\u0006jg\u001akWj\u001c3`I\u0015\fHC\u0001\"h\u0011\u001d1%#!AA\u0002u\u000b\u0001\"[:G[6{G\rI\u0001\bSN\fU.T8e\u0003-I7/Q7N_\u0012|F%Z9\u0015\u0005\tc\u0007b\u0002$\u0016\u0003\u0003\u0005\r!X\u0001\tSN\fU.T8eA\u0005a\u0011-\u001c9mSR,H-Z'pIV\t\u0001\u000fE\u00023cNL!A]\u001a\u0003\r=\u0003H/[8o!\tQD/\u0003\u0002vK\t\u0011\u0012)\u001c9mSR,H-Z'pIVd\u0017\r^8s\u0003A\tW\u000e\u001d7jiV$W-T8e?\u0012*\u0017\u000f\u0006\u0002Cq\"9a\tGA\u0001\u0002\u0004\u0001\u0018!D1na2LG/\u001e3f\u001b>$\u0007%\u0001\u0007ge\u0016\fX/\u001a8ds6{G-F\u0001}!\r\u0011\u0014/ \t\u0003uyL!a`\u0013\u0003%\u0019\u0013X-];f]\u000eLXj\u001c3vY\u0006$xN]\u0001\u0011MJ,\u0017/^3oGflu\u000eZ0%KF$2AQA\u0003\u0011\u001d15$!AA\u0002q\fQB\u001a:fcV,gnY=N_\u0012\u0004\u0013\u0001C3om\u0016dw\u000e]3\u0016\u0005\u00055\u0001\u0003\u0002\u001ar\u0003\u001f\u00012AOA\t\u0013\r\t\u0019\"\n\u0002\r\u0003\u0012\u001b&+\u00128wK2|\u0007/Z\u0001\rK:4X\r\\8qK~#S-\u001d\u000b\u0004\u0005\u0006e\u0001\u0002\u0003$\u001f\u0003\u0003\u0005\r!!\u0004\u0002\u0013\u0015tg/\u001a7pa\u0016\u0004\u0013\u0001C4f]\u0016\u0014\u0018\r^3\u0015\u000b)\u000b\t#a\u000b\t\u000f\u0005\r\u0002\u00051\u0001\u0002&\u00059\u0001O]8dKN\u001c\bc\u0001\u001e\u0002(%\u0019\u0011\u0011F\u0013\u0003\u0019\u0005+H-[8Qe>\u001cWm]:\t\u0011\u00055\u0002\u0005%AA\u0002u\u000bA\"[:N_\u0012,H.\u0019;j]\u001e\f!cZ3oKJ\fG/\u001a\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\u0007\u0016\u0004;\u0006U2FAA\u001c!\u0011\tI$a\u0011\u000e\u0005\u0005m\"\u0002BA\u001f\u0003\u007f\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u00053'\u0001\u0006b]:|G/\u0019;j_:LA!!\u0012\u0002<\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\t1|\u0017\r\u001a\u000b\u0004\u0005\u0006-\u0003bBA'E\u0001\u0007\u0011qJ\u0001\u0004]\n$\b\u0003BA)\u0003+j!!a\u0015\u000b\u0007\u00055\u0013&\u0003\u0003\u0002X\u0005M#A\u0004(C)R\u000bwmQ8na>,h\u000eZ\u0001\u0005g\u00064X\rF\u0002C\u0003;Bq!!\u0014$\u0001\u0004\ty\u0005")
public class AudioChannel {
    private SignalGenerator generator = SignalGenerator$Square$.MODULE$;
    private float frequency = 0.0f;
    private float offset = 0.0f;
    private float volume = 1.0f;
    private boolean isOpen = false;
    private boolean isFmMod = false;
    private boolean isAmMod = false;
    private Option<AmplitudeModulator> amplitudeMod = None$.MODULE$;
    private Option<FrequencyModulator> frequencyMod = None$.MODULE$;
    private Option<ADSREnvelope> envelope = None$.MODULE$;

    public SignalGenerator generator() {
        return this.generator;
    }

    public void generator_$eq(SignalGenerator x$1) {
        this.generator = x$1;
    }

    public float frequency() {
        return this.frequency;
    }

    public void frequency_$eq(float x$1) {
        this.frequency = x$1;
    }

    public float offset() {
        return this.offset;
    }

    public void offset_$eq(float x$1) {
        this.offset = x$1;
    }

    public float volume() {
        return this.volume;
    }

    public void volume_$eq(float x$1) {
        this.volume = x$1;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void isOpen_$eq(boolean x$1) {
        this.isOpen = x$1;
    }

    public boolean isFmMod() {
        return this.isFmMod;
    }

    public void isFmMod_$eq(boolean x$1) {
        this.isFmMod = x$1;
    }

    public boolean isAmMod() {
        return this.isAmMod;
    }

    public void isAmMod_$eq(boolean x$1) {
        this.isAmMod = x$1;
    }

    public Option<AmplitudeModulator> amplitudeMod() {
        return this.amplitudeMod;
    }

    public void amplitudeMod_$eq(Option<AmplitudeModulator> x$1) {
        this.amplitudeMod = x$1;
    }

    public Option<FrequencyModulator> frequencyMod() {
        return this.frequencyMod;
    }

    public void frequencyMod_$eq(Option<FrequencyModulator> x$1) {
        this.frequencyMod = x$1;
    }

    public Option<ADSREnvelope> envelope() {
        return this.envelope;
    }

    public void envelope_$eq(Option<ADSREnvelope> x$1) {
        this.envelope = x$1;
    }

    public float generate(AudioProcess process, boolean isModulating) {
        float value;
        block6: {
            if (!isModulating && (this.isFmMod() || this.isAmMod())) {
                return 0.0f;
            }
            if (!this.isOpen() && (this.envelope().isEmpty() || this.envelope().get().isClosed())) {
                return 0.0f;
            }
            value = this.generator().generate(this.offset());
            if (this.frequencyMod().isDefined() && !this.isFmMod() && !this.isAmMod()) {
                value = this.frequencyMod().get().modulate(process, this, value);
            } else {
                this.offset_$eq(this.offset() + this.frequency() / (float)Settings$.MODULE$.get().soundCardSampleRate());
            }
            if (this.offset() > 1.0f) {
                this.offset_$eq(this.offset() % 1.0f);
                this.generator().nextPeriod();
            }
            if (this.amplitudeMod().isDefined() && !this.isFmMod() && !this.isAmMod()) {
                value = this.amplitudeMod().get().modulate(process, this, value);
            }
            if (!this.envelope().isDefined()) break block6;
            value = this.envelope().get().modulate(process, this, value);
        }
        return value * this.volume();
    }

    public boolean generate$default$2() {
        return false;
    }

    public void load(NBTTagCompound nbt) {
        this.generator_$eq(SignalGenerator$.MODULE$.load(nbt.getCompoundTag("generator")));
        this.frequency_$eq(nbt.getFloat("frequency"));
        this.offset_$eq(nbt.getFloat("offset"));
        this.volume_$eq(nbt.getFloat("volume"));
        this.isOpen_$eq(nbt.getBoolean("isOpen"));
        this.isFmMod_$eq(nbt.getBoolean("isFmMod"));
        this.isAmMod_$eq(nbt.getBoolean("isAmMod"));
        if (nbt.hasKey("am")) {
            this.amplitudeMod_$eq(new Some<AmplitudeModulator>(new AmplitudeModulator(nbt.getCompoundTag("am"))));
        }
        if (nbt.hasKey("fm")) {
            this.frequencyMod_$eq(new Some<FrequencyModulator>(new FrequencyModulator(nbt.getCompoundTag("fm"))));
        }
        if (nbt.hasKey("env")) {
            this.envelope_$eq(new Some<ADSREnvelope>(new ADSREnvelope(nbt.getCompoundTag("env"))));
            return;
        }
    }

    public void save(NBTTagCompound nbt) {
        NBTTagCompound generatorTag = new NBTTagCompound();
        this.generator().save(generatorTag);
        nbt.setTag("generator", generatorTag);
        nbt.setFloat("frequency", this.frequency());
        nbt.setFloat("offset", this.offset());
        nbt.setFloat("volume", this.volume());
        nbt.setBoolean("isOpen", this.isOpen());
        nbt.setBoolean("isFmMod", this.isFmMod());
        nbt.setBoolean("isAmMod", this.isAmMod());
        this.amplitudeMod().foreach((Function1<AmplitudeModulator, Object> & Serializable)am -> {
            AudioChannel.$anonfun$save$1(nbt, am);
            return BoxedUnit.UNIT;
        });
        this.frequencyMod().foreach((Function1<FrequencyModulator, Object> & Serializable)fm -> {
            AudioChannel.$anonfun$save$2(nbt, fm);
            return BoxedUnit.UNIT;
        });
        this.envelope().foreach((Function1<ADSREnvelope, Object> & Serializable)env -> {
            AudioChannel.$anonfun$save$3(nbt, env);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$save$1(NBTTagCompound nbt$1, AmplitudeModulator am) {
        NBTTagCompound amNBT = new NBTTagCompound();
        am.save(amNBT);
        nbt$1.setTag("am", amNBT);
    }

    public static final /* synthetic */ void $anonfun$save$2(NBTTagCompound nbt$1, FrequencyModulator fm) {
        NBTTagCompound fmNBT = new NBTTagCompound();
        fm.save(fmNBT);
        nbt$1.setTag("fm", fmNBT);
    }

    public static final /* synthetic */ void $anonfun$save$3(NBTTagCompound nbt$1, ADSREnvelope env) {
        NBTTagCompound envNBT = new NBTTagCompound();
        env.save(envNBT);
        nbt$1.setTag("env", envNBT);
    }
}

