/*
 * Decompiled with CFR 0.152.
 */
package totoro.ocelot.brain.entity.sound_card;

import scala.reflect.ScalaSignature;
import totoro.ocelot.brain.Settings$;
import totoro.ocelot.brain.entity.sound_card.AudioChannel;
import totoro.ocelot.brain.entity.sound_card.AudioProcess;
import totoro.ocelot.brain.entity.sound_card.Modulator;
import totoro.ocelot.brain.nbt.NBTTagCompound;

@ScalaSignature(bytes="\u0006\u000553A!\u0003\u0006\u0001+!A\u0001\u0005\u0001BC\u0002\u0013\u0005\u0011\u0005\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003#\u0011!1\u0003A!b\u0001\n\u00039\u0003\u0002C\u0016\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0015\t\u000b1\u0002A\u0011A\u0017\t\u000b1\u0002A\u0011A\u0019\t\u000be\u0002A\u0011\u0001\u001e\t\u000b}\u0002A\u0011\t!\u0003%\u0019\u0013X-];f]\u000eLXj\u001c3vY\u0006$xN\u001d\u0006\u0003\u00171\t!b]8v]\u0012|6-\u0019:e\u0015\tia\"\u0001\u0004f]RLG/\u001f\u0006\u0003\u001fA\tQA\u0019:bS:T!!\u0005\n\u0002\r=\u001cW\r\\8u\u0015\u0005\u0019\u0012A\u0002;pi>\u0014xn\u0001\u0001\u0014\u0007\u00011B\u0004\u0005\u0002\u001855\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002D\u0001\u0004B]f\u0014VM\u001a\t\u0003;yi\u0011AC\u0005\u0003?)\u0011\u0011\"T8ek2\fGo\u001c:\u0002\u001d5|G-\u001e7bi>\u0014\u0018J\u001c3fqV\t!\u0005\u0005\u0002\u0018G%\u0011A\u0005\u0007\u0002\u0004\u0013:$\u0018aD7pIVd\u0017\r^8s\u0013:$W\r\u001f\u0011\u0002\u000b\u0011,\u0007\u000f\u001e5\u0016\u0003!\u0002\"aF\u0015\n\u0005)B\"!\u0002$m_\u0006$\u0018A\u00023faRD\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0004]=\u0002\u0004CA\u000f\u0001\u0011\u0015\u0001S\u00011\u0001#\u0011\u00151S\u00011\u0001))\tq#\u0007C\u00034\r\u0001\u0007A'A\u0002oER\u0004\"!N\u001c\u000e\u0003YR!a\r\b\n\u0005a2$A\u0004(C)R\u000bwmQ8na>,h\u000eZ\u0001\u0005g\u00064X\r\u0006\u0002<}A\u0011q\u0003P\u0005\u0003{a\u0011A!\u00168ji\")1g\u0002a\u0001i\u0005AQn\u001c3vY\u0006$X\r\u0006\u0003)\u0003\u001a[\u0005\"\u0002\"\t\u0001\u0004\u0019\u0015a\u00029s_\u000e,7o\u001d\t\u0003;\u0011K!!\u0012\u0006\u0003\u0019\u0005+H-[8Qe>\u001cWm]:\t\u000b\u001dC\u0001\u0019\u0001%\u0002\u000f\rD\u0017M\u001c8fYB\u0011Q$S\u0005\u0003\u0015*\u0011A\"Q;eS>\u001c\u0005.\u00198oK2DQ\u0001\u0014\u0005A\u0002!\nQA^1mk\u0016\u0004")
public class FrequencyModulator
implements Modulator {
    private final int modulatorIndex;
    private final float depth;

    public int modulatorIndex() {
        return this.modulatorIndex;
    }

    public float depth() {
        return this.depth;
    }

    public void save(NBTTagCompound nbt) {
        nbt.setInteger("m", this.modulatorIndex());
        nbt.setFloat("d", this.depth());
    }

    @Override
    public float modulate(AudioProcess process, AudioChannel channel, float value) {
        AudioChannel modulator = process.channels()[this.modulatorIndex()];
        float deviation = modulator.generate(process, true) * this.depth();
        channel.offset_$eq(channel.offset() + (channel.frequency() + deviation) / (float)Settings$.MODULE$.get().soundCardSampleRate());
        return value;
    }

    public FrequencyModulator(int modulatorIndex, float depth) {
        this.modulatorIndex = modulatorIndex;
        this.depth = depth;
    }

    public FrequencyModulator(NBTTagCompound nbt) {
        this(nbt.getInteger("m"), nbt.getFloat("d"));
    }
}

