/*
 * Decompiled with CFR 0.152.
 */
package totoro.ocelot.brain.entity.sound_card;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.mutable.ArrayBuffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.FloatRef;
import scala.runtime.RichDouble$;
import scala.runtime.RichFloat$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import totoro.ocelot.brain.Settings$;
import totoro.ocelot.brain.entity.sound_card.AudioChannel;
import totoro.ocelot.brain.entity.sound_card.AudioProcess;
import totoro.ocelot.brain.entity.sound_card.Instruction;
import totoro.ocelot.brain.entity.sound_card.Instruction$;
import totoro.ocelot.brain.entity.sound_card.SignalGenerator;
import totoro.ocelot.brain.entity.sound_card.SignalGenerator$;
import totoro.ocelot.brain.event.EventBus$;
import totoro.ocelot.brain.event.SoundCardAudioEvent;
import totoro.ocelot.brain.nbt.NBTBase;
import totoro.ocelot.brain.nbt.NBTTagCompound;
import totoro.ocelot.brain.nbt.NBTTagList;
import totoro.ocelot.brain.util.Persistable;
import totoro.ocelot.brain.util.ResultWrapper$;
import totoro.ocelot.brain.workspace.Workspace;

@ScalaSignature(bytes="\u0006\u0005\u0005%f\u0001B\u0011#\u00015BQA\u000f\u0001\u0005\u0002mBqA\u0010\u0001C\u0002\u0013\u0005q\b\u0003\u0004D\u0001\u0001\u0006I\u0001\u0011\u0005\b\t\u0002\u0011\r\u0011\"\u0003F\u0011\u0019\t\u0006\u0001)A\u0005\r\"9!\u000b\u0001b\u0001\n\u0013)\u0005BB*\u0001A\u0003%a\tC\u0004U\u0001\u0001\u0007I\u0011B+\t\u000fe\u0003\u0001\u0019!C\u00055\"1\u0001\r\u0001Q!\nYCq!\u0019\u0001A\u0002\u0013%Q\u000bC\u0004c\u0001\u0001\u0007I\u0011B2\t\r\u0015\u0004\u0001\u0015)\u0003W\u0011\u001d1\u0007\u00011A\u0005\n\u001dDqa\u001b\u0001A\u0002\u0013%A\u000e\u0003\u0004o\u0001\u0001\u0006K\u0001\u001b\u0005\b_\u0002\u0001\r\u0011\"\u0003q\u0011\u001d!\b\u00011A\u0005\nUDaa\u001e\u0001!B\u0013\t\b\"\u0002=\u0001\t\u0003I\bBB@\u0001\t\u0003\t\t\u0001C\u0004\u0002\b\u0001!\t!!\u0003\t\u000f\u0005U\u0001\u0001\"\u0001\u0002\u0018!9\u0011\u0011\u0005\u0001\u0005\u0002\u0005\r\u0002bBA\u0015\u0001\u0011\u0005\u00111\u0006\u0005\b\u0003[\u0001A\u0011AA\u0018\u0011\u001d\t\t\u0004\u0001C\u0001\u0003gAq!a\u0014\u0001\t\u0013\t\t\u0006C\u0004\u0002\\\u0001!\t%!\u0018\t\u000f\u0005m\u0004\u0001\"\u0011\u0002~!9\u0011\u0011\u0011\u0001\u0005\n\u0005\r\u0005bBAG\u0001\u0011%\u0011q\u0012\u0002\u000b'>,h\u000e\u001a\"pCJ$'BA\u0012%\u0003)\u0019x.\u001e8e?\u000e\f'\u000f\u001a\u0006\u0003K\u0019\na!\u001a8uSRL(BA\u0014)\u0003\u0015\u0011'/Y5o\u0015\tI#&\u0001\u0004pG\u0016dw\u000e\u001e\u0006\u0002W\u00051Ao\u001c;pe>\u001c\u0001aE\u0002\u0001]Q\u0002\"a\f\u001a\u000e\u0003AR\u0011!M\u0001\u0006g\u000e\fG.Y\u0005\u0003gA\u0012a!\u00118z%\u00164\u0007CA\u001b9\u001b\u00051$BA\u001c'\u0003\u0011)H/\u001b7\n\u0005e2$a\u0003)feNL7\u000f^1cY\u0016\fa\u0001P5oSRtD#\u0001\u001f\u0011\u0005u\u0002Q\"\u0001\u0012\u0002\u000fA\u0014xnY3tgV\t\u0001\t\u0005\u0002>\u0003&\u0011!I\t\u0002\r\u0003V$\u0017n\u001c)s_\u000e,7o]\u0001\taJ|7-Z:tA\u0005Y!-^5mI\n+hMZ3s+\u00051\u0005cA$M\u001d6\t\u0001J\u0003\u0002J\u0015\u00069Q.\u001e;bE2,'BA&1\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u001b\"\u00131\"\u0011:sCf\u0014UO\u001a4feB\u0011QhT\u0005\u0003!\n\u00121\"\u00138tiJ,8\r^5p]\u0006a!-^5mI\n+hMZ3sA\u0005Qa.\u001a=u\u0005V4g-\u001a:\u0002\u00179,\u0007\u0010\u001e\"vM\u001a,'\u000fI\u0001\u000bEVLG\u000e\u001a#fY\u0006LX#\u0001,\u0011\u0005=:\u0016B\u0001-1\u0005\rIe\u000e^\u0001\u000fEVLG\u000e\u001a#fY\u0006Lx\fJ3r)\tYf\f\u0005\u000209&\u0011Q\f\r\u0002\u0005+:LG\u000fC\u0004`\u0013\u0005\u0005\t\u0019\u0001,\u0002\u0007a$\u0013'A\u0006ck&dG\rR3mCf\u0004\u0013!\u00038fqR$U\r\\1z\u00035qW\r\u001f;EK2\f\u0017p\u0018\u0013fcR\u00111\f\u001a\u0005\b?2\t\t\u00111\u0001W\u0003)qW\r\u001f;EK2\f\u0017\u0010I\u0001\fg>,h\u000e\u001a,pYVlW-F\u0001i!\ty\u0013.\u0003\u0002ka\t)a\t\\8bi\u0006y1o\\;oIZ{G.^7f?\u0012*\u0017\u000f\u0006\u0002\\[\"9qlDA\u0001\u0002\u0004A\u0017\u0001D:pk:$gk\u001c7v[\u0016\u0004\u0013a\u0002;j[\u0016|W\u000f^\u000b\u0002cB\u0011qF]\u0005\u0003gB\u0012A\u0001T8oO\u0006YA/[7f_V$x\fJ3r)\tYf\u000fC\u0004`%\u0005\u0005\t\u0019A9\u0002\u0011QLW.Z8vi\u0002\nab]3u)>$\u0018\r\u001c,pYVlW\r\u0006\u0002\\u\")1\u0010\u0006a\u0001y\u00061ao\u001c7v[\u0016\u0004\"aL?\n\u0005y\u0004$A\u0002#pk\ndW-\u0001\u0007dQ\u0016\u001c7n\u00115b]:,G\u000eF\u0002W\u0003\u0007Aa!!\u0002\u0016\u0001\u00041\u0016aB2iC:tW\r\\\u0001\u0007iJL\u0018\t\u001a3\u0015\t\u0005-\u0011\u0011\u0003\t\u0005_\u00055a&C\u0002\u0002\u0010A\u0012Q!\u0011:sCfDa!a\u0005\u0017\u0001\u0004q\u0015\u0001B5ogR\fqa]3u/\u00064X\r\u0006\u0004\u0002\f\u0005e\u0011Q\u0004\u0005\u0007\u000379\u0002\u0019\u0001,\u0002\u0005\rD\u0007BBA\u0010/\u0001\u0007a+\u0001\u0003n_\u0012,\u0017!\u00023fY\u0006LH\u0003BA\u0006\u0003KAa!a\n\u0019\u0001\u00041\u0016\u0001\u00033ve\u0006$\u0018n\u001c8\u0002\u000b\rdW-\u0019:\u0015\u0003m\u000bAb\u001d;beR\u0004&o\\2fgN$\"!a\u0003\u0002\rU\u0004H-\u0019;f)\rY\u0016Q\u0007\u0005\b\u0003oY\u0002\u0019AA\u001d\u0003\u001d\tG\r\u001a:fgN\u0004B!a\u000f\u0002J9!\u0011QHA#!\r\ty\u0004M\u0007\u0003\u0003\u0003R1!a\u0011-\u0003\u0019a$o\\8u}%\u0019\u0011q\t\u0019\u0002\rA\u0013X\rZ3g\u0013\u0011\tY%!\u0014\u0003\rM#(/\u001b8h\u0015\r\t9\u0005M\u0001\ng\u0016tGmU8v]\u0012$RaWA*\u0003+Bq!a\u000e\u001d\u0001\u0004\tI\u0004C\u0004\u0002Xq\u0001\r!!\u0017\u0002\u0019%t7\u000f\u001e:vGRLwN\\:\u0011\t=\niAT\u0001\u0005Y>\fG\rF\u0003\\\u0003?\ni\u0007C\u0004\u0002bu\u0001\r!a\u0019\u0002\u00079\u0014G\u000f\u0005\u0003\u0002f\u0005%TBAA4\u0015\r\t\tGJ\u0005\u0005\u0003W\n9G\u0001\bO\u0005R#\u0016mZ\"p[B|WO\u001c3\t\u000f\u0005=T\u00041\u0001\u0002r\u0005Iqo\u001c:lgB\f7-\u001a\t\u0005\u0003g\n9(\u0004\u0002\u0002v)\u0019\u0011q\u000e\u0014\n\t\u0005e\u0014Q\u000f\u0002\n/>\u00148n\u001d9bG\u0016\fAa]1wKR\u00191,a \t\u000f\u0005\u0005d\u00041\u0001\u0002d\u0005yAn\\1e\u0013:\u001cHO\u001d\"vM\u001a,'\u000fF\u0002G\u0003\u000bCq!!\u0019 \u0001\u0004\t9\t\u0005\u0003\u0002f\u0005%\u0015\u0002BAF\u0003O\u0012!B\u0014\"U)\u0006<G*[:u\u0003=\u0019\u0018M^3J]N$(OQ;gM\u0016\u0014H\u0003BAI\u0003K\u0003b!a%\u0002\u001c\u0006}UBAAK\u0015\r9\u0014q\u0013\u0006\u0003\u00033\u000bAA[1wC&!\u0011QTAK\u0005\u0011a\u0015n\u001d;\u0011\t\u0005\u0015\u0014\u0011U\u0005\u0005\u0003G\u000b9GA\u0004O\u0005R\u0013\u0015m]3\t\r\u0005\u001d\u0006\u00051\u0001G\u0003\u0019\u0011WO\u001a4fe\u0002")
public class SoundBoard
implements Persistable {
    private final AudioProcess process;
    private final ArrayBuffer<Instruction> buildBuffer;
    private final ArrayBuffer<Instruction> nextBuffer;
    private int buildDelay;
    private int nextDelay;
    private float soundVolume;
    private long timeout;

    public AudioProcess process() {
        return this.process;
    }

    private ArrayBuffer<Instruction> buildBuffer() {
        return this.buildBuffer;
    }

    private ArrayBuffer<Instruction> nextBuffer() {
        return this.nextBuffer;
    }

    private int buildDelay() {
        return this.buildDelay;
    }

    private void buildDelay_$eq(int x$1) {
        this.buildDelay = x$1;
    }

    private int nextDelay() {
        return this.nextDelay;
    }

    private void nextDelay_$eq(int x$1) {
        this.nextDelay = x$1;
    }

    private float soundVolume() {
        return this.soundVolume;
    }

    private void soundVolume_$eq(float x$1) {
        this.soundVolume = x$1;
    }

    private long timeout() {
        return this.timeout;
    }

    private void timeout_$eq(long x$1) {
        this.timeout = x$1;
    }

    public void setTotalVolume(double volume) {
        this.soundVolume_$eq((float)((int)(RichDouble$.MODULE$.max$extension(Predef$.MODULE$.doubleWrapper(RichDouble$.MODULE$.min$extension(Predef$.MODULE$.doubleWrapper(volume), 1.0)), 0.0) * (double)127)) / (float)127);
    }

    public int checkChannel(int channel) {
        if (channel < 1 || channel > this.process().channels().length) {
            throw new IllegalArgumentException(new StringBuilder(17).append("invalid channel: ").append(channel).toString());
        }
        return channel - 1;
    }

    public Object[] tryAdd(Instruction inst) {
        block5: {
            ArrayBuffer<Instruction> arrayBuffer = this.buildBuffer();
            synchronized (arrayBuffer) {
                Object[] objectArray;
                block4: {
                    if (this.buildBuffer().size() >= Settings$.MODULE$.get().soundCardQueueSize()) {
                        objectArray = ResultWrapper$.MODULE$.result(ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToBoolean(false), "too many instructions"}));
                        break block4;
                    }
                    ArrayBuffer cfr_ignored_0 = (ArrayBuffer)this.buildBuffer().append(inst);
                    break block5;
                }
                return objectArray;
            }
        }
        return ResultWrapper$.MODULE$.result(ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToBoolean(true)}));
    }

    public Object[] setWave(int ch, int mode) {
        int channel = this.checkChannel(ch);
        Option<SignalGenerator> option = SignalGenerator$.MODULE$.fromMode(mode);
        if (option instanceof Some) {
            Some some = (Some)option;
            SignalGenerator v = (SignalGenerator)some.value();
            return this.tryAdd(new Instruction.SetGenerator(channel, v));
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("invalid mode: %s", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(mode)})));
        }
        throw new MatchError(option);
    }

    public Object[] delay(int duration) {
        if (duration < 0 || duration > Settings$.MODULE$.get().soundCardMaxDelay()) {
            throw new IllegalArgumentException(new StringBuilder(40).append("invalid duration. must be between 0 and ").append(Settings$.MODULE$.get().soundCardMaxDelay()).toString());
        }
        if (this.buildDelay() + duration > Settings$.MODULE$.get().soundCardMaxDelay()) {
            return ResultWrapper$.MODULE$.result(ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToBoolean(false), "too many delays in queue"}));
        }
        this.buildDelay_$eq(this.buildDelay() + duration);
        return this.tryAdd(new Instruction.Delay(duration));
    }

    public void clear() {
        ArrayBuffer<Instruction> arrayBuffer = this.buildBuffer();
        synchronized (arrayBuffer) {
            this.buildBuffer().clear();
        }
        this.buildDelay_$eq(0);
    }

    public Object[] startProcess() {
        Object[] objectArray;
        block11: {
            ArrayBuffer<Instruction> arrayBuffer = this.buildBuffer();
            synchronized (arrayBuffer) {
                Object[] objectArray2;
                block10: {
                    Object[] objectArray3;
                    if (this.nextBuffer().isEmpty()) {
                        if (this.buildBuffer().isEmpty()) {
                            objectArray2 = ResultWrapper$.MODULE$.result(ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToBoolean(true)}));
                            break block10;
                        }
                        ArrayBuffer<Instruction> arrayBuffer2 = this.nextBuffer();
                        synchronized (arrayBuffer2) {
                            ArrayBuffer cfr_ignored_0 = (ArrayBuffer)this.nextBuffer().appendAll(this.buildBuffer());
                        }
                        this.nextDelay_$eq(this.buildDelay());
                        this.buildBuffer().clear();
                        this.buildDelay_$eq(0);
                        if (System.currentTimeMillis() > this.timeout()) {
                            this.timeout_$eq(System.currentTimeMillis());
                        }
                        objectArray3 = ResultWrapper$.MODULE$.result(ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToBoolean(true)}));
                    } else {
                        objectArray3 = ResultWrapper$.MODULE$.result(ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToBoolean(false), BoxesRunTime.boxToLong(System.currentTimeMillis() - this.timeout())}));
                    }
                    objectArray = objectArray3;
                    break block11;
                }
                return objectArray2;
            }
        }
        return objectArray;
    }

    public void update(String address) {
        if (this.nextBuffer() != null && this.nextBuffer().nonEmpty() && System.currentTimeMillis() >= this.timeout() - 100L) {
            Instruction[] instructionArray;
            ArrayBuffer<Instruction> arrayBuffer = this.nextBuffer();
            synchronized (arrayBuffer) {
                Instruction[] array = (Instruction[])this.nextBuffer().toArray(ClassTag$.MODULE$.apply(Instruction.class));
                this.timeout_$eq(this.timeout() + (long)this.nextDelay());
                this.nextBuffer().clear();
                instructionArray = array;
            }
            Instruction[] array = instructionArray;
            this.sendSound(address, array);
            return;
        }
    }

    private void sendSound(String address, Instruction[] instructions) {
        int sampleRate = Settings$.MODULE$.get().soundCardSampleRate();
        ArrayBuffer data = new ArrayBuffer();
        ArrayBuffer[] cleanData = (ArrayBuffer[])Array$.MODULE$.fill(this.process().channels().length, (Function0<ArrayBuffer> & Serializable)() -> new ArrayBuffer(), ClassTag$.MODULE$.apply(ArrayBuffer.class));
        int i2 = 0;
        while (i2 < instructions.length || this.process().delay() > 0) {
            if (this.process().delay() > 0) {
                int sampleCount = this.process().delay() * sampleRate / 1000;
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), sampleCount).foreach((Function1<Object, ArrayBuffer> & Serializable)x$2 -> SoundBoard.$anonfun$sendSound$2(this, cleanData, data, BoxesRunTime.unboxToInt(x$2)));
                this.process().delay_$eq(0);
                continue;
            }
            Instruction inst = instructions[i2];
            ++i2;
            if (!inst.isValid()) continue;
            inst.execute(this.process());
        }
        if (data.nonEmpty()) {
            ByteBuffer buf = ByteBuffer.allocateDirect(data.length());
            buf.put((byte[])data.toArray(ClassTag$.MODULE$.Byte()));
            buf.flip();
            EventBus$.MODULE$.send(new SoundCardAudioEvent(address, buf, (float[][])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps(cleanData), (Function1<ArrayBuffer, float[]> & Serializable)x$3 -> (float[])x$3.toArray(ClassTag$.MODULE$.Float()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE))), this.soundVolume(), instructions));
            return;
        }
    }

    @Override
    public void load(NBTTagCompound nbt, Workspace workspace) {
        this.process().load(nbt.getCompoundTag("process"));
        ArrayBuffer<Instruction> arrayBuffer = this.buildBuffer();
        synchronized (arrayBuffer) {
            this.buildBuffer().clear();
            this.buildBuffer().addAll(this.loadInstrBuffer(nbt.getTagList("buildBuffer", 10)));
        }
        ArrayBuffer<Instruction> arrayBuffer2 = this.nextBuffer();
        synchronized (arrayBuffer2) {
            this.nextBuffer().clear();
            this.nextBuffer().addAll(this.loadInstrBuffer(nbt.getTagList("nextBuffer", 10)));
        }
        this.buildDelay_$eq(nbt.getInteger("buildDelay"));
        this.nextDelay_$eq(nbt.getInteger("nextDelay"));
        this.soundVolume_$eq(nbt.getFloat("soundVolume"));
        this.timeout_$eq(nbt.getLong("timeout"));
    }

    @Override
    public void save(NBTTagCompound nbt) {
        NBTTagCompound processNBT = new NBTTagCompound();
        this.process().save(processNBT);
        nbt.setTag("process", processNBT);
        nbt.setTagList("buildBuffer", this.saveInstrBuffer(this.buildBuffer()));
        nbt.setTagList("nextBuffer", this.saveInstrBuffer(this.nextBuffer()));
        nbt.setInteger("buildDelay", this.buildDelay());
        nbt.setInteger("nextDelay", this.nextDelay());
        nbt.setFloat("soundVolume", this.soundVolume());
        nbt.setLong("timeout", this.timeout());
    }

    private ArrayBuffer<Instruction> loadInstrBuffer(NBTTagList nbt) {
        ArrayBuffer<Instruction> buffer = new ArrayBuffer<Instruction>(nbt.tagCount());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), nbt.tagCount()).foreach((Function1<Object, ArrayBuffer> & Serializable)i2 -> SoundBoard.$anonfun$loadInstrBuffer$1(buffer, nbt, BoxesRunTime.unboxToInt(i2)));
        return buffer;
    }

    private List<NBTBase> saveInstrBuffer(ArrayBuffer<Instruction> buffer) {
        List<NBTBase> list2;
        ArrayBuffer<Instruction> arrayBuffer = buffer;
        synchronized (arrayBuffer) {
            list2 = CollectionConverters$.MODULE$.SeqHasAsJava(((IterableOnceOps)buffer.map((Function1<Instruction, NBTBase> & Serializable)instr -> {
                NBTTagCompound nbt = new NBTTagCompound();
                instr.save(nbt);
                return nbt;
            })).toList()).asJava();
        }
        return list2;
    }

    public static final /* synthetic */ boolean $anonfun$sendSound$3(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$sendSound$2(SoundBoard $this, ArrayBuffer[] cleanData$1, ArrayBuffer data$1, int x$2) {
        int n2 = x$2;
        FloatRef sample = FloatRef.create(0.0f);
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps(ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps($this.process().channels()))), (Function1<Tuple2, Object> & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(SoundBoard.$anonfun$sendSound$3(check$ifrefutable$1))).foreach((Function1<Tuple2, ArrayBuffer> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                AudioChannel channel = (AudioChannel)tuple2._1();
                int i2 = tuple2._2$mcI$sp();
                float x = channel.generate($this.process(), channel.generate$default$2());
                sample$1.elem += x;
                return (ArrayBuffer)cleanData$1[i2].$plus$eq(BoxesRunTime.boxToFloat(x));
            }
            throw new MatchError(tuple2);
        });
        float value = RichFloat$.MODULE$.max$extension(Predef$.MODULE$.floatWrapper(RichFloat$.MODULE$.min$extension(Predef$.MODULE$.floatWrapper(sample.elem), 1.0f)), -1.0f) * (float)127 + $this.process().error();
        $this.process().error_$eq(value - RichFloat$.MODULE$.floor$extension(Predef$.MODULE$.floatWrapper(value)));
        return (ArrayBuffer)data$1.$plus$eq(BoxesRunTime.boxToByte((byte)((byte)RichFloat$.MODULE$.floor$extension(Predef$.MODULE$.floatWrapper(value)) ^ 0x80)));
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$loadInstrBuffer$1(ArrayBuffer buffer$1, NBTTagList nbt$1, int i2) {
        return (ArrayBuffer)buffer$1.append(Instruction$.MODULE$.load(nbt$1.getCompoundTagAt(i2)));
    }

    public SoundBoard() {
        Persistable.$init$(this);
        this.process = new AudioProcess();
        this.buildBuffer = new ArrayBuffer();
        this.nextBuffer = new ArrayBuffer();
        this.buildDelay = 0;
        this.nextDelay = 0;
        this.soundVolume = 1.0f;
        this.timeout = System.currentTimeMillis();
    }
}

