/*
 * Decompiled with CFR 0.152.
 */
package totoro.ocelot.brain.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import totoro.ocelot.brain.nbt.NBTBase;
import totoro.ocelot.brain.nbt.NBTNumber;
import totoro.ocelot.brain.nbt.NBTReadLimiter;

public class NBTTagFloat
extends NBTNumber {
    private float data;

    NBTTagFloat() {
    }

    public NBTTagFloat(float f2) {
        this.data = f2;
    }

    @Override
    void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeFloat(this.data);
    }

    @Override
    void load(DataInput dataInput, int n2, NBTReadLimiter nBTReadLimiter) throws IOException {
        nBTReadLimiter.a(32L);
        this.data = dataInput.readFloat();
    }

    @Override
    public byte getId() {
        return 5;
    }

    @Override
    public String toString() {
        return "" + this.data + "f";
    }

    @Override
    public NBTBase clone() {
        return new NBTTagFloat(this.data);
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            NBTTagFloat nBTTagFloat = (NBTTagFloat)object;
            return this.data == nBTTagFloat.data;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Float.floatToIntBits(this.data);
    }

    @Override
    public long getLong() {
        return (long)this.data;
    }

    @Override
    public int getInt() {
        return (int)Math.floor(this.data);
    }

    @Override
    public short getShort() {
        return (short)(this.getInt() & 0xFFFF);
    }

    @Override
    public byte getByte() {
        return (byte)(this.getInt() & 0xFF);
    }

    @Override
    public double getDouble() {
        return this.data;
    }

    @Override
    public float getFloat() {
        return this.data;
    }
}

