/*
 * Decompiled with CFR 0.152.
 */
package totoro.ocelot.brain.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import totoro.ocelot.brain.nbt.NBTBase;
import totoro.ocelot.brain.nbt.NBTReadLimiter;

public class NBTTagIntArray
extends NBTBase {
    private int[] data;

    NBTTagIntArray() {
    }

    public NBTTagIntArray(int[] nArray) {
        this.data = nArray;
    }

    @Override
    void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.data.length);
        for (int n2 : this.data) {
            dataOutput.writeInt(n2);
        }
    }

    @Override
    void load(DataInput dataInput, int n2, NBTReadLimiter nBTReadLimiter) throws IOException {
        int n3 = dataInput.readInt();
        nBTReadLimiter.a(32L * (long)n3);
        this.data = new int[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            this.data[i2] = dataInput.readInt();
        }
    }

    @Override
    public byte getId() {
        return 11;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[");
        for (int n2 : this.data) {
            stringBuilder.append(n2).append(",");
        }
        return stringBuilder + "]";
    }

    @Override
    public NBTBase clone() {
        int[] nArray = new int[this.data.length];
        System.arraycopy(this.data, 0, nArray, 0, this.data.length);
        return new NBTTagIntArray(nArray);
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && Arrays.equals(this.data, ((NBTTagIntArray)object).data);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Arrays.hashCode(this.data);
    }

    public int[] getIntArray() {
        return this.data;
    }
}

