/*
 * Decompiled with CFR 0.152.
 */
package totoro.ocelot.brain.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import totoro.ocelot.brain.nbt.NBTBase;
import totoro.ocelot.brain.nbt.NBTNumber;
import totoro.ocelot.brain.nbt.NBTReadLimiter;

public class NBTTagShort
extends NBTNumber {
    private short data;

    public NBTTagShort() {
    }

    public NBTTagShort(short s) {
        this.data = s;
    }

    @Override
    void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.data);
    }

    @Override
    void load(DataInput dataInput, int n2, NBTReadLimiter nBTReadLimiter) throws IOException {
        nBTReadLimiter.a(16L);
        this.data = dataInput.readShort();
    }

    @Override
    public byte getId() {
        return 2;
    }

    @Override
    public String toString() {
        return "" + this.data + "s";
    }

    @Override
    public NBTBase clone() {
        return new NBTTagShort(this.data);
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            NBTTagShort nBTTagShort = (NBTTagShort)object;
            return this.data == nBTTagShort.data;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.data;
    }

    @Override
    public long getLong() {
        return this.data;
    }

    @Override
    public int getInt() {
        return this.data;
    }

    @Override
    public short getShort() {
        return this.data;
    }

    @Override
    public byte getByte() {
        return (byte)(this.data & 0xFF);
    }

    @Override
    public double getDouble() {
        return this.data;
    }

    @Override
    public float getFloat() {
        return this.data;
    }
}

