/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam;

import com.github.sarxos.webcam.WebcamMotionDetectorAlgorithm;
import com.github.sarxos.webcam.util.jh.JHBlurFilter;
import com.github.sarxos.webcam.util.jh.JHGrayFilter;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class WebcamMotionDetectorDefaultAlgorithm
implements WebcamMotionDetectorAlgorithm {
    public static final int DEFAULT_PIXEL_THREASHOLD = 25;
    public static final double DEFAULT_AREA_THREASHOLD = 0.2;
    public static final double DEFAULT_AREA_THREASHOLD_MAX = 100.0;
    private volatile int pixelThreshold = 25;
    private volatile double areaThreshold = 0.2;
    private volatile double areaThresholdMax = 100.0;
    private double area = 0.0;
    private Point cog = null;
    private final JHBlurFilter blur = new JHBlurFilter(6.0f, 6.0f, 1);
    private final JHGrayFilter gray = new JHGrayFilter();
    private List<Rectangle> doNotEnganeZones = Collections.emptyList();
    ArrayList<Point> points = new ArrayList();
    ArrayList<Integer> thresholds = new ArrayList();
    public static final int DEFAULT_RANGE = 50;
    public static final int DEFAULT_MAX_POINTS = 100;
    private int range = 50;
    private int maxPoints = 100;

    public WebcamMotionDetectorDefaultAlgorithm() {
        this(25, 0.2);
    }

    public WebcamMotionDetectorDefaultAlgorithm(int pixelThreshold, double areaThreshold) {
        this.setPixelThreshold(pixelThreshold);
        this.setAreaThreshold(areaThreshold);
    }

    @Override
    public BufferedImage filter(BufferedImage original) {
        BufferedImage modified = this.blur.filter(original, null);
        modified = this.gray.filter(modified, null);
        return modified;
    }

    @Override
    public boolean detect(BufferedImage previousModified, BufferedImage currentModified) {
        this.points.clear();
        this.thresholds.clear();
        int p = 0;
        int cogX = 0;
        int cogY = 0;
        int w = currentModified.getWidth();
        int h2 = currentModified.getHeight();
        int j2 = 0;
        if (previousModified != null) {
            for (int x = 0; x < w; ++x) {
                for (int y = 0; y < h2; ++y) {
                    boolean keep;
                    int ppx;
                    int cpx;
                    int pid;
                    if (this.isInDoNotEngageZone(x, y) || (pid = WebcamMotionDetectorDefaultAlgorithm.combinePixels(cpx = currentModified.getRGB(x, y), ppx = previousModified.getRGB(x, y)) & 0xFF) < this.pixelThreshold) continue;
                    Point pp = new Point(x, y);
                    boolean bl = keep = j2 < this.maxPoints;
                    if (keep) {
                        for (Point g2 : this.points) {
                            if (g2.x == pp.x && g2.y == pp.y || !(pp.distance(g2) <= (double)this.range)) continue;
                            keep = false;
                            break;
                        }
                    }
                    if (keep) {
                        this.points.add(new Point(x, y));
                        ++j2;
                    }
                    cogX += x;
                    cogY += y;
                    ++p;
                    this.thresholds.add(pid);
                }
            }
        }
        this.area = (double)p * 100.0 / (double)(w * h2);
        if (this.area >= this.areaThreshold && this.area <= this.areaThresholdMax) {
            this.cog = new Point(cogX / p, cogY / p);
            return true;
        }
        this.cog = new Point(w / 2, h2 / 2);
        return false;
    }

    private boolean isInDoNotEngageZone(int x, int y) {
        for (Rectangle zone : this.doNotEnganeZones) {
            if (!zone.contains(x, y)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Point getCog() {
        return this.cog;
    }

    @Override
    public double getArea() {
        return this.area;
    }

    public void setPixelThreshold(int threshold) {
        if (threshold < 0) {
            throw new IllegalArgumentException("Pixel intensity threshold cannot be negative!");
        }
        if (threshold > 255) {
            throw new IllegalArgumentException("Pixel intensity threshold cannot be higher than 255!");
        }
        this.pixelThreshold = threshold;
    }

    public void setAreaThreshold(double threshold) {
        if (threshold < 0.0) {
            throw new IllegalArgumentException("Area fraction threshold cannot be negative!");
        }
        if (threshold > 100.0) {
            throw new IllegalArgumentException("Area fraction threshold cannot be higher than 100!");
        }
        this.areaThreshold = threshold;
    }

    public void setMaxAreaThreshold(double threshold) {
        if (threshold < 0.0) {
            throw new IllegalArgumentException("Area fraction threshold cannot be negative!");
        }
        if (threshold > 100.0) {
            throw new IllegalArgumentException("Area fraction threshold cannot be higher than 100!");
        }
        this.areaThresholdMax = threshold;
    }

    private static int combinePixels(int rgb1, int rgb2) {
        int a1 = rgb1 >> 24 & 0xFF;
        int r1 = rgb1 >> 16 & 0xFF;
        int g1 = rgb1 >> 8 & 0xFF;
        int b1 = rgb1 & 0xFF;
        int a2 = rgb2 >> 24 & 0xFF;
        int r2 = rgb2 >> 16 & 0xFF;
        int g2 = rgb2 >> 8 & 0xFF;
        int b2 = rgb2 & 0xFF;
        r1 = WebcamMotionDetectorDefaultAlgorithm.clamp(Math.abs(r1 - r2));
        g1 = WebcamMotionDetectorDefaultAlgorithm.clamp(Math.abs(g1 - g2));
        b1 = WebcamMotionDetectorDefaultAlgorithm.clamp(Math.abs(b1 - b2));
        if (a1 != 255) {
            a1 = a1 * 255 / 255;
            int a3 = (255 - a1) * a2 / 255;
            r1 = WebcamMotionDetectorDefaultAlgorithm.clamp((r1 * a1 + r2 * a3) / 255);
            g1 = WebcamMotionDetectorDefaultAlgorithm.clamp((g1 * a1 + g2 * a3) / 255);
            b1 = WebcamMotionDetectorDefaultAlgorithm.clamp((b1 * a1 + b2 * a3) / 255);
            a1 = WebcamMotionDetectorDefaultAlgorithm.clamp(a1 + a3);
        }
        return a1 << 24 | r1 << 16 | g1 << 8 | b1;
    }

    private static int clamp(int c2) {
        if (c2 < 0) {
            return 0;
        }
        if (c2 > 255) {
            return 255;
        }
        return c2;
    }

    public ArrayList<Integer> getThresholds() {
        return this.thresholds;
    }

    @Override
    public void setPointRange(int i2) {
        this.range = i2;
    }

    @Override
    public int getPointRange() {
        return this.range;
    }

    @Override
    public void setMaxPoints(int i2) {
        this.maxPoints = i2;
    }

    @Override
    public int getMaxPoints() {
        return this.maxPoints;
    }

    @Override
    public ArrayList<Point> getPoints() {
        return this.points;
    }

    @Override
    public void setDoNotEngageZones(List<Rectangle> doNotEngageZones) {
        this.doNotEnganeZones = doNotEngageZones;
    }
}

