/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam.util;

import com.github.sarxos.webcam.WebcamException;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class ImageUtils {
    public static final String FORMAT_GIF = "GIF";
    public static final String FORMAT_PNG = "PNG";
    public static final String FORMAT_JPG = "JPG";
    public static final String FORMAT_BMP = "BMP";
    public static final String FORMAT_WBMP = "WBMP";

    public static byte[] toByteArray(BufferedImage image, String format2) {
        byte[] bytes = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, format2, baos);
            bytes = baos.toByteArray();
        }
        catch (IOException e2) {
            throw new WebcamException(e2);
        }
        finally {
            try {
                baos.close();
            }
            catch (IOException e3) {
                throw new WebcamException(e3);
            }
        }
        return bytes;
    }

    public static BufferedImage readFromResource(String resource) {
        InputStream is = null;
        try {
            is = ImageUtils.class.getClassLoader().getResourceAsStream(resource);
            BufferedImage bufferedImage = ImageIO.read(is);
            return bufferedImage;
        }
        catch (IOException e2) {
            throw new IllegalStateException(e2);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e3) {
                    throw new IllegalStateException(e3);
                }
            }
        }
    }

    public static BufferedImage createEmptyImage(BufferedImage source) {
        return new BufferedImage(source.getWidth(), source.getHeight(), 1);
    }

    public static int clamp(int c2) {
        if (c2 < 0) {
            return 0;
        }
        if (c2 > 255) {
            return 255;
        }
        return c2;
    }

    public static byte[] imageToBytes(BufferedImage bi) {
        return ((DataBufferByte)bi.getData().getDataBuffer()).getData();
    }
}

