/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.rtp.RTCPPacket;
import com.sun.media.rtp.RTCPSDES;
import java.io.DataOutputStream;
import java.io.IOException;

public class RTCPSDESPacket
extends RTCPPacket {
    public RTCPSDES[] sdes;

    public RTCPSDESPacket(RTCPPacket parent) {
        super(parent);
        this.type = 202;
    }

    public RTCPSDESPacket(RTCPSDES[] sdes) {
        this.sdes = sdes;
        if (sdes.length > 31) {
            throw new IllegalArgumentException("Too many SDESs");
        }
    }

    public String toString() {
        return "\tRTCP SDES Packet:\n" + RTCPSDES.toString(this.sdes);
    }

    public int calcLength() {
        int len2 = 4;
        int i2 = 0;
        while (i2 < this.sdes.length) {
            int sublen = 5;
            int j2 = 0;
            while (j2 < this.sdes[i2].items.length) {
                sublen += 2 + this.sdes[i2].items[j2].data.length;
                ++j2;
            }
            sublen = sublen + 3 & 0xFFFFFFFC;
            len2 += sublen;
            ++i2;
        }
        return len2;
    }

    void assemble(DataOutputStream out) throws IOException {
        out.writeByte(128 + this.sdes.length);
        out.writeByte(202);
        out.writeShort(this.calcLength() - 4 >> 2);
        int i2 = 0;
        while (i2 < this.sdes.length) {
            out.writeInt(this.sdes[i2].ssrc);
            int sublen = 0;
            int j2 = 0;
            while (j2 < this.sdes[i2].items.length) {
                out.writeByte(this.sdes[i2].items[j2].type);
                out.writeByte(this.sdes[i2].items[j2].data.length);
                out.write(this.sdes[i2].items[j2].data);
                sublen += 2 + this.sdes[i2].items[j2].data.length;
                ++j2;
            }
            int j3 = (sublen + 4 & 0xFFFFFFFC) - sublen;
            while (j3 > 0) {
                out.writeByte(0);
                --j3;
            }
            ++i2;
        }
    }
}

