/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtsp.protocol;

import com.sun.media.rtsp.protocol.Header;
import com.sun.media.rtsp.protocol.Parser;
import com.sun.media.rtsp.protocol.StatusLine;
import com.sun.media.sdp.SdpParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Vector;

public class Response
extends Parser {
    public StatusLine statusLine;
    public Vector headers;
    public SdpParser sdp;

    public Response(ByteArrayInputStream bin) {
        String line = this.getLine(bin);
        this.statusLine = new StatusLine(line);
        this.headers = new Vector();
        line = this.getLine(bin);
        int contentLength = 0;
        while (line.length() > 0) {
            if (line.length() <= 0) continue;
            Header header = new Header(line);
            if (header.type == 10) {
                contentLength = header.contentLength;
            }
            this.headers.addElement(header);
            line = this.getLine(bin);
        }
        if (contentLength > 0) {
            byte[] data = new byte[bin.available()];
            try {
                bin.read(data);
                this.sdp = new SdpParser(data);
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
    }

    public Header getHeader(int type2) {
        Header header = null;
        int i2 = 0;
        while (i2 < this.headers.size()) {
            Header tmpHeader = (Header)this.headers.elementAt(i2);
            if (tmpHeader.type == type2) {
                header = tmpHeader;
                break;
            }
            ++i2;
        }
        return header;
    }

    public StatusLine getStatusLine() {
        return this.statusLine;
    }
}

