/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.util;

import com.sun.media.Log;
import com.sun.media.MimeManager;

public class ContentType {
    public static String getCorrectedContentType(String contentType, String fileName) {
        if (contentType != null) {
            if (contentType.startsWith("text")) {
                String ext;
                String type2;
                int i2 = fileName.lastIndexOf(".");
                if (i2 != -1 && (type2 = MimeManager.getMimeType(ext = fileName.substring(i2 + 1).toLowerCase())) != null) {
                    return type2;
                }
                Log.error("Warning: The URL may not exist. Please check URL");
                return contentType;
            }
            if (contentType.equals("audio/wav")) {
                return "audio/x-wav";
            }
            if (contentType.equals("audio/aiff")) {
                return "audio/x-aiff";
            }
            if (contentType.equals("application/x-troff-msvideo")) {
                return "video/x-msvideo";
            }
            if (contentType.equals("video/msvideo")) {
                return "video/x-msvideo";
            }
            if (contentType.equals("video/avi")) {
                return "video/x-msvideo";
            }
            if (contentType.equals("audio/x-mpegaudio")) {
                return "audio/mpeg";
            }
        }
        String type3 = null;
        int i3 = fileName.lastIndexOf(".");
        if (i3 != -1) {
            String ext = fileName.substring(i3 + 1).toLowerCase();
            type3 = MimeManager.getMimeType(ext);
        }
        if (type3 != null) {
            return type3;
        }
        if (contentType != null) {
            return contentType;
        }
        return "content/unknown";
    }
}

