/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.util;

import javax.media.Format;

class FormatTable {
    public Format[] keys;
    public Format[][] table;
    public int[] hits;
    public int last;

    public FormatTable(int size) {
        this.keys = new Format[size];
        this.table = new Format[size][];
        this.hits = new int[size];
        this.last = 0;
    }

    Format[] get(Format input) {
        Format[] res = null;
        int i2 = 0;
        while (i2 < this.last) {
            if (res == null && this.keys[i2].matches(input)) {
                res = this.table[i2];
                this.hits[i2] = this.keys.length;
            } else {
                this.hits[i2] = this.hits[i2] - 1;
            }
            ++i2;
        }
        return res;
    }

    public void save(Format input, Format[] supported) {
        int idx = this.last >= this.keys.length ? this.findLeastHit() : this.last++;
        this.keys[idx] = input;
        this.table[idx] = supported;
        this.hits[idx] = this.keys.length;
    }

    public int findLeastHit() {
        int min2 = this.hits[0];
        int idx = 0;
        int i2 = 1;
        while (i2 < this.last) {
            if (this.hits[i2] < min2) {
                min2 = this.hits[i2];
                idx = i2;
            }
            ++i2;
        }
        return idx;
    }
}

