/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.flac;

import de.jarnbjo.flac.FlacFormatException;
import de.jarnbjo.flac.Frame;
import de.jarnbjo.flac.MetadataBlock;
import de.jarnbjo.flac.StreamInfo;
import de.jarnbjo.flac.VorbisComment;
import de.jarnbjo.ogg.LogicalOggStream;
import de.jarnbjo.util.io.ByteArrayBitInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class FlacStream {
    private LogicalOggStream oggStream;
    private final List<MetadataBlock> metadataBlocks = new ArrayList<MetadataBlock>();
    private StreamInfo streamInfo;
    private VorbisComment vorbisComment;
    private Frame lastFrame;
    private static final int MODE_HEADER = 0;
    private static final int MODE_AUDIO = 1;
    private int mode = 0;

    public FlacStream() {
    }

    public FlacStream(LogicalOggStream oggStream) throws IOException {
        this.oggStream = oggStream;
        MetadataBlock mdBlock = null;
        byte[] header = oggStream.getNextOggPacket();
        if (header.length != 4 || header[0] != 102 || header[1] != 76 || header[2] != 97 || header[3] != 67) {
            throw new FlacFormatException("Header mismatch");
        }
        do {
            ByteArrayBitInputStream source = new ByteArrayBitInputStream(oggStream.getNextOggPacket(), 1);
            mdBlock = MetadataBlock.createInstance(source);
            this.metadataBlocks.add(mdBlock);
            if (mdBlock instanceof StreamInfo) {
                this.streamInfo = (StreamInfo)mdBlock;
            }
            if (!(mdBlock instanceof VorbisComment)) continue;
            this.vorbisComment = (VorbisComment)mdBlock;
        } while (!mdBlock.isLastBlock());
        if (this.streamInfo == null) {
            throw new FlacFormatException("Missing STREAM_INFO header block");
        }
    }

    public Frame getNextFrame() throws IOException {
        return new Frame(new ByteArrayBitInputStream(this.oggStream.getNextOggPacket(), 1), this.streamInfo);
    }

    public int readPcm(byte[] buffer, int offset, int length) throws IOException {
        int channels = this.streamInfo.getChannels();
        this.lastFrame = this.getNextFrame();
        int[][] pcm = this.lastFrame.getPcm();
        int written = 0;
        for (int i2 = 0; i2 < pcm[0].length; ++i2) {
            for (int j2 = 0; j2 < channels; ++j2) {
                int sample = pcm[j2][i2];
                buffer[offset + written++] = (byte)(sample >> 8);
                buffer[offset + written++] = (byte)(sample & 0xFF);
            }
        }
        return written;
    }

    public StreamInfo getStreamInfo() {
        return this.streamInfo;
    }

    public VorbisComment getVorbisComment() {
        return this.vorbisComment;
    }

    public byte[] processPacket(byte[] packet) throws IOException {
        if (packet.length == 0) {
            throw new FlacFormatException("Cannot decode a flac frame with length = 0");
        }
        if (this.mode == 0) {
            ByteArrayBitInputStream source = new ByteArrayBitInputStream(packet, 1);
            MetadataBlock mdBlock = MetadataBlock.createInstance(source);
            this.metadataBlocks.add(mdBlock);
            if (mdBlock instanceof StreamInfo) {
                this.streamInfo = (StreamInfo)mdBlock;
            }
            if (mdBlock.isLastBlock()) {
                this.mode = 1;
            }
            return null;
        }
        if (this.streamInfo == null) {
            throw new FlacFormatException("Cannot decode audio frame before STREAM_INFO header packet has been decoded.");
        }
        Frame frame = new Frame(new ByteArrayBitInputStream(packet, 1), this.streamInfo);
        int[][] pcm = frame.getPcm();
        byte[] res = new byte[pcm.length * pcm[0].length * 2];
        int k2 = 0;
        for (int i2 = 0; i2 < pcm[0].length; ++i2) {
            for (int j2 = 0; j2 < pcm.length; ++j2) {
                res[k2++] = (byte)(pcm[j2][i2] >> 8);
                res[k2++] = (byte)(pcm[j2][i2] & 0xFF);
            }
        }
        return res;
    }
}

