/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.flac;

import de.jarnbjo.flac.MetadataBlock;
import de.jarnbjo.util.io.BitInputStream;
import java.io.IOException;

public class StreamInfo
extends MetadataBlock {
    private final int minimumBlockSize;
    private final int maximumBlockSize;
    private final int minimumFrameSize;
    private final int maximumFrameSize;
    private final int sampleRate;
    private final int channels;
    private final int bitsPerSample;
    private final long totalSamples;

    protected StreamInfo(BitInputStream source) throws IOException {
        int length = source.getInt(24);
        this.minimumBlockSize = source.getInt(16);
        this.maximumBlockSize = source.getInt(16);
        this.minimumFrameSize = source.getInt(24);
        this.maximumFrameSize = source.getInt(24);
        this.sampleRate = source.getInt(20);
        this.channels = source.getInt(3) + 1;
        this.bitsPerSample = source.getInt(5) + 1;
        this.totalSamples = source.getLong(36);
        source.getLong(64);
        source.getLong(64);
    }

    public int getMinimumBlockSize() {
        return this.minimumBlockSize;
    }

    public int getMaximumBlockSize() {
        return this.maximumBlockSize;
    }

    public int getMinimumFrameSize() {
        return this.minimumFrameSize;
    }

    public int getMaximumFrameSize() {
        return this.maximumFrameSize;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int getChannels() {
        return this.channels;
    }

    public int getBitsPerSample() {
        return this.bitsPerSample;
    }
}

