/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.jmf;

import java.io.IOException;
import javax.media.BadHeaderException;
import javax.media.Demultiplexer;
import javax.media.IncompatibleSourceException;
import javax.media.Time;
import javax.media.Track;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.Seekable;

public class FlacParser
implements Demultiplexer {
    private static final String DEMULTIPLEXER_NAME = "FLAC demultiplexer";
    private final ContentDescriptor[] supportedContentTypes = new ContentDescriptor[]{new ContentDescriptor(ContentDescriptor.mimeTypeToPackageName("application/flac")), new ContentDescriptor(ContentDescriptor.mimeTypeToPackageName("application/x-flac"))};
    private Track[] tracks;
    private PullDataSource source;
    private PullSourceStream stream;

    @Override
    public Time getDuration() {
        return Time.TIME_UNKNOWN;
    }

    @Override
    public ContentDescriptor[] getSupportedInputContentDescriptors() {
        return this.supportedContentTypes;
    }

    @Override
    public Track[] getTracks() throws BadHeaderException, IOException {
        return this.tracks;
    }

    @Override
    public boolean isPositionable() {
        return false;
    }

    @Override
    public boolean isRandomAccess() {
        return false;
    }

    @Override
    public Time getMediaTime() {
        return Time.TIME_UNKNOWN;
    }

    @Override
    public Time setPosition(Time time, int rounding) {
        return Time.TIME_UNKNOWN;
    }

    @Override
    public void start() throws IOException {
        if (this.source != null) {
            this.source.start();
        }
    }

    @Override
    public void stop() {
        if (this.source != null) {
            try {
                this.source.stop();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
        if (this.source != null) {
            try {
                this.source.stop();
                this.source.disconnect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.source = null;
        }
    }

    @Override
    public void reset() {
        this.setPosition(new Time(0L), 0);
    }

    @Override
    public String getName() {
        return DEMULTIPLEXER_NAME;
    }

    @Override
    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        try {
            if (!(source instanceof PullDataSource)) {
                throw new IncompatibleSourceException("DataSource not supported: " + source);
            }
            this.source = (PullDataSource)source;
            if (this.source.getStreams() == null || this.source.getStreams().length == 0) {
                throw new IOException("DataSource has no streams.");
            }
            if (this.source.getStreams().length > 1) {
                throw new IOException("This demultiplexer only supports data sources with one stream.");
            }
            this.stream = this.source.getStreams()[0];
            if (!(this.stream instanceof Seekable)) {
                throw new IncompatibleSourceException("Stream is not seekable.");
            }
        }
        catch (IOException | RuntimeException | IncompatibleSourceException e2) {
            e2.printStackTrace();
            throw e2;
        }
    }

    @Override
    public Object getControl(String controlType) {
        return null;
    }

    @Override
    public Object[] getControls() {
        return new Object[0];
    }
}

