/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.util.io;

import de.jarnbjo.util.io.BitInputStream;
import de.jarnbjo.util.io.HuffmanNode;
import java.io.IOException;

public class ByteArrayBitInputStream
implements BitInputStream {
    private final byte[] source;
    private byte currentByte;
    private int endian;
    private int byteIndex = 0;
    private int bitIndex = 0;

    public ByteArrayBitInputStream(byte[] source) {
        this(source, 0);
    }

    public ByteArrayBitInputStream(byte[] source, int endian) {
        this.endian = endian;
        this.source = source;
        this.currentByte = source[0];
        this.bitIndex = endian == 0 ? 0 : 7;
    }

    @Override
    public boolean getBit() throws IOException {
        if (this.endian == 0) {
            if (this.bitIndex > 7) {
                this.bitIndex = 0;
                this.currentByte = this.source[++this.byteIndex];
            }
            return (this.currentByte & 1 << this.bitIndex++) != 0;
        }
        if (this.bitIndex < 0) {
            this.bitIndex = 7;
            this.currentByte = this.source[++this.byteIndex];
        }
        return (this.currentByte & 1 << this.bitIndex--) != 0;
    }

    @Override
    public int getInt(int bits) throws IOException {
        if (bits > 32) {
            throw new IllegalArgumentException("Argument \"bits\" must be <= 32");
        }
        int res = 0;
        if (this.endian == 0) {
            for (int i2 = 0; i2 < bits; ++i2) {
                if (!this.getBit()) continue;
                res |= 1 << i2;
            }
        } else {
            if (this.bitIndex < 0) {
                this.bitIndex = 7;
                this.currentByte = this.source[++this.byteIndex];
            } else if (this.bitIndex >= 7) {
                this.currentByte = this.source[--this.byteIndex];
            }
            if (bits <= this.bitIndex + 1) {
                int ci = this.currentByte & 0xFF;
                int offset = 1 + this.bitIndex - bits;
                int mask = (1 << bits) - 1 << offset;
                res = (ci & mask) >> offset;
                this.bitIndex -= bits;
            } else {
                res = (this.currentByte & 0xFF & (1 << this.bitIndex + 1) - 1) << bits - this.bitIndex - 1;
                bits -= this.bitIndex + 1;
                this.currentByte = this.source[++this.byteIndex];
                while (bits >= 8) {
                    res |= (this.source[this.byteIndex] & 0xFF) << (bits -= 8);
                    this.currentByte = this.source[++this.byteIndex];
                }
                if (bits > 0) {
                    int ci = this.source[this.byteIndex] & 0xFF;
                    res |= ci >> 8 - bits & (1 << bits) - 1;
                    this.bitIndex = 7 - bits;
                } else {
                    this.currentByte = this.source[--this.byteIndex];
                    this.bitIndex = -1;
                }
            }
        }
        return res;
    }

    @Override
    public int getSignedInt(int bits) throws IOException {
        int raw = this.getInt(bits);
        if (raw >= 1 << bits - 1) {
            raw -= 1 << bits;
        }
        return raw;
    }

    @Override
    public int getInt(HuffmanNode root) throws IOException {
        while (root.value == null) {
            if (this.bitIndex > 7) {
                this.bitIndex = 0;
                this.currentByte = this.source[++this.byteIndex];
            }
            root = (this.currentByte & 1 << this.bitIndex++) != 0 ? root.o1 : root.o0;
        }
        return root.value;
    }

    @Override
    public long getLong(int bits) throws IOException {
        if (bits > 64) {
            throw new IllegalArgumentException("Argument \"bits\" must be <= 64");
        }
        long res = 0L;
        if (this.endian == 0) {
            for (int i2 = 0; i2 < bits; ++i2) {
                if (!this.getBit()) continue;
                res |= 1L << i2;
            }
        } else {
            for (int i3 = bits - 1; i3 >= 0; --i3) {
                if (!this.getBit()) continue;
                res |= 1L << i3;
            }
        }
        return res;
    }

    @Override
    public int readSignedRice(int order) throws IOException {
        int msbs = -1;
        int lsbs = 0;
        int res = 0;
        if (this.endian == 0) {
            throw new UnsupportedOperationException("ByteArrayBitInputStream.readSignedRice() is only supported in big endian mode");
        }
        byte cb = this.source[this.byteIndex];
        do {
            ++msbs;
            if (this.bitIndex >= 0) continue;
            this.bitIndex = 7;
            ++this.byteIndex;
            cb = this.source[this.byteIndex];
        } while ((cb & 1 << this.bitIndex--) == 0);
        int bits = order;
        if (this.bitIndex < 0) {
            this.bitIndex = 7;
            ++this.byteIndex;
        }
        if (bits <= this.bitIndex + 1) {
            int ci = this.source[this.byteIndex] & 0xFF;
            int offset = 1 + this.bitIndex - bits;
            int mask = (1 << bits) - 1 << offset;
            lsbs = (ci & mask) >> offset;
            this.bitIndex -= bits;
        } else {
            lsbs = (this.source[this.byteIndex] & 0xFF & (1 << this.bitIndex + 1) - 1) << bits - this.bitIndex - 1;
            bits -= this.bitIndex + 1;
            ++this.byteIndex;
            while (bits >= 8) {
                lsbs |= (this.source[this.byteIndex] & 0xFF) << (bits -= 8);
                ++this.byteIndex;
            }
            if (bits > 0) {
                int ci = this.source[this.byteIndex] & 0xFF;
                lsbs |= ci >> 8 - bits & (1 << bits) - 1;
                this.bitIndex = 7 - bits;
            } else {
                --this.byteIndex;
                this.bitIndex = -1;
            }
        }
        res = msbs << order | lsbs;
        return (res & 1) == 1 ? -(res >> 1) - 1 : res >> 1;
    }

    @Override
    public void readSignedRice(int order, int[] buffer, int off, int len2) throws IOException {
        if (this.endian == 0) {
            throw new UnsupportedOperationException("ByteArrayBitInputStream.readSignedRice() is only supported in big endian mode");
        }
        for (int i2 = off; i2 < off + len2; ++i2) {
            int ci;
            int msbs = -1;
            int lsbs = 0;
            byte cb = this.source[this.byteIndex];
            do {
                ++msbs;
                if (this.bitIndex >= 0) continue;
                this.bitIndex = 7;
                ++this.byteIndex;
                cb = this.source[this.byteIndex];
            } while ((cb & 1 << this.bitIndex--) == 0);
            int bits = order;
            if (bits <= this.bitIndex + 1) {
                ci = this.source[this.byteIndex] & 0xFF;
                int offset = 1 + this.bitIndex - bits;
                int mask = (1 << bits) - 1 << offset;
                lsbs = (ci & mask) >> offset;
                this.bitIndex -= bits;
            } else {
                lsbs = (this.source[this.byteIndex] & 0xFF & (1 << this.bitIndex + 1) - 1) << bits - this.bitIndex - 1;
                bits -= this.bitIndex + 1;
                ++this.byteIndex;
                while (bits >= 8) {
                    lsbs |= (this.source[this.byteIndex] & 0xFF) << (bits -= 8);
                    ++this.byteIndex;
                }
                if (bits > 0) {
                    ci = this.source[this.byteIndex] & 0xFF;
                    lsbs |= ci >> 8 - bits & (1 << bits) - 1;
                    this.bitIndex = 7 - bits;
                } else {
                    --this.byteIndex;
                    this.bitIndex = -1;
                }
            }
            int res = msbs << order | lsbs;
            buffer[i2] = (res & 1) == 1 ? -(res >> 1) - 1 : res >> 1;
        }
    }

    @Override
    public void align() {
        if (this.endian == 1 && this.bitIndex >= 0) {
            this.bitIndex = 7;
            ++this.byteIndex;
        } else if (this.endian == 0 && this.bitIndex <= 7) {
            this.bitIndex = 0;
            ++this.byteIndex;
        }
    }

    @Override
    public void setEndian(int endian) {
        if (this.endian == 1 && endian == 0) {
            this.bitIndex = 0;
            ++this.byteIndex;
        } else if (this.endian == 0 && endian == 1) {
            this.bitIndex = 7;
            ++this.byteIndex;
        }
        this.endian = endian;
    }

    public byte[] getSource() {
        return this.source;
    }

    @Override
    public int position() {
        return this.byteIndex;
    }

    @Override
    public void skip(int length) {
        if (this.endian == 1) {
            this.bitIndex = 7;
        } else if (this.endian == 0) {
            this.bitIndex = 0;
        }
        this.byteIndex += length;
    }
}

