/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.vorbis;

import de.jarnbjo.util.io.BitInputStream;
import de.jarnbjo.util.io.HuffmanNode;
import de.jarnbjo.vorbis.Util;
import de.jarnbjo.vorbis.VorbisFormatException;
import java.io.IOException;
import java.util.Arrays;

class CodeBook {
    private HuffmanNode huffmanRoot;
    private final int dimensions;
    private final int entries;
    private final int[] entryLengths;
    private float[][] valueVector;

    protected CodeBook(BitInputStream source) throws IOException {
        int i2;
        if (source.getInt(24) != 5653314) {
            throw new VorbisFormatException("The code book sync pattern is not correct.");
        }
        this.dimensions = source.getInt(16);
        this.entries = source.getInt(24);
        this.entryLengths = new int[this.entries];
        boolean ordered = source.getBit();
        if (ordered) {
            int num;
            int cl = source.getInt(5) + 1;
            for (i2 = 0; i2 < this.entryLengths.length; i2 += num) {
                num = source.getInt(Util.ilog(this.entryLengths.length - i2));
                if (i2 + num > this.entryLengths.length) {
                    throw new VorbisFormatException("The codebook entry length list is longer than the actual number of entry lengths.");
                }
                Arrays.fill(this.entryLengths, i2, i2 + num, cl);
                ++cl;
            }
        } else {
            boolean sparse = source.getBit();
            if (sparse) {
                for (i2 = 0; i2 < this.entryLengths.length; ++i2) {
                    this.entryLengths[i2] = source.getBit() ? source.getInt(5) + 1 : -1;
                }
            } else {
                for (i2 = 0; i2 < this.entryLengths.length; ++i2) {
                    this.entryLengths[i2] = source.getInt(5) + 1;
                }
            }
        }
        if (!this.createHuffmanTree(this.entryLengths)) {
            throw new VorbisFormatException("An exception was thrown when building the codebook Huffman tree.");
        }
        int codeBookLookupType = source.getInt(4);
        switch (codeBookLookupType) {
            case 0: {
                break;
            }
            case 1: 
            case 2: {
                int i3;
                float codeBookMinimumValue = Util.float32unpack(source.getInt(32));
                float codeBookDeltaValue = Util.float32unpack(source.getInt(32));
                int codeBookValueBits = source.getInt(4) + 1;
                boolean codeBookSequenceP = source.getBit();
                int codeBookLookupValues = 0;
                codeBookLookupValues = codeBookLookupType == 1 ? Util.lookup1Values(this.entries, this.dimensions) : this.entries * this.dimensions;
                int[] codeBookMultiplicands = new int[codeBookLookupValues];
                for (i3 = 0; i3 < codeBookMultiplicands.length; ++i3) {
                    codeBookMultiplicands[i3] = source.getInt(codeBookValueBits);
                }
                this.valueVector = new float[this.entries][this.dimensions];
                if (codeBookLookupType == 1) {
                    for (i3 = 0; i3 < this.entries; ++i3) {
                        float last = 0.0f;
                        int indexDivisor = 1;
                        for (int j2 = 0; j2 < this.dimensions; ++j2) {
                            int multiplicandOffset = i3 / indexDivisor % codeBookLookupValues;
                            this.valueVector[i3][j2] = (float)codeBookMultiplicands[multiplicandOffset] * codeBookDeltaValue + codeBookMinimumValue + last;
                            if (codeBookSequenceP) {
                                last = this.valueVector[i3][j2];
                            }
                            indexDivisor *= codeBookLookupValues;
                        }
                    }
                    break;
                }
                throw new UnsupportedOperationException();
            }
            default: {
                throw new VorbisFormatException("Unsupported codebook lookup type: " + codeBookLookupType);
            }
        }
    }

    private boolean createHuffmanTree(int[] entryLengths) {
        this.huffmanRoot = new HuffmanNode();
        for (int i2 = 0; i2 < entryLengths.length; ++i2) {
            int el = entryLengths[i2];
            if (el <= 0 || this.huffmanRoot.setNewValue(el, i2)) continue;
            return false;
        }
        return true;
    }

    protected int getDimensions() {
        return this.dimensions;
    }

    protected int getEntries() {
        return this.entries;
    }

    protected HuffmanNode getHuffmanRoot() {
        return this.huffmanRoot;
    }

    protected int readInt(BitInputStream source) throws IOException {
        return source.getInt(this.huffmanRoot);
    }

    protected void readVvAdd(float[][] a2, BitInputStream source, int offset, int length) throws IOException {
        int chptr = 0;
        int ch = a2.length;
        if (ch == 0) {
            return;
        }
        int lim = (offset + length) / ch;
        int i2 = offset / ch;
        while (i2 < lim) {
            float[] ve = this.valueVector[source.getInt(this.huffmanRoot)];
            for (int j2 = 0; j2 < this.dimensions; ++j2) {
                float[] fArray = a2[chptr++];
                int n2 = i2++;
                fArray[n2] = fArray[n2] + ve[j2];
                if (chptr != ch) continue;
                chptr = 0;
            }
        }
    }
}

