/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.vorbis;

import de.jarnbjo.util.io.BitInputStream;
import de.jarnbjo.vorbis.CodeBook;
import de.jarnbjo.vorbis.Mode;
import de.jarnbjo.vorbis.Residue;
import de.jarnbjo.vorbis.SetupHeader;
import de.jarnbjo.vorbis.VorbisFormatException;
import de.jarnbjo.vorbis.VorbisStream;
import java.io.IOException;

class Residue2
extends Residue {
    private double[][] decodedVectors;

    private Residue2() {
    }

    protected Residue2(BitInputStream source, SetupHeader header) throws IOException {
        super(source, header);
    }

    @Override
    protected int getType() {
        return 2;
    }

    @Override
    protected void decodeResidue(VorbisStream vorbis, BitInputStream source, Mode mode, int ch, boolean[] doNotDecodeFlags, float[][] vectors) throws IOException {
        Residue.Look look = this.getLook(vorbis, mode);
        CodeBook codeBook = vorbis.getSetupHeader().getCodeBooks()[this.getClassBook()];
        int classvalsPerCodeword = codeBook.getDimensions();
        int nToRead = this.getEnd() - this.getBegin();
        int partitionsToRead = nToRead / this.getPartitionSize();
        int samplesPerPartition = this.getPartitionSize();
        int partitionsPerWord = look.getPhraseBook().getDimensions();
        int partWords = (partitionsToRead + partitionsPerWord - 1) / partitionsPerWord;
        int realCh = 0;
        for (boolean doNotDecodeFlag : doNotDecodeFlags) {
            if (doNotDecodeFlag) continue;
            ++realCh;
        }
        float[][] realVectors = new float[realCh][];
        realCh = 0;
        for (int i2 = 0; i2 < doNotDecodeFlags.length; ++i2) {
            if (doNotDecodeFlags[i2]) continue;
            realVectors[realCh++] = vectors[i2];
        }
        int[][] partword = new int[partWords][];
        for (int s = 0; s < look.getStages(); ++s) {
            int i3 = 0;
            int l2 = 0;
            while (i3 < partitionsToRead) {
                if (s == 0) {
                    int temp = source.getInt(look.getPhraseBook().getHuffmanRoot());
                    if (temp == -1) {
                        throw new VorbisFormatException("");
                    }
                    partword[l2] = look.getDecodeMap()[temp];
                    if (partword[l2] == null) {
                        throw new VorbisFormatException("");
                    }
                }
                for (int k2 = 0; k2 < partitionsPerWord && i3 < partitionsToRead; ++k2, ++i3) {
                    CodeBook stagebook;
                    int offset = this.begin + i3 * samplesPerPartition;
                    if ((this.cascade[partword[l2][k2]] & 1 << s) == 0 || (stagebook = vorbis.getSetupHeader().getCodeBooks()[look.getPartBooks()[partword[l2][k2]][s]]) == null) continue;
                    stagebook.readVvAdd(realVectors, source, offset, samplesPerPartition);
                }
                ++l2;
            }
        }
    }

    public Object clone() {
        Residue2 clone = new Residue2();
        this.fill(clone);
        return clone;
    }

    protected double[][] getDecodedVectors() {
        return this.decodedVectors;
    }
}

