/*
 * Decompiled with CFR 0.152.
 */
package junit.textui;

import java.io.PrintStream;
import java.text.NumberFormat;
import java.util.Enumeration;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestFailure;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.runner.BaseTestRunner;

public class ResultPrinter
implements TestListener {
    PrintStream fWriter;
    int fColumn = 0;

    public ResultPrinter(PrintStream writer) {
        this.fWriter = writer;
    }

    synchronized void print(TestResult result2, long runTime) {
        this.printHeader(runTime);
        this.printErrors(result2);
        this.printFailures(result2);
        this.printFooter(result2);
    }

    void printWaitPrompt() {
        this.getWriter().println();
        this.getWriter().println("<RETURN> to continue");
    }

    protected void printHeader(long runTime) {
        this.getWriter().println();
        this.getWriter().println("Time: " + this.elapsedTimeAsString(runTime));
    }

    protected void printErrors(TestResult result2) {
        this.printDefects(result2.errors(), result2.errorCount(), "error");
    }

    protected void printFailures(TestResult result2) {
        this.printDefects(result2.failures(), result2.failureCount(), "failure");
    }

    protected void printDefects(Enumeration booBoos, int count, String type2) {
        if (count == 0) {
            return;
        }
        if (count == 1) {
            this.getWriter().println("There was " + count + " " + type2 + ":");
        } else {
            this.getWriter().println("There were " + count + " " + type2 + "s:");
        }
        int i2 = 1;
        while (booBoos.hasMoreElements()) {
            this.printDefect((TestFailure)booBoos.nextElement(), i2);
            ++i2;
        }
    }

    public void printDefect(TestFailure booBoo, int count) {
        this.printDefectHeader(booBoo, count);
        this.printDefectTrace(booBoo);
    }

    protected void printDefectHeader(TestFailure booBoo, int count) {
        this.getWriter().print(count + ") " + booBoo.failedTest());
    }

    protected void printDefectTrace(TestFailure booBoo) {
        this.getWriter().print(BaseTestRunner.getFilteredTrace(booBoo.trace()));
    }

    protected void printFooter(TestResult result2) {
        if (result2.wasSuccessful()) {
            this.getWriter().println();
            this.getWriter().print("OK");
            this.getWriter().println(" (" + result2.runCount() + " test" + (result2.runCount() == 1 ? "" : "s") + ")");
        } else {
            this.getWriter().println();
            this.getWriter().println("FAILURES!!!");
            this.getWriter().println("Tests run: " + result2.runCount() + ",  Failures: " + result2.failureCount() + ",  Errors: " + result2.errorCount());
        }
        this.getWriter().println();
    }

    protected String elapsedTimeAsString(long runTime) {
        return NumberFormat.getInstance().format((double)runTime / 1000.0);
    }

    public PrintStream getWriter() {
        return this.fWriter;
    }

    public void addError(Test test, Throwable t) {
        this.getWriter().print("E");
    }

    public void addFailure(Test test, AssertionFailedError t) {
        this.getWriter().print("F");
    }

    public void endTest(Test test) {
    }

    public void startTest(Test test) {
        this.getWriter().print(".");
        if (this.fColumn++ >= 40) {
            this.getWriter().println();
            this.fColumn = 0;
        }
    }
}

