/*
 * Decompiled with CFR 0.152.
 */
package li.cil.repack.org.luaj.vm2;

import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import li.cil.repack.org.luaj.vm2.Buffer;
import li.cil.repack.org.luaj.vm2.LuaDouble;
import li.cil.repack.org.luaj.vm2.LuaInteger;
import li.cil.repack.org.luaj.vm2.LuaNumber;
import li.cil.repack.org.luaj.vm2.LuaValue;
import li.cil.repack.org.luaj.vm2.lib.MathLib;

public class LuaString
extends LuaValue {
    public static LuaValue s_metatable;
    public final byte[] m_bytes;
    public final int m_offset;
    public final int m_length;
    private final int m_hashcode;
    static final int RECENT_STRINGS_CACHE_SIZE = 128;
    static final int RECENT_STRINGS_MAX_LENGTH = 32;

    public static LuaString valueOf(String string) {
        char[] c2 = string.toCharArray();
        byte[] b2 = new byte[LuaString.lengthAsUtf8(c2)];
        LuaString.encodeToUtf8(c2, c2.length, b2, 0);
        return LuaString.valueUsing(b2, 0, b2.length);
    }

    public static LuaString valueOf(byte[] bytes, int off, int len2) {
        LuaString s;
        if (len2 > 32) {
            return LuaString.valueFromCopy(bytes, off, len2);
        }
        int hash = LuaString.hashCode(bytes, off, len2);
        int bucket = hash & 0x7F;
        LuaString t = RecentShortStrings.recent_short_strings[bucket];
        if (t != null && t.m_hashcode == hash && t.byteseq(bytes, off, len2)) {
            return t;
        }
        RecentShortStrings.recent_short_strings[bucket] = s = LuaString.valueFromCopy(bytes, off, len2);
        return s;
    }

    private static LuaString valueFromCopy(byte[] bytes, int off, int len2) {
        byte[] copy = new byte[len2];
        System.arraycopy(bytes, off, copy, 0, len2);
        return new LuaString(copy, 0, len2);
    }

    public static LuaString valueUsing(byte[] bytes, int off, int len2) {
        LuaString s;
        if (bytes.length > 32) {
            return new LuaString(bytes, off, len2);
        }
        int hash = LuaString.hashCode(bytes, off, len2);
        int bucket = hash & 0x7F;
        LuaString t = RecentShortStrings.recent_short_strings[bucket];
        if (t != null && t.m_hashcode == hash && t.byteseq(bytes, off, len2)) {
            return t;
        }
        RecentShortStrings.recent_short_strings[bucket] = s = new LuaString(bytes, off, len2);
        return s;
    }

    public static LuaString valueOf(char[] bytes) {
        return LuaString.valueOf(bytes, 0, bytes.length);
    }

    public static LuaString valueOf(char[] bytes, int off, int len2) {
        byte[] b2 = new byte[len2];
        for (int i2 = 0; i2 < len2; ++i2) {
            b2[i2] = (byte)bytes[i2 + off];
        }
        return LuaString.valueUsing(b2, 0, len2);
    }

    public static LuaString valueOf(byte[] bytes) {
        return LuaString.valueOf(bytes, 0, bytes.length);
    }

    public static LuaString valueUsing(byte[] bytes) {
        return LuaString.valueUsing(bytes, 0, bytes.length);
    }

    private LuaString(byte[] bytes, int offset, int length) {
        this.m_bytes = bytes;
        this.m_offset = offset;
        this.m_length = length;
        this.m_hashcode = LuaString.hashCode(bytes, offset, length);
    }

    @Override
    public boolean isstring() {
        return true;
    }

    @Override
    public LuaValue getmetatable() {
        return s_metatable;
    }

    @Override
    public int type() {
        return 4;
    }

    @Override
    public String typename() {
        return "string";
    }

    @Override
    public String tojstring() {
        return LuaString.decodeAsUtf8(this.m_bytes, this.m_offset, this.m_length);
    }

    @Override
    public LuaValue neg() {
        double d2 = this.scannumber();
        return Double.isNaN(d2) ? super.neg() : LuaString.valueOf(-d2);
    }

    @Override
    public LuaValue add(LuaValue rhs) {
        double d2 = this.scannumber();
        return Double.isNaN(d2) ? this.arithmt(ADD, rhs) : rhs.add(d2);
    }

    @Override
    public LuaValue add(double rhs) {
        return LuaString.valueOf(this.checkarith() + rhs);
    }

    @Override
    public LuaValue add(int rhs) {
        return LuaString.valueOf(this.checkarith() + (double)rhs);
    }

    @Override
    public LuaValue sub(LuaValue rhs) {
        double d2 = this.scannumber();
        return Double.isNaN(d2) ? this.arithmt(SUB, rhs) : rhs.subFrom(d2);
    }

    @Override
    public LuaValue sub(double rhs) {
        return LuaString.valueOf(this.checkarith() - rhs);
    }

    @Override
    public LuaValue sub(int rhs) {
        return LuaString.valueOf(this.checkarith() - (double)rhs);
    }

    @Override
    public LuaValue subFrom(double lhs) {
        return LuaString.valueOf(lhs - this.checkarith());
    }

    @Override
    public LuaValue mul(LuaValue rhs) {
        double d2 = this.scannumber();
        return Double.isNaN(d2) ? this.arithmt(MUL, rhs) : rhs.mul(d2);
    }

    @Override
    public LuaValue mul(double rhs) {
        return LuaString.valueOf(this.checkarith() * rhs);
    }

    @Override
    public LuaValue mul(int rhs) {
        return LuaString.valueOf(this.checkarith() * (double)rhs);
    }

    @Override
    public LuaValue pow(LuaValue rhs) {
        double d2 = this.scannumber();
        return Double.isNaN(d2) ? this.arithmt(POW, rhs) : rhs.powWith(d2);
    }

    @Override
    public LuaValue pow(double rhs) {
        return MathLib.dpow(this.checkarith(), rhs);
    }

    @Override
    public LuaValue pow(int rhs) {
        return MathLib.dpow(this.checkarith(), rhs);
    }

    @Override
    public LuaValue powWith(double lhs) {
        return MathLib.dpow(lhs, this.checkarith());
    }

    @Override
    public LuaValue powWith(int lhs) {
        return MathLib.dpow(lhs, this.checkarith());
    }

    @Override
    public LuaValue div(LuaValue rhs) {
        double d2 = this.scannumber();
        return Double.isNaN(d2) ? this.arithmt(DIV, rhs) : rhs.divInto(d2);
    }

    @Override
    public LuaValue div(double rhs) {
        return LuaDouble.ddiv(this.checkarith(), rhs);
    }

    @Override
    public LuaValue div(int rhs) {
        return LuaDouble.ddiv(this.checkarith(), rhs);
    }

    @Override
    public LuaValue divInto(double lhs) {
        return LuaDouble.ddiv(lhs, this.checkarith());
    }

    @Override
    public LuaValue mod(LuaValue rhs) {
        double d2 = this.scannumber();
        return Double.isNaN(d2) ? this.arithmt(MOD, rhs) : rhs.modFrom(d2);
    }

    @Override
    public LuaValue mod(double rhs) {
        return LuaDouble.dmod(this.checkarith(), rhs);
    }

    @Override
    public LuaValue mod(int rhs) {
        return LuaDouble.dmod(this.checkarith(), rhs);
    }

    @Override
    public LuaValue modFrom(double lhs) {
        return LuaDouble.dmod(lhs, this.checkarith());
    }

    @Override
    public LuaValue lt(LuaValue rhs) {
        return rhs.isstring() ? (rhs.strcmp(this) > 0 ? LuaValue.TRUE : FALSE) : super.lt(rhs);
    }

    @Override
    public boolean lt_b(LuaValue rhs) {
        return rhs.isstring() ? rhs.strcmp(this) > 0 : super.lt_b(rhs);
    }

    @Override
    public boolean lt_b(int rhs) {
        this.typerror("attempt to compare string with number");
        return false;
    }

    @Override
    public boolean lt_b(double rhs) {
        this.typerror("attempt to compare string with number");
        return false;
    }

    @Override
    public LuaValue lteq(LuaValue rhs) {
        return rhs.isstring() ? (rhs.strcmp(this) >= 0 ? LuaValue.TRUE : FALSE) : super.lteq(rhs);
    }

    @Override
    public boolean lteq_b(LuaValue rhs) {
        return rhs.isstring() ? rhs.strcmp(this) >= 0 : super.lteq_b(rhs);
    }

    @Override
    public boolean lteq_b(int rhs) {
        this.typerror("attempt to compare string with number");
        return false;
    }

    @Override
    public boolean lteq_b(double rhs) {
        this.typerror("attempt to compare string with number");
        return false;
    }

    @Override
    public LuaValue gt(LuaValue rhs) {
        return rhs.isstring() ? (rhs.strcmp(this) < 0 ? LuaValue.TRUE : FALSE) : super.gt(rhs);
    }

    @Override
    public boolean gt_b(LuaValue rhs) {
        return rhs.isstring() ? rhs.strcmp(this) < 0 : super.gt_b(rhs);
    }

    @Override
    public boolean gt_b(int rhs) {
        this.typerror("attempt to compare string with number");
        return false;
    }

    @Override
    public boolean gt_b(double rhs) {
        this.typerror("attempt to compare string with number");
        return false;
    }

    @Override
    public LuaValue gteq(LuaValue rhs) {
        return rhs.isstring() ? (rhs.strcmp(this) <= 0 ? LuaValue.TRUE : FALSE) : super.gteq(rhs);
    }

    @Override
    public boolean gteq_b(LuaValue rhs) {
        return rhs.isstring() ? rhs.strcmp(this) <= 0 : super.gteq_b(rhs);
    }

    @Override
    public boolean gteq_b(int rhs) {
        this.typerror("attempt to compare string with number");
        return false;
    }

    @Override
    public boolean gteq_b(double rhs) {
        this.typerror("attempt to compare string with number");
        return false;
    }

    @Override
    public LuaValue concat(LuaValue rhs) {
        return rhs.concatTo(this);
    }

    @Override
    public Buffer concat(Buffer rhs) {
        return rhs.concatTo(this);
    }

    @Override
    public LuaValue concatTo(LuaNumber lhs) {
        return this.concatTo(lhs.strvalue());
    }

    @Override
    public LuaValue concatTo(LuaString lhs) {
        byte[] b2 = new byte[lhs.m_length + this.m_length];
        System.arraycopy(lhs.m_bytes, lhs.m_offset, b2, 0, lhs.m_length);
        System.arraycopy(this.m_bytes, this.m_offset, b2, lhs.m_length, this.m_length);
        return LuaString.valueUsing(b2, 0, b2.length);
    }

    @Override
    public int strcmp(LuaValue lhs) {
        return -lhs.strcmp(this);
    }

    @Override
    public int strcmp(LuaString rhs) {
        int i2 = 0;
        for (int j2 = 0; i2 < this.m_length && j2 < rhs.m_length; ++i2, ++j2) {
            if (this.m_bytes[this.m_offset + i2] == rhs.m_bytes[rhs.m_offset + j2]) continue;
            return this.m_bytes[this.m_offset + i2] - rhs.m_bytes[rhs.m_offset + j2];
        }
        return this.m_length - rhs.m_length;
    }

    private double checkarith() {
        double d2 = this.scannumber();
        if (Double.isNaN(d2)) {
            this.aritherror();
        }
        return d2;
    }

    @Override
    public int checkint() {
        return (int)this.checkdouble();
    }

    @Override
    public LuaInteger checkinteger() {
        return LuaString.valueOf(this.checkint());
    }

    @Override
    public long checklong() {
        return (long)this.checkdouble();
    }

    @Override
    public double checkdouble() {
        double d2 = this.scannumber();
        if (Double.isNaN(d2)) {
            this.argerror("number");
        }
        return d2;
    }

    @Override
    public LuaNumber checknumber() {
        return LuaString.valueOf(this.checkdouble());
    }

    @Override
    public LuaNumber checknumber(String msg) {
        double d2 = this.scannumber();
        if (Double.isNaN(d2)) {
            LuaString.error(msg);
        }
        return LuaString.valueOf(d2);
    }

    @Override
    public boolean isnumber() {
        double d2 = this.scannumber();
        return !Double.isNaN(d2);
    }

    @Override
    public boolean isint() {
        double d2 = this.scannumber();
        if (Double.isNaN(d2)) {
            return false;
        }
        int i2 = (int)d2;
        return (double)i2 == d2;
    }

    @Override
    public boolean islong() {
        double d2 = this.scannumber();
        if (Double.isNaN(d2)) {
            return false;
        }
        long l2 = (long)d2;
        return (double)l2 == d2;
    }

    @Override
    public byte tobyte() {
        return (byte)this.toint();
    }

    @Override
    public char tochar() {
        return (char)this.toint();
    }

    @Override
    public double todouble() {
        double d2 = this.scannumber();
        return Double.isNaN(d2) ? 0.0 : d2;
    }

    @Override
    public float tofloat() {
        return (float)this.todouble();
    }

    @Override
    public int toint() {
        return (int)this.tolong();
    }

    @Override
    public long tolong() {
        return (long)this.todouble();
    }

    @Override
    public short toshort() {
        return (short)this.toint();
    }

    @Override
    public double optdouble(double defval) {
        return this.checkdouble();
    }

    @Override
    public int optint(int defval) {
        return this.checkint();
    }

    @Override
    public LuaInteger optinteger(LuaInteger defval) {
        return this.checkinteger();
    }

    @Override
    public long optlong(long defval) {
        return this.checklong();
    }

    @Override
    public LuaNumber optnumber(LuaNumber defval) {
        return this.checknumber();
    }

    @Override
    public LuaString optstring(LuaString defval) {
        return this;
    }

    @Override
    public LuaValue tostring() {
        return this;
    }

    @Override
    public String optjstring(String defval) {
        return this.tojstring();
    }

    @Override
    public LuaString strvalue() {
        return this;
    }

    public LuaString substring(int beginIndex, int endIndex) {
        int off = this.m_offset + beginIndex;
        int len2 = endIndex - beginIndex;
        return len2 >= this.m_length / 2 ? LuaString.valueUsing(this.m_bytes, off, len2) : LuaString.valueOf(this.m_bytes, off, len2);
    }

    public int hashCode() {
        return this.m_hashcode;
    }

    public static int hashCode(byte[] bytes, int offset, int length) {
        int h2 = length;
        int step = (length >> 5) + 1;
        for (int l1 = length; l1 >= step; l1 -= step) {
            h2 ^= (h2 << 5) + (h2 >> 2) + (bytes[offset + l1 - 1] & 0xFF);
        }
        return h2;
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 instanceof LuaString) {
            return this.raweq((LuaString)o2);
        }
        return false;
    }

    @Override
    public LuaValue eq(LuaValue val) {
        return val.raweq(this) ? TRUE : FALSE;
    }

    @Override
    public boolean eq_b(LuaValue val) {
        return val.raweq(this);
    }

    @Override
    public boolean raweq(LuaValue val) {
        return val.raweq(this);
    }

    @Override
    public boolean raweq(LuaString s) {
        if (this == s) {
            return true;
        }
        if (s.m_length != this.m_length) {
            return false;
        }
        if (s.m_bytes == this.m_bytes && s.m_offset == this.m_offset) {
            return true;
        }
        if (s.hashCode() != this.hashCode()) {
            return false;
        }
        for (int i2 = 0; i2 < this.m_length; ++i2) {
            if (s.m_bytes[s.m_offset + i2] == this.m_bytes[this.m_offset + i2]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(LuaString a2, int i2, LuaString b2, int j2, int n2) {
        return LuaString.equals(a2.m_bytes, a2.m_offset + i2, b2.m_bytes, b2.m_offset + j2, n2);
    }

    private boolean byteseq(byte[] bytes, int off, int len2) {
        return this.m_length == len2 && LuaString.equals(this.m_bytes, this.m_offset, bytes, off, len2);
    }

    public static boolean equals(byte[] a2, int i2, byte[] b2, int j2, int n2) {
        if (a2.length < i2 + n2 || b2.length < j2 + n2) {
            return false;
        }
        while (--n2 >= 0) {
            if (a2[i2++] == b2[j2++]) continue;
            return false;
        }
        return true;
    }

    public void write(DataOutputStream writer, int i2, int len2) throws IOException {
        writer.write(this.m_bytes, this.m_offset + i2, len2);
    }

    @Override
    public LuaValue len() {
        return LuaInteger.valueOf(this.m_length);
    }

    @Override
    public int length() {
        return this.m_length;
    }

    @Override
    public int rawlen() {
        return this.m_length;
    }

    public int luaByte(int index) {
        return this.m_bytes[this.m_offset + index] & 0xFF;
    }

    public int charAt(int index) {
        if (index < 0 || index >= this.m_length) {
            throw new IndexOutOfBoundsException();
        }
        return this.luaByte(index);
    }

    @Override
    public String checkjstring() {
        return this.tojstring();
    }

    @Override
    public LuaString checkstring() {
        return this;
    }

    public InputStream toInputStream() {
        return new ByteArrayInputStream(this.m_bytes, this.m_offset, this.m_length);
    }

    public void copyInto(int strOffset, byte[] bytes, int arrayOffset, int len2) {
        System.arraycopy(this.m_bytes, this.m_offset + strOffset, bytes, arrayOffset, len2);
    }

    public int indexOfAny(LuaString accept) {
        int ilimit = this.m_offset + this.m_length;
        int jlimit = accept.m_offset + accept.m_length;
        for (int i2 = this.m_offset; i2 < ilimit; ++i2) {
            for (int j2 = accept.m_offset; j2 < jlimit; ++j2) {
                if (this.m_bytes[i2] != accept.m_bytes[j2]) continue;
                return i2 - this.m_offset;
            }
        }
        return -1;
    }

    public int indexOf(byte b2, int start) {
        for (int i2 = start; i2 < this.m_length; ++i2) {
            if (this.m_bytes[this.m_offset + i2] != b2) continue;
            return i2;
        }
        return -1;
    }

    public int indexOf(LuaString s, int start) {
        int slen = s.length();
        int limit = this.m_length - slen;
        for (int i2 = start; i2 <= limit; ++i2) {
            if (!LuaString.equals(this.m_bytes, this.m_offset + i2, s.m_bytes, s.m_offset, slen)) continue;
            return i2;
        }
        return -1;
    }

    public int lastIndexOf(LuaString s) {
        int limit;
        int slen = s.length();
        for (int i2 = limit = this.m_length - slen; i2 >= 0; --i2) {
            if (!LuaString.equals(this.m_bytes, this.m_offset + i2, s.m_bytes, s.m_offset, slen)) continue;
            return i2;
        }
        return -1;
    }

    public static String decodeAsUtf8(byte[] bytes, int offset, int length) {
        int i2 = offset;
        int j2 = offset + length;
        int n2 = 0;
        while (i2 < j2) {
            byte v;
            if (((v = bytes[i2++]) & 0xC0) == 192) {
                ++i2;
                if ((v & 0xE0) == 224) {
                    ++i2;
                    if ((v & 0xF0) == 240) {
                        ++i2;
                    }
                }
            }
            ++n2;
        }
        char[] chars = new char[n2];
        i2 = offset;
        j2 = offset + length;
        n2 = 0;
        while (i2 < j2) {
            int b2;
            chars[n2++] = (char)((b2 = bytes[i2++]) >= 0 || i2 >= j2 ? b2 : (b2 < -32 || i2 + 1 >= j2 ? (b2 & 0x3F) << 6 | bytes[i2++] & 0x3F : (b2 & 0xF) << 12 | (bytes[i2++] & 0x3F) << 6 | bytes[i2++] & 0x3F));
        }
        return new String(chars);
    }

    public static int lengthAsUtf8(char[] chars) {
        int b2 = 0;
        for (int i2 = 0; i2 < chars.length; ++i2) {
            char c2 = chars[i2];
            if (c2 < '\u0080' || c2 >= '\udc00' && c2 < '\ue000') {
                ++b2;
                continue;
            }
            if (c2 < '\u0800') {
                b2 += 2;
                continue;
            }
            if (c2 >= '\ud800' && c2 < '\udc00') {
                if (i2 + 1 < chars.length && chars[i2 + 1] >= '\udc00' && chars[i2 + 1] < '\ue000') {
                    b2 += 4;
                    ++i2;
                    continue;
                }
                ++b2;
                continue;
            }
            b2 += 3;
        }
        return b2;
    }

    public static int encodeToUtf8(char[] chars, int nchars, byte[] bytes, int off) {
        int j2 = off;
        for (int i2 = 0; i2 < nchars; ++i2) {
            char c2 = chars[i2];
            if (c2 < '\u0080') {
                bytes[j2++] = (byte)c2;
                continue;
            }
            if (c2 < '\u0800') {
                bytes[j2++] = (byte)(0xC0 | c2 >> 6);
                bytes[j2++] = (byte)(0x80 | c2 & 0x3F);
                continue;
            }
            if (c2 >= '\ud800' && c2 < '\udc00') {
                if (i2 + 1 < nchars && chars[i2 + 1] >= '\udc00' && chars[i2 + 1] < '\ue000') {
                    int uc = 65536 + ((c2 & 0x3FF) << 10 | chars[++i2] & 0x3FF);
                    bytes[j2++] = (byte)(0xF0 | uc >> 18);
                    bytes[j2++] = (byte)(0x80 | uc >> 12 & 0x3F);
                    bytes[j2++] = (byte)(0x80 | uc >> 6 & 0x3F);
                    bytes[j2++] = (byte)(0x80 | uc & 0x3F);
                    continue;
                }
                bytes[j2++] = 63;
                continue;
            }
            if (c2 >= '\udc00' && c2 < '\ue000') {
                bytes[j2++] = 63;
                continue;
            }
            bytes[j2++] = (byte)(0xE0 | c2 >> 12);
            bytes[j2++] = (byte)(0x80 | c2 >> 6 & 0x3F);
            bytes[j2++] = (byte)(0x80 | c2 & 0x3F);
        }
        return j2 - off;
    }

    public boolean isValidUtf8() {
        int i2 = this.m_offset;
        int j2 = this.m_offset + this.m_length;
        while (i2 < j2) {
            byte c2;
            if ((c2 = this.m_bytes[i2++]) >= 0 || (c2 & 0xE0) == 192 && i2 < j2 && (this.m_bytes[i2++] & 0xC0) == 128 || (c2 & 0xF0) == 224 && i2 + 1 < j2 && (this.m_bytes[i2++] & 0xC0) == 128 && (this.m_bytes[i2++] & 0xC0) == 128 || (c2 & 0xF8) == 240 && i2 + 2 < j2 && (this.m_bytes[i2++] & 0xC0) == 128 && (this.m_bytes[i2++] & 0xC0) == 128 && (this.m_bytes[i2++] & 0xC0) == 128) continue;
            return false;
        }
        return true;
    }

    @Override
    public LuaValue tonumber() {
        double d2 = this.scannumber();
        return Double.isNaN(d2) ? NIL : LuaString.valueOf(d2);
    }

    public LuaValue tonumber(int base) {
        double d2 = this.scannumber(base);
        return Double.isNaN(d2) ? NIL : LuaString.valueOf(d2);
    }

    private boolean isspace(byte c2) {
        return c2 == 32 || c2 >= 9 && c2 <= 13;
    }

    private boolean isdigit(byte c2) {
        return c2 >= 48 && c2 <= 57;
    }

    private boolean isxdigit(byte c2) {
        return c2 >= 48 && c2 <= 57 || c2 >= 97 && c2 <= 102 || c2 >= 65 && c2 <= 70;
    }

    private int hexvalue(byte c2) {
        return c2 <= 57 ? c2 - 48 : (c2 <= 70 ? c2 + 10 - 65 : c2 + 10 - 97);
    }

    public double scannumber() {
        int i2;
        int j2 = this.m_offset + this.m_length;
        for (i2 = this.m_offset; i2 < j2 && this.isspace(this.m_bytes[i2]); ++i2) {
        }
        while (i2 < j2 && this.isspace(this.m_bytes[j2 - 1])) {
            --j2;
        }
        if (i2 >= j2) {
            return Double.NaN;
        }
        if (this.indexOf((byte)120, i2 - this.m_offset) != -1 || this.indexOf((byte)88, i2 - this.m_offset) != -1) {
            return this.strx2number(i2, j2);
        }
        return this.scandouble(i2, j2);
    }

    private double strx2number(int start, int end) {
        double sgn;
        double d2 = sgn = this.m_bytes[start] == 45 ? -1.0 : 1.0;
        if (sgn == -1.0 || this.m_bytes[start] == 43) {
            ++start;
        }
        if (start + 2 >= end) {
            return Double.NaN;
        }
        if (this.m_bytes[start++] != 48) {
            return Double.NaN;
        }
        if (this.m_bytes[start] != 120 && this.m_bytes[start] != 88) {
            return Double.NaN;
        }
        double m2 = 0.0;
        int e2 = 0;
        boolean i2 = this.isxdigit(this.m_bytes[++start]);
        while (start < end && this.isxdigit(this.m_bytes[start])) {
            m2 = m2 * 16.0 + (double)this.hexvalue(this.m_bytes[start++]);
        }
        if (start < end && this.m_bytes[start] == 46) {
            ++start;
            while (start < end && this.isxdigit(this.m_bytes[start])) {
                m2 = m2 * 16.0 + (double)this.hexvalue(this.m_bytes[start++]);
                e2 -= 4;
            }
        }
        if (!i2 && e2 == 0) {
            return Double.NaN;
        }
        if (start < end && (this.m_bytes[start] == 112 || this.m_bytes[start] == 80)) {
            int exp1 = 0;
            boolean neg1 = false;
            if (++start < end) {
                if (this.m_bytes[start] == 45) {
                    neg1 = true;
                }
                if (neg1 || this.m_bytes[start] == 43) {
                    ++start;
                }
            }
            if (start >= end || !this.isdigit(this.m_bytes[start])) {
                return Double.NaN;
            }
            while (start < end && this.isdigit(this.m_bytes[start])) {
                exp1 = exp1 * 10 + this.m_bytes[start++] - 48;
            }
            if (neg1) {
                exp1 = -exp1;
            }
            e2 += exp1;
        }
        if (start != end) {
            return Double.NaN;
        }
        return sgn * m2 * MathLib.dpow_d(2.0, e2);
    }

    public double scannumber(int base) {
        int i2;
        if (base < 2 || base > 36) {
            return Double.NaN;
        }
        int j2 = this.m_offset + this.m_length;
        for (i2 = this.m_offset; i2 < j2 && this.isspace(this.m_bytes[i2]); ++i2) {
        }
        while (i2 < j2 && this.isspace(this.m_bytes[j2 - 1])) {
            --j2;
        }
        if (i2 >= j2) {
            return Double.NaN;
        }
        return this.scanlong(base, i2, j2);
    }

    private double scanlong(int base, int start, int end) {
        boolean neg;
        long x = 0L;
        boolean bl = neg = this.m_bytes[start] == 45;
        if (neg || this.m_bytes[start] == 43) {
            ++start;
        }
        for (int i2 = start; i2 < end; ++i2) {
            int digit = this.m_bytes[i2] - (base <= 10 || this.m_bytes[i2] >= 48 && this.m_bytes[i2] <= 57 ? 48 : (this.m_bytes[i2] >= 65 && this.m_bytes[i2] <= 90 ? 55 : 87));
            if (digit < 0 || digit >= base) {
                return Double.NaN;
            }
            if ((x = x * (long)base + (long)digit) >= 0L) continue;
            return Double.NaN;
        }
        return neg ? (double)(-x) : (double)x;
    }

    private double scandouble(int start, int end) {
        if (end > start + 64) {
            end = start + 64;
        }
        block5: for (int i2 = start; i2 < end; ++i2) {
            switch (this.m_bytes[i2]) {
                case 43: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 69: 
                case 101: {
                    continue block5;
                }
                default: {
                    return Double.NaN;
                }
            }
        }
        char[] c2 = new char[end - start];
        for (int i3 = start; i3 < end; ++i3) {
            c2[i3 - start] = (char)this.m_bytes[i3];
        }
        try {
            return Double.parseDouble(new String(c2));
        }
        catch (Exception e2) {
            return Double.NaN;
        }
    }

    public void printToStream(PrintStream ps) {
        int n2 = this.m_length;
        for (int i2 = 0; i2 < n2; ++i2) {
            byte c2 = this.m_bytes[this.m_offset + i2];
            ps.print((char)c2);
        }
    }

    private static final class RecentShortStrings {
        private static final LuaString[] recent_short_strings = new LuaString[128];

        private RecentShortStrings() {
        }
    }
}

