/*
 * Decompiled with CFR 0.152.
 */
package li.cil.repack.org.luaj.vm2.compiler;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import li.cil.repack.org.luaj.vm2.LoadState;
import li.cil.repack.org.luaj.vm2.LocVars;
import li.cil.repack.org.luaj.vm2.LuaString;
import li.cil.repack.org.luaj.vm2.LuaValue;
import li.cil.repack.org.luaj.vm2.Prototype;

public class DumpState {
    public static boolean ALLOW_INTEGER_CASTING = false;
    public static final int NUMBER_FORMAT_FLOATS_OR_DOUBLES = 0;
    public static final int NUMBER_FORMAT_INTS_ONLY = 1;
    public static final int NUMBER_FORMAT_NUM_PATCH_INT32 = 4;
    public static final int NUMBER_FORMAT_DEFAULT = 0;
    private boolean IS_LITTLE_ENDIAN = true;
    private int NUMBER_FORMAT = 0;
    private int SIZEOF_LUA_NUMBER = 8;
    private static final int SIZEOF_INT = 4;
    private static final int SIZEOF_SIZET = 4;
    private static final int SIZEOF_INSTRUCTION = 4;
    DataOutputStream writer;
    boolean strip;
    int status;

    public DumpState(OutputStream w, boolean strip) {
        this.writer = new DataOutputStream(w);
        this.strip = strip;
        this.status = 0;
    }

    void dumpBlock(byte[] b2, int size) throws IOException {
        this.writer.write(b2, 0, size);
    }

    void dumpChar(int b2) throws IOException {
        this.writer.write(b2);
    }

    void dumpInt(int x) throws IOException {
        if (this.IS_LITTLE_ENDIAN) {
            this.writer.writeByte(x & 0xFF);
            this.writer.writeByte(x >> 8 & 0xFF);
            this.writer.writeByte(x >> 16 & 0xFF);
            this.writer.writeByte(x >> 24 & 0xFF);
        } else {
            this.writer.writeInt(x);
        }
    }

    void dumpString(LuaString s) throws IOException {
        int len2 = s.len().toint();
        this.dumpInt(len2 + 1);
        s.write(this.writer, 0, len2);
        this.writer.write(0);
    }

    void dumpDouble(double d2) throws IOException {
        long l2 = Double.doubleToLongBits(d2);
        if (this.IS_LITTLE_ENDIAN) {
            this.dumpInt((int)l2);
            this.dumpInt((int)(l2 >> 32));
        } else {
            this.writer.writeLong(l2);
        }
    }

    void dumpCode(Prototype f2) throws IOException {
        int[] code = f2.code;
        int n2 = code.length;
        this.dumpInt(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.dumpInt(code[i2]);
        }
    }

    void dumpConstants(Prototype f2) throws IOException {
        int i2;
        LuaValue[] k2 = f2.k;
        int n2 = k2.length;
        this.dumpInt(n2);
        block11: for (i2 = 0; i2 < n2; ++i2) {
            LuaValue o2 = k2[i2];
            switch (o2.type()) {
                case 0: {
                    this.writer.write(0);
                    continue block11;
                }
                case 1: {
                    this.writer.write(1);
                    this.dumpChar(o2.toboolean() ? 1 : 0);
                    continue block11;
                }
                case 3: {
                    switch (this.NUMBER_FORMAT) {
                        case 0: {
                            this.writer.write(3);
                            this.dumpDouble(o2.todouble());
                            continue block11;
                        }
                        case 1: {
                            if (!ALLOW_INTEGER_CASTING && !o2.isint()) {
                                throw new IllegalArgumentException("not an integer: " + o2);
                            }
                            this.writer.write(3);
                            this.dumpInt(o2.toint());
                            continue block11;
                        }
                        case 4: {
                            if (o2.isint()) {
                                this.writer.write(-2);
                                this.dumpInt(o2.toint());
                                continue block11;
                            }
                            this.writer.write(3);
                            this.dumpDouble(o2.todouble());
                            continue block11;
                        }
                    }
                    throw new IllegalArgumentException("number format not supported: " + this.NUMBER_FORMAT);
                }
                case 4: {
                    this.writer.write(4);
                    this.dumpString((LuaString)o2);
                    continue block11;
                }
                default: {
                    throw new IllegalArgumentException("bad type for " + o2);
                }
            }
        }
        n2 = f2.p.length;
        this.dumpInt(n2);
        for (i2 = 0; i2 < n2; ++i2) {
            this.dumpFunction(f2.p[i2]);
        }
    }

    void dumpUpvalues(Prototype f2) throws IOException {
        int n2 = f2.upvalues.length;
        this.dumpInt(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.writer.writeByte(f2.upvalues[i2].instack ? 1 : 0);
            this.writer.writeByte(f2.upvalues[i2].idx);
        }
    }

    void dumpDebug(Prototype f2) throws IOException {
        int i2;
        if (this.strip) {
            this.dumpInt(0);
        } else {
            this.dumpString(f2.source);
        }
        int n2 = this.strip ? 0 : f2.lineinfo.length;
        this.dumpInt(n2);
        for (i2 = 0; i2 < n2; ++i2) {
            this.dumpInt(f2.lineinfo[i2]);
        }
        n2 = this.strip ? 0 : f2.locvars.length;
        this.dumpInt(n2);
        for (i2 = 0; i2 < n2; ++i2) {
            LocVars lvi = f2.locvars[i2];
            this.dumpString(lvi.varname);
            this.dumpInt(lvi.startpc);
            this.dumpInt(lvi.endpc);
        }
        n2 = this.strip ? 0 : f2.upvalues.length;
        this.dumpInt(n2);
        for (i2 = 0; i2 < n2; ++i2) {
            this.dumpString(f2.upvalues[i2].name);
        }
    }

    void dumpFunction(Prototype f2) throws IOException {
        this.dumpInt(f2.linedefined);
        this.dumpInt(f2.lastlinedefined);
        this.dumpChar(f2.numparams);
        this.dumpChar(f2.is_vararg);
        this.dumpChar(f2.maxstacksize);
        this.dumpCode(f2);
        this.dumpConstants(f2);
        this.dumpUpvalues(f2);
        this.dumpDebug(f2);
    }

    void dumpHeader() throws IOException {
        this.writer.write(LoadState.LUA_SIGNATURE);
        this.writer.write(82);
        this.writer.write(0);
        this.writer.write(this.IS_LITTLE_ENDIAN ? 1 : 0);
        this.writer.write(4);
        this.writer.write(4);
        this.writer.write(4);
        this.writer.write(this.SIZEOF_LUA_NUMBER);
        this.writer.write(this.NUMBER_FORMAT);
        this.writer.write(LoadState.LUAC_TAIL);
    }

    public static int dump(Prototype f2, OutputStream w, boolean strip) throws IOException {
        DumpState D = new DumpState(w, strip);
        D.dumpHeader();
        D.dumpFunction(f2);
        return D.status;
    }

    public static int dump(Prototype f2, OutputStream w, boolean stripDebug, int numberFormat, boolean littleendian) throws IOException {
        switch (numberFormat) {
            case 0: 
            case 1: 
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException("number format not supported: " + numberFormat);
            }
        }
        DumpState D = new DumpState(w, stripDebug);
        D.IS_LITTLE_ENDIAN = littleendian;
        D.NUMBER_FORMAT = numberFormat;
        D.SIZEOF_LUA_NUMBER = numberFormat == 1 ? 4 : 8;
        D.dumpHeader();
        D.dumpFunction(f2);
        return D.status;
    }
}

