/*
 * Decompiled with CFR 0.152.
 */
package ocelot.desktop;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigRenderOptions;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import ocelot.desktop.OcelotDesktop$;
import ocelot.desktop.Settings;
import ocelot.desktop.util.Logging;
import org.apache.logging.log4j.Logger;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Settings$
implements Logging {
    public static final Settings$ MODULE$ = new Settings$();
    private static final ConfigRenderOptions renderOptions;
    private static Settings settings;
    private static Logger logger;

    static {
        Logging.$init$(MODULE$);
        renderOptions = ConfigRenderOptions.defaults().setJson(false).setOriginComments(false);
    }

    @Override
    public Logger logger() {
        return logger;
    }

    @Override
    public void ocelot$desktop$util$Logging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    public Settings.ExtendedConfig ExtendedConfig(Config config) {
        return new Settings.ExtendedConfig(config);
    }

    private ConfigRenderOptions renderOptions() {
        return renderOptions;
    }

    private Settings settings() {
        return settings;
    }

    private void settings_$eq(Settings x$1) {
        settings = x$1;
    }

    public Settings get() {
        return this.settings();
    }

    public void load(Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            try {
                this.settings_$eq(new Settings(ConfigFactory.parseFile(path.toFile())));
                this.logger().info(new StringBuilder(42).append("Loaded Ocelot Desktop configuration from: ").append(path).toString());
                return;
            }
            catch (Throwable t) {
                this.logger().error(new StringBuilder(17).append("Failed to parse ").append(path).append("!").toString(), t);
            }
        }
        this.logger().info("Using default Ocelot Desktop configuration...");
        this.settings_$eq(new Settings(ConfigFactory.parseResources(OcelotDesktop$.MODULE$.getClass(), "/ocelot/desktop/ocelot.conf")));
    }

    public void save(Path path) {
        if (this.settings() != null) {
            Config updatedConfig = this.ExtendedConfig(this.ExtendedConfig(this.ExtendedConfig(this.ExtendedConfig(this.ExtendedConfig(this.ExtendedConfig(this.ExtendedConfig(this.ExtendedConfig(this.ExtendedConfig(this.ExtendedConfig(this.ExtendedConfig(this.ExtendedConfig(this.ExtendedConfig(this.ExtendedConfig(this.ExtendedConfig(this.ExtendedConfig(this.ExtendedConfig(this.ExtendedConfig(this.ExtendedConfig(this.ExtendedConfig(this.ExtendedConfig(this.ExtendedConfig(this.ExtendedConfig(this.ExtendedConfig(this.ExtendedConfig(this.ExtendedConfig(this.ExtendedConfig(this.ExtendedConfig(this.settings().config()).withValuePreserveOrigin("ocelot.brain.customConfigPath", this.settings().brainCustomConfigPath())).withValuePreserveOrigin("ocelot.sound.volumeMaster", BoxesRunTime.boxToFloat(this.settings().volumeMaster()))).withValuePreserveOrigin("ocelot.sound.volumeRecords", BoxesRunTime.boxToFloat(this.settings().volumeRecords()))).withValuePreserveOrigin("ocelot.sound.volumeBeep", BoxesRunTime.boxToFloat(this.settings().volumeBeep()))).withValuePreserveOrigin("ocelot.sound.volumeEnvironment", BoxesRunTime.boxToFloat(this.settings().volumeEnvironment()))).withValuePreserveOrigin("ocelot.sound.volumeInterface", BoxesRunTime.boxToFloat(this.settings().volumeInterface()))).withValuePreserveOrigin("ocelot.sound.audioDisable", BoxesRunTime.boxToBoolean(this.settings().audioDisable()))).withValuePreserveOrigin("ocelot.sound.positional", BoxesRunTime.boxToBoolean(this.settings().soundPositional()))).withValuePreserveOrigin("ocelot.sound.logAudioErrorStacktrace", BoxesRunTime.boxToBoolean(this.settings().logAudioErrorStacktrace()))).withValuePreserveOrigin("ocelot.window.scaleFactor", BoxesRunTime.boxToDouble(this.settings().scaleFactor()))).withValue("ocelot.window.position", this.settings().windowPosition())).withValuePreserveOrigin("ocelot.window.validatePosition", BoxesRunTime.boxToBoolean(this.settings().windowValidatePosition()))).withValue("ocelot.window.size", this.settings().windowSize())).withValuePreserveOrigin("ocelot.window.fullscreen", BoxesRunTime.boxToBoolean(this.settings().windowFullscreen()))).withValuePreserveOrigin("ocelot.window.disableVsync", BoxesRunTime.boxToBoolean(this.settings().disableVsync()))).withValuePreserveOrigin("ocelot.window.debugLwjgl", BoxesRunTime.boxToBoolean(this.settings().debugLwjgl())).withValue("ocelot.keymap", this.settings().keymap().save())).withValue("ocelot.workspace.recent", this.settings().recentWorkspace())).withValuePreserveOrigin("ocelot.workspace.pinNewWindows", BoxesRunTime.boxToBoolean(this.settings().pinNewWindows()))).withValuePreserveOrigin("ocelot.workspace.unfocusedWindowTransparency", BoxesRunTime.boxToFloat(this.settings().unfocusedWindowTransparency()))).withValuePreserveOrigin("ocelot.workspace.unfocusedWindowHide", BoxesRunTime.boxToBoolean(this.settings().unfocusedWindowHide()))).withValuePreserveOrigin("ocelot.workspace.saveOnExit", BoxesRunTime.boxToBoolean(this.settings().saveOnExit()))).withValuePreserveOrigin("ocelot.workspace.autosave", BoxesRunTime.boxToBoolean(this.settings().autosave()))).withValuePreserveOrigin("ocelot.workspace.autosavePeriod", BoxesRunTime.boxToInteger(this.settings().autosavePeriod()))).withValuePreserveOrigin("ocelot.workspace.openLastWorkspace", BoxesRunTime.boxToBoolean(this.settings().openLastWorkspace()))).withValuePreserveOrigin("ocelot.workspace.renderScreenDataOnNodes", BoxesRunTime.boxToBoolean(this.settings().renderScreenDataOnNodes()))).withValuePreserveOrigin("ocelot.workspace.tooltipDelayItem", BoxesRunTime.boxToFloat(this.settings().tooltipDelayItem()))).withValuePreserveOrigin("ocelot.workspace.tooltipDelayUI", BoxesRunTime.boxToFloat(this.settings().tooltipDelayUI()))).withValuePreserveOrigin("ocelot.workspace.enableFestiveDecorations", BoxesRunTime.boxToBoolean(this.settings().enableFestiveDecorations()));
            Object object = !Files.exists(path.getParent(), new LinkOption[0]) ? Files.createDirectory(path.getParent(), new FileAttribute[0]) : BoxedUnit.UNIT;
            Files.write(path, updatedConfig.root().render(this.renderOptions()).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            this.logger().info(new StringBuilder(39).append("Saved Ocelot Desktop configuration to: ").append(path).toString());
            return;
        }
    }

    private Settings$() {
    }
}

