/*
 * Decompiled with CFR 0.152.
 */
package ocelot.desktop.audio;

import java.nio.ByteBuffer;
import ocelot.desktop.audio.AL10W$;
import ocelot.desktop.audio.Audio$;
import ocelot.desktop.audio.OggDecoder$;
import ocelot.desktop.audio.OpenAlException;
import ocelot.desktop.audio.OpenAlException$;
import ocelot.desktop.audio.SoundSamples;
import ocelot.desktop.util.FileUtils$;
import ocelot.desktop.util.Logging;
import ocelot.desktop.util.Resource;
import org.apache.logging.log4j.Logger;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005e4AAD\b\u0001-!Aa\u0005\u0001BC\u0002\u0013\u0005q\u0005\u0003\u00054\u0001\t\u0005\t\u0015!\u0003)\u0011\u0015!\u0004\u0001\"\u00016\u0011\u001dI\u0004\u00011A\u0005\niBq!\u0011\u0001A\u0002\u0013%!\t\u0003\u0004I\u0001\u0001\u0006Ka\u000f\u0005\u0006\u0013\u0002!IA\u0013\u0005\u0006Y\u0002!IA\u0013\u0005\u0006g\u0002!\t\u0001\u001e\u0005\bk\u0002\u0011\r\u0011\"\u0001u\u0011\u00191\b\u0001)A\u0005}!)q\u000f\u0001C\u0001u!)\u0001\u0010\u0001C!\u0015\nY1k\\;oI\n+hMZ3s\u0015\t\u0001\u0012#A\u0003bk\u0012LwN\u0003\u0002\u0013'\u00059A-Z:li>\u0004(\"\u0001\u000b\u0002\r=\u001cW\r\\8u\u0007\u0001\u0019B\u0001A\f\u001eGA\u0011\u0001dG\u0007\u00023)\t!$A\u0003tG\u0006d\u0017-\u0003\u0002\u001d3\t1\u0011I\\=SK\u001a\u0004\"AH\u0011\u000e\u0003}Q!\u0001I\t\u0002\tU$\u0018\u000e\\\u0005\u0003E}\u0011\u0001BU3t_V\u00148-\u001a\t\u0003=\u0011J!!J\u0010\u0003\u000f1{wmZ5oO\u0006!a-\u001b7f+\u0005A\u0003CA\u00151\u001d\tQc\u0006\u0005\u0002,35\tAF\u0003\u0002.+\u00051AH]8pizJ!aL\r\u0002\rA\u0013X\rZ3g\u0013\t\t$G\u0001\u0004TiJLgn\u001a\u0006\u0003_e\tQAZ5mK\u0002\na\u0001P5oSRtDC\u0001\u001c9!\t9\u0004!D\u0001\u0010\u0011\u001513\u00011\u0001)\u0003%y&-\u001e4gKJLE-F\u0001<!\rABHP\u0005\u0003{e\u0011aa\u00149uS>t\u0007C\u0001\r@\u0013\t\u0001\u0015DA\u0002J]R\fQb\u00182vM\u001a,'/\u00133`I\u0015\fHCA\"G!\tAB)\u0003\u0002F3\t!QK\\5u\u0011\u001d9U!!AA\u0002m\n1\u0001\u001f\u00132\u0003)y&-\u001e4gKJLE\rI\u0001\fS:LGoV5uQ\u0016CH\u000fF\u0001DQ\r9AJ\u0015\t\u000415{\u0015B\u0001(\u001a\u0005\u0019!\bN]8xgB\u0011q\u0007U\u0005\u0003#>\u0011qb\u00149f]\u0006cW\t_2faRLwN\\\u0019\u0005=!\u001a6.M\u0003$)^3\u0007,\u0006\u0002(+\u0012)a+\u0006b\u00017\n\tA+\u0003\u0002Y3\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIER!AW\r\u0002\rQD'o\\<t#\tav\f\u0005\u0002\u0019;&\u0011a,\u0007\u0002\b\u001d>$\b.\u001b8h!\t\u00017M\u0004\u0002\u0019C&\u0011!-G\u0001\ba\u0006\u001c7.Y4f\u0013\t!WMA\u0005UQJ|w/\u00192mK*\u0011!-G\u0019\u0006G\u001dD\u0017N\u0017\b\u00031!L!AW\r2\t\tB\u0012D\u001b\u0002\u0006g\u000e\fG.Y\u0019\u0003M=\u000bA\"\u001b8ji\u001a\u000bG\u000e\u001c2bG.D3\u0001\u0003'oc\u0011q\u0002f\u001c:2\u000b\r\"v\u000b\u001d-2\u000b\r:\u0007.\u001d.2\t\tB\u0012D[\u0019\u0003M=\u000b!B\\;n'\u0006l\u0007\u000f\\3t+\u0005q\u0014AC:b[BdWMU1uK\u0006Y1/Y7qY\u0016\u0014\u0016\r^3!\u0003!\u0011WO\u001a4fe&#\u0017\u0001\u00044sK\u0016\u0014Vm]8ve\u000e,\u0007")
public class SoundBuffer
implements Resource,
Logging {
    private final String file;
    private Option<Object> _bufferId;
    private final int sampleRate;
    private Logger logger;

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void ocelot$desktop$util$Logging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public String file() {
        return this.file;
    }

    private Option<Object> _bufferId() {
        return this._bufferId;
    }

    private void _bufferId_$eq(Option<Object> x$1) {
        this._bufferId = x$1;
    }

    private void initWithExt() throws OpenAlException {
        ByteBuffer fileBuffer = FileUtils$.MODULE$.load(this.file());
        if (fileBuffer == null) {
            this.logger().error(new StringBuilder(18).append("Could not load '").append(this.file()).append("'!").toString());
            return;
        }
        AL10W$.MODULE$.alBufferData(BoxesRunTime.unboxToInt(this.bufferId().get()), 65539, fileBuffer, -1);
    }

    private void initFallback() throws OpenAlException {
        SoundSamples ogg = OggDecoder$.MODULE$.decode(this.getClass().getResourceAsStream(this.file()));
        this._bufferId_$eq(ogg.genBuffer());
    }

    public int numSamples() {
        Option<Object> option = this.bufferId();
        if (option instanceof Some) {
            Some some = (Some)option;
            int bufferId = BoxesRunTime.unboxToInt(some.value());
            return BoxesRunTime.unboxToInt(OpenAlException$.MODULE$.defaulting(() -> 0).apply(() -> {
                int sizeBytes = AL10W$.MODULE$.alGetBufferi(bufferId, 8196);
                int channels = AL10W$.MODULE$.alGetBufferi(bufferId, 8195);
                int bits = AL10W$.MODULE$.alGetBufferi(bufferId, 8194);
                return sizeBytes * 8 / channels / bits;
            }));
        }
        if (None$.MODULE$.equals(option)) {
            return 0;
        }
        throw new MatchError(option);
    }

    public int sampleRate() {
        return this.sampleRate;
    }

    public Option<Object> bufferId() {
        return this._bufferId();
    }

    @Override
    public void freeResource() {
        Resource.freeResource$(this);
        this.bufferId().foreach(bufferId -> OpenAlException$.MODULE$.ignoring().apply(() -> AL10W$.MODULE$.alDeleteBuffers(bufferId)));
    }

    public SoundBuffer(String file) {
        int n2;
        this.file = file;
        Resource.$init$(this);
        Logging.$init$(this);
        this._bufferId = None$.MODULE$;
        Audio$ audio$ = Audio$.MODULE$;
        synchronized (audio$) {
            OpenAlException$.MODULE$.ignoring().apply(() -> {
                if (!Audio$.MODULE$.isDisabled()) {
                    this.logger().debug(new StringBuilder(31).append("Loading sound buffer from '").append(this.file()).append("'...").toString());
                    this._bufferId_$eq(new Some<Object>(BoxesRunTime.boxToInteger(AL10W$.MODULE$.alGenBuffers())));
                    if (AL10W$.MODULE$.alIsExtensionPresent("AL_EXT_vorbis")) {
                        this.initWithExt();
                        return;
                    }
                    this.initFallback();
                    return;
                }
                this.logger().debug(new StringBuilder(68).append("Skipping loading sound buffer from '").append(this.file()).append("' because audio is not available").toString());
            });
        }
        Option<Object> option = this.bufferId();
        if (option instanceof Some) {
            Some some = (Some)option;
            int bufferId = BoxesRunTime.unboxToInt(some.value());
            n2 = BoxesRunTime.unboxToInt(OpenAlException$.MODULE$.defaulting(() -> 44100).apply(() -> {
                int n2;
                Audio$ audio$ = Audio$.MODULE$;
                synchronized (audio$) {
                    n2 = AL10W$.MODULE$.alGetBufferi(bufferId, 8193);
                }
                return n2;
            }));
        } else if (None$.MODULE$.equals(option)) {
            n2 = 44100;
        } else {
            throw new MatchError(option);
        }
        this.sampleRate = n2;
        Statics.releaseFence();
    }
}

