/*
 * Decompiled with CFR 0.152.
 */
package ocelot.desktop.geometry;

import java.io.Serializable;
import ocelot.desktop.geometry.Quaternion;
import ocelot.desktop.geometry.Vector3D;
import ocelot.desktop.geometry.Vector3D$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple4;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichFloat$;

public final class Quaternion$
implements Serializable {
    public static final Quaternion$ MODULE$ = new Quaternion$();

    public Quaternion apply(Vector3D v, float w) {
        return new Quaternion(v.x(), v.y(), v.z(), w);
    }

    public Quaternion identity() {
        return new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
    }

    public Quaternion axisAngle(Vector3D axis, float angle) {
        if ((double)RichFloat$.MODULE$.abs$extension(Predef$.MODULE$.floatWrapper(angle)) < 1.0E-7) {
            return this.identity();
        }
        Vector3D _axis = (double)axis.length() < 1.0E-7 ? Vector3D$.MODULE$.AxisY() : axis;
        float cos2 = (float)package$.MODULE$.cos((double)angle * 0.5);
        float sin2 = (float)package$.MODULE$.sin((double)angle * 0.5);
        return this.apply(_axis.normalize().$times(sin2), cos2);
    }

    public Quaternion euler(Vector3D euler) {
        float c1 = (float)package$.MODULE$.cos((double)euler.z() * 0.5);
        float c2 = (float)package$.MODULE$.cos((double)euler.y() * 0.5);
        float c3 = (float)package$.MODULE$.cos((double)euler.x() * 0.5);
        float s1 = (float)package$.MODULE$.sin((double)euler.z() * 0.5);
        float s2 = (float)package$.MODULE$.sin((double)euler.y() * 0.5);
        float s3 = (float)package$.MODULE$.sin((double)euler.x() * 0.5);
        float x = c1 * c2 * s3 - s1 * s2 * c3;
        float y = c1 * s2 * c3 + s1 * c2 * s3;
        float z = s1 * c2 * c3 - c1 * s2 * s3;
        float w = c1 * c2 * c3 + s1 * s2 * s3;
        return new Quaternion(x, y, z, w);
    }

    public Quaternion between(Vector3D v1, Vector3D v2) {
        Vector3D v = v1.cross(v2);
        float w = v1.length() * v2.length() + v1.dot(v2);
        return this.apply(v, w);
    }

    public Quaternion apply(float x, float y, float z, float w) {
        return new Quaternion(x, y, z, w);
    }

    public Option<Tuple4<Object, Object, Object, Object>> unapply(Quaternion x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some<Tuple4<Object, Object, Object, Object>>(new Tuple4<Float, Float, Float, Float>(BoxesRunTime.boxToFloat(x$0.x()), BoxesRunTime.boxToFloat(x$0.y()), BoxesRunTime.boxToFloat(x$0.z()), BoxesRunTime.boxToFloat(x$0.w())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Quaternion$.class);
    }

    private Quaternion$() {
    }
}

