/*
 * Decompiled with CFR 0.152.
 */
package ocelot.desktop.graphics;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.ByteBuffer;
import ocelot.desktop.geometry.Rect2D;
import ocelot.desktop.graphics.Font$;
import ocelot.desktop.graphics.Texture;
import ocelot.desktop.util.Logging;
import ocelot.desktop.util.Resource;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.IntMap;
import scala.collection.immutable.IntMap$;
import scala.collection.mutable.HashMap;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import totoro.ocelot.brain.util.FontUtils$;

@ScalaSignature(bytes="\u0006\u0005\u0005%c\u0001\u0002\u0013&\u00011B\u0001\u0002\u0010\u0001\u0003\u0006\u0004%\t!\u0010\u0005\t\u0013\u0002\u0011\t\u0011)A\u0005}!A!\n\u0001BC\u0002\u0013\u00051\n\u0003\u0005P\u0001\t\u0005\t\u0015!\u0003M\u0011\u0015\u0001\u0006\u0001\"\u0001R\u0011\u001d1\u0006A1A\u0005\u0002-Caa\u0016\u0001!\u0002\u0013a\u0005b\u0002-\u0001\u0005\u0004%\ta\u0013\u0005\u00073\u0002\u0001\u000b\u0011\u0002'\t\u000fi\u0003\u0001\u0019!C\u0005\u0017\"91\f\u0001a\u0001\n\u0013a\u0006B\u00022\u0001A\u0003&A\nC\u0004d\u0001\u0001\u0007I\u0011B&\t\u000f\u0011\u0004\u0001\u0019!C\u0005K\"1q\r\u0001Q!\n1Cq\u0001\u001b\u0001C\u0002\u0013%\u0011\u000e\u0003\u0004u\u0001\u0001\u0006IA\u001b\u0005\nk\u0002\u0001\r\u00111A\u0005\u0002YD1\"a\u0003\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u000e!Q\u0011\u0011\u0003\u0001A\u0002\u0003\u0005\u000b\u0015B<\t\u0017\u0005M\u0001\u00011AA\u0002\u0013\u0005\u0011Q\u0003\u0005\f\u0003;\u0001\u0001\u0019!a\u0001\n\u0003\ty\u0002C\u0006\u0002$\u0001\u0001\r\u0011!Q!\n\u0005]\u0001bBA\u0013\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0003[\u0001A\u0011BA\u0018\u0011\u001d\t\t\u0004\u0001C\u0005\u0003gAq!!\u000e\u0001\t\u0003\nycB\u0004\u00028\u0015B\t!!\u000f\u0007\r\u0011*\u0003\u0012AA\u001e\u0011\u0019\u0001V\u0004\"\u0001\u0002>!I\u0011qH\u000fC\u0002\u0013\u0005\u0011\u0011\t\u0005\b\u0003\u0007j\u0002\u0015!\u0003S\u0011%\t)%\bb\u0001\n\u0003\t\t\u0005C\u0004\u0002Hu\u0001\u000b\u0011\u0002*\t\u000f\u0005UR\u0004\"\u0011\u00020\t!ai\u001c8u\u0015\t1s%\u0001\u0005he\u0006\u0004\b.[2t\u0015\tA\u0013&A\u0004eKN\\Go\u001c9\u000b\u0003)\naa\\2fY>$8\u0001A\n\u0005\u00015\u001a\u0014\b\u0005\u0002/c5\tqFC\u00011\u0003\u0015\u00198-\u00197b\u0013\t\u0011tF\u0001\u0004B]f\u0014VM\u001a\t\u0003i]j\u0011!\u000e\u0006\u0003m\u001d\nA!\u001e;jY&\u0011\u0001(\u000e\u0002\t%\u0016\u001cx.\u001e:dKB\u0011AGO\u0005\u0003wU\u0012q\u0001T8hO&tw-\u0001\u0003oC6,W#\u0001 \u0011\u0005}2eB\u0001!E!\t\tu&D\u0001C\u0015\t\u00195&\u0001\u0004=e>|GOP\u0005\u0003\u000b>\na\u0001\u0015:fI\u00164\u0017BA$I\u0005\u0019\u0019FO]5oO*\u0011QiL\u0001\u0006]\u0006lW\rI\u0001\tM>tGoU5{KV\tA\n\u0005\u0002/\u001b&\u0011aj\f\u0002\u0004\u0013:$\u0018!\u00034p]R\u001c\u0016N_3!\u0003\u0019a\u0014N\\5u}Q\u0019!\u000bV+\u0011\u0005M\u0003Q\"A\u0013\t\u000bq*\u0001\u0019\u0001 \t\u000b)+\u0001\u0019\u0001'\u0002\u0015\u0005#H.Y:XS\u0012$\b.A\u0006Bi2\f7oV5ei\"\u0004\u0013aC!uY\u0006\u001c\b*Z5hQR\fA\"\u0011;mCNDU-[4ii\u0002\n!b\u001a7za\"\u001cu.\u001e8u\u000399G.\u001f9i\u0007>,h\u000e^0%KF$\"!\u00181\u0011\u00059r\u0016BA00\u0005\u0011)f.\u001b;\t\u000f\u0005\\\u0011\u0011!a\u0001\u0019\u0006\u0019\u0001\u0010J\u0019\u0002\u0017\u001dd\u0017\u0010\u001d5D_VtG\u000fI\u0001\u0015_V$xJ\u001a*b]\u001e,w\t\\=qQ\u000e{WO\u001c;\u00021=,Ho\u00144SC:<Wm\u00127za\"\u001cu.\u001e8u?\u0012*\u0017\u000f\u0006\u0002^M\"9\u0011MDA\u0001\u0002\u0004a\u0015!F8vi>3'+\u00198hK\u001ec\u0017\u0010\u001d5D_VtG\u000fI\u0001\u0006CRd\u0017m]\u000b\u0002UB\u00111N]\u0007\u0002Y*\u0011QN\\\u0001\u0006S6\fw-\u001a\u0006\u0003_B\f1!Y<u\u0015\u0005\t\u0018\u0001\u00026bm\u0006L!a\u001d7\u0003\u001b\t+hMZ3sK\u0012LU.Y4f\u0003\u0019\tG\u000f\\1tA\u0005\u0019Q.\u00199\u0016\u0003]\u00042\u0001_?\u0000\u001b\u0005I(B\u0001>|\u0003%IW.\\;uC\ndWM\u0003\u0002}_\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005yL(AB%oi6\u000b\u0007\u000f\u0005\u0003\u0002\u0002\u0005\u001dQBAA\u0002\u0015\r\t)aJ\u0001\tO\u0016|W.\u001a;ss&!\u0011\u0011BA\u0002\u0005\u0019\u0011Vm\u0019;3\t\u00069Q.\u00199`I\u0015\fHcA/\u0002\u0010!9\u0011mEA\u0001\u0002\u00049\u0018\u0001B7ba\u0002\nq\u0001^3yiV\u0014X-\u0006\u0002\u0002\u0018A\u00191+!\u0007\n\u0007\u0005mQEA\u0004UKb$XO]3\u0002\u0017Q,\u0007\u0010^;sK~#S-\u001d\u000b\u0004;\u0006\u0005\u0002\u0002C1\u0017\u0003\u0003\u0005\r!a\u0006\u0002\u0011Q,\u0007\u0010^;sK\u0002\n\u0011b\u00195be^KG\r\u001e5\u0015\u00071\u000bI\u0003\u0003\u0004\u0002,a\u0001\r\u0001T\u0001\nG>$W\rU8j]R\fA!\u001b8jiR\tQ,A\u0006nC.,G+\u001a=ukJ,GCAA\f\u000311'/Z3SKN|WO]2f\u0003\u00111uN\u001c;\u0011\u0005Mk2cA\u000f.gQ\u0011\u0011\u0011H\u0001\u000b\u001d>\u0014X.\u00197G_:$X#\u0001*\u0002\u00179{'/\\1m\r>tG\u000fI\u0001\n'6\fG\u000e\u001c$p]R\f!bU7bY24uN\u001c;!\u0001")
public class Font
implements Resource,
Logging {
    private final String name;
    private final int fontSize;
    private final int AtlasWidth;
    private final int AtlasHeight;
    private int glyphCount;
    private int outOfRangeGlyphCount;
    private final BufferedImage atlas;
    private IntMap<Rect2D> map;
    private Texture texture;
    private Logger logger;

    public static Font SmallFont() {
        return Font$.MODULE$.SmallFont();
    }

    public static Font NormalFont() {
        return Font$.MODULE$.NormalFont();
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void ocelot$desktop$util$Logging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public String name() {
        return this.name;
    }

    public int fontSize() {
        return this.fontSize;
    }

    public int AtlasWidth() {
        return this.AtlasWidth;
    }

    public int AtlasHeight() {
        return this.AtlasHeight;
    }

    private int glyphCount() {
        return this.glyphCount;
    }

    private void glyphCount_$eq(int x$1) {
        this.glyphCount = x$1;
    }

    private int outOfRangeGlyphCount() {
        return this.outOfRangeGlyphCount;
    }

    private void outOfRangeGlyphCount_$eq(int x$1) {
        this.outOfRangeGlyphCount = x$1;
    }

    private BufferedImage atlas() {
        return this.atlas;
    }

    public IntMap<Rect2D> map() {
        return this.map;
    }

    public void map_$eq(IntMap<Rect2D> x$1) {
        this.map = x$1;
    }

    public Texture texture() {
        return this.texture;
    }

    public void texture_$eq(Texture x$1) {
        this.texture = x$1;
    }

    public int charWidth(int codePoint) {
        return (int)(((Rect2D)this.map().getOrElse(codePoint, (Function0<Rect2D> & Serializable)() -> this.map().apply(63))).w() * (float)this.AtlasWidth());
    }

    private void init() {
        this.logger().info(StringOps$.MODULE$.format$extension("Loading font %s", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{this.name()})));
        HashMap rawMap = new HashMap();
        IntRef ox = IntRef.create(0);
        IntRef oy = IntRef.create(0);
        URL resource = this.getClass().getResource(StringOps$.MODULE$.format$extension("/ocelot/desktop/%s.hex", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{this.name()})));
        BufferedSource source = Source$.MODULE$.fromInputStream((InputStream)resource.getContent(), Codec$.MODULE$.UTF8());
        source.getLines().foreach((Function1<String, Object> & Serializable)line -> {
            Font.$anonfun$init$1(this, ox, oy, rawMap, line);
            return BoxedUnit.UNIT;
        });
        int size = this.atlas().getRaster().getDataBuffer().getSize();
        this.logger().info(new StringBuilder(44).append("Packed ").append(this.glyphCount()).append(" glyphs into ").append(this.AtlasWidth()).append("x").append(this.AtlasHeight()).append(" 1-bit texture (").append(size).append(" bytes)").toString());
        this.logger().info(new StringBuilder(23).append("Skipped ").append(this.outOfRangeGlyphCount()).append(" non-BMP glyphs").toString());
        this.map_$eq(IntMap$.MODULE$.from(rawMap));
        this.texture_$eq(this.makeTexture());
    }

    private Texture makeTexture() {
        DataBufferByte bytes = (DataBufferByte)this.atlas().getRaster().getDataBuffer();
        ByteBuffer buf = ByteBuffer.allocateDirect(this.AtlasWidth() * this.AtlasHeight() * 1);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.byteArrayOps(bytes.getData()), (Function1<Object, ByteBuffer> & Serializable)b2 -> Font.$anonfun$makeTexture$1(buf, BoxesRunTime.unboxToByte(b2)));
        buf.flip();
        Texture tex = new Texture();
        tex.bind(tex.bind$default$1());
        GL11.glPixelStorei(3317, 1);
        tex.set(this.AtlasWidth(), this.AtlasHeight(), 6403, 5121, buf);
        return tex;
    }

    @Override
    public void freeResource() {
        Resource.freeResource$(this);
        this.texture().freeResource();
    }

    public static final /* synthetic */ void $anonfun$init$2(Font $this, IntRef ox$1, IntRef x$3, IntRef oy$1, IntRef y$1, int width$1, char c2) {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(3), 0).by(-1).foreach$mVc$sp(i2 -> {
            int n2;
            int bit = Character.digit(c2, 16) >> i2 & 1;
            BufferedImage bufferedImage = $this.atlas();
            int n3 = ox$1.elem + x$3.elem;
            int n4 = oy$1.elem + y$1.elem;
            int n5 = bit;
            switch (n5) {
                case 0: {
                    n2 = 0;
                    break;
                }
                case 1: {
                    n2 = -1;
                    break;
                }
                default: {
                    throw new MatchError(BoxesRunTime.boxToInteger(n5));
                }
            }
            bufferedImage.setRGB(n3, n4, n2);
            ++x$3.elem;
            if (x$3.elem == width$1) {
                x$3.elem = 0;
                ++y$1.elem;
                return;
            }
        });
    }

    public static final /* synthetic */ void $anonfun$init$1(Font $this, IntRef ox$1, IntRef oy$1, HashMap rawMap$1, String line) {
        int colon2 = line.indexOf(58);
        int charCode = Integer.parseInt(line.substring(0, colon2), 16);
        if (charCode >= 0 && charCode < FontUtils$.MODULE$.codepoint_limit()) {
            int expectedWidth = FontUtils$.MODULE$.wcwidth(charCode);
            if (expectedWidth >= 1) {
                int width = (line.length() - colon2 - 1) * 4 / $this.fontSize();
                if (ox$1.elem + width > $this.AtlasWidth()) {
                    ox$1.elem = 0;
                    oy$1.elem += $this.fontSize();
                }
                rawMap$1.update(BoxesRunTime.boxToInteger(charCode), new Rect2D((float)ox$1.elem / (float)$this.AtlasWidth(), (float)oy$1.elem / (float)$this.AtlasHeight(), (float)width / (float)$this.AtlasWidth(), (float)$this.fontSize() / (float)$this.AtlasHeight()));
                IntRef x = IntRef.create(0);
                IntRef y = IntRef.create(0);
                StringOps$.MODULE$.foreach$extension(Predef$.MODULE$.augmentString(line.substring(colon2 + 1)), (Function1<Object, Object> & Serializable)object -> {
                    Font.$anonfun$init$2($this, ox$1, x, oy$1, y, width, BoxesRunTime.unboxToChar(object));
                    return BoxedUnit.UNIT;
                });
                ox$1.elem += width;
                $this.glyphCount_$eq($this.glyphCount() + 1);
                return;
            }
            return;
        }
        $this.outOfRangeGlyphCount_$eq($this.outOfRangeGlyphCount() + 1);
        $this.logger().warn(String.format("Unicode font contained unexpected glyph: U+%04X, ignoring", BoxesRunTime.boxToInteger(charCode)));
    }

    public static final /* synthetic */ ByteBuffer $anonfun$makeTexture$1(ByteBuffer buf$1, byte b2) {
        buf$1.put((byte)((b2 >> 7 & 1) * 255));
        buf$1.put((byte)((b2 >> 6 & 1) * 255));
        buf$1.put((byte)((b2 >> 5 & 1) * 255));
        buf$1.put((byte)((b2 >> 4 & 1) * 255));
        buf$1.put((byte)((b2 >> 3 & 1) * 255));
        buf$1.put((byte)((b2 >> 2 & 1) * 255));
        buf$1.put((byte)((b2 >> 1 & 1) * 255));
        return buf$1.put((byte)((b2 >> 0 & 1) * 255));
    }

    public Font(String name, int fontSize) {
        this.name = name;
        this.fontSize = fontSize;
        Resource.$init$(this);
        Logging.$init$(this);
        this.AtlasWidth = 4096;
        this.AtlasHeight = 4096;
        this.glyphCount = 0;
        this.outOfRangeGlyphCount = 0;
        byte[] icmArr = new byte[]{(byte)0, (byte)255};
        IndexColorModel icm = new IndexColorModel(1, 2, icmArr, icmArr, icmArr, icmArr);
        this.atlas = new BufferedImage(this.AtlasWidth(), this.AtlasHeight(), 12, icm);
        this.init();
        Statics.releaseFence();
    }
}

