/*
 * Decompiled with CFR 0.152.
 */
package ocelot.desktop.graphics.buffer;

import java.io.Serializable;
import java.nio.ByteBuffer;
import ocelot.desktop.graphics.buffer.BufferPut;
import ocelot.desktop.util.Logging;
import ocelot.desktop.util.Resource;
import org.apache.logging.log4j.Logger;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL15;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005=a\u0001B\u000b\u0017\u0001}AQ\u0001\r\u0001\u0005\u0002EBqa\u0010\u0001C\u0002\u0013\u0005\u0001\t\u0003\u0004E\u0001\u0001\u0006I!\u0011\u0005\b/\u0001\u0011\r\u0011\"\u0001A\u0011\u0019)\u0005\u0001)A\u0005\u0003\"Ia\t\u0001a\u0001\u0002\u0004%\t\u0001\u0011\u0005\n\u000f\u0002\u0001\r\u00111A\u0005\u0002!C\u0011B\u0014\u0001A\u0002\u0003\u0005\u000b\u0015B!\t\u0013=\u0003\u0001\u0019!a\u0001\n\u0003\u0001\u0005\"\u0003)\u0001\u0001\u0004\u0005\r\u0011\"\u0001R\u0011%\u0019\u0006\u00011A\u0001B\u0003&\u0011\tC\u0003U\u0001\u0011\u0005S\u000bC\u00031\u0001\u0011\u0005a\u000bC\u0003f\u0001\u0011\u0005a\rC\u0003t\u0001\u0011\u0005A\u000fC\u0003x\u0001\u0011E\u0001\u0010C\u0003}\u0001\u0011EQ\u0010\u0003\u0004\u0000\u0001\u0011%\u0011\u0011\u0001\u0005\b\u0003\u000b\u0001A\u0011CA\u0004\u0011\u0019\ti\u0001\u0001C\u0001+\n1!)\u001e4gKJT!a\u0006\r\u0002\r\t,hMZ3s\u0015\tI\"$\u0001\u0005he\u0006\u0004\b.[2t\u0015\tYB$A\u0004eKN\\Go\u001c9\u000b\u0003u\taa\\2fY>$8\u0001A\u000b\u0003AY\u001aB\u0001A\u0011([A\u0011!%J\u0007\u0002G)\tA%A\u0003tG\u0006d\u0017-\u0003\u0002'G\t1\u0011I\\=SK\u001a\u0004\"\u0001K\u0016\u000e\u0003%R!A\u000b\u000e\u0002\tU$\u0018\u000e\\\u0005\u0003Y%\u0012q\u0001T8hO&tw\r\u0005\u0002)]%\u0011q&\u000b\u0002\t%\u0016\u001cx.\u001e:dK\u00061A(\u001b8jiz\"\u0012A\r\t\u0004g\u0001!T\"\u0001\f\u0011\u0005U2D\u0002\u0001\u0003\u0006o\u0001\u0011\r\u0001\u000f\u0002\u0002)F\u0011\u0011\b\u0010\t\u0003EiJ!aO\u0012\u0003\u000f9{G\u000f[5oOB\u00111'P\u0005\u0003}Y\u0011\u0011BQ;gM\u0016\u0014\b+\u001e;\u0002\rQ\f'oZ3u+\u0005\t\u0005C\u0001\u0012C\u0013\t\u00195EA\u0002J]R\fq\u0001^1sO\u0016$\b%A\u0004ck\u001a4WM\u001d\u0011\u0002\u0011\r\f\u0007/Y2jif\fAbY1qC\u000eLG/_0%KF$\"!\u0013'\u0011\u0005\tR\u0015BA&$\u0005\u0011)f.\u001b;\t\u000f5;\u0011\u0011!a\u0001\u0003\u0006\u0019\u0001\u0010J\u0019\u0002\u0013\r\f\u0007/Y2jif\u0004\u0013AB:ue&$W-\u0001\u0006tiJLG-Z0%KF$\"!\u0013*\t\u000f5S\u0011\u0011!a\u0001\u0003\u000691\u000f\u001e:jI\u0016\u0004\u0013\u0001\u00044sK\u0016\u0014Vm]8ve\u000e,G#A%\u0015\u0005I:\u0006\"\u0002-\u000e\u0001\u0004I\u0016\u0001C3mK6,g\u000e^:\u0011\u0007i\u0013GG\u0004\u0002\\A:\u0011AlX\u0007\u0002;*\u0011aLH\u0001\u0007yI|w\u000e\u001e \n\u0003\u0011J!!Y\u0012\u0002\u000fA\f7m[1hK&\u00111\r\u001a\u0002\u0004'\u0016\f(BA1$\u0003\u00159(/\u001b;f)\rIu-\u001b\u0005\u0006Q:\u0001\r!Q\u0001\u0007_\u001a47/\u001a;\t\u000b)t\u0001\u0019A6\u0002\u0007\t,h\r\u0005\u0002mc6\tQN\u0003\u0002o_\u0006\u0019a.[8\u000b\u0003A\fAA[1wC&\u0011!/\u001c\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\u0018A\u0002:fg&TX\r\u0006\u0002Jk\")ao\u0004a\u0001\u0003\u00061a.Z<DCB\fQb\u0019:fCR,G)\u001f8b[&\u001cGcA%zu\")q\n\u0005a\u0001\u0003\")1\u0010\u0005a\u0001\u0003\u0006\u00191-\u00199\u0002\u0019\r\u0014X-\u0019;f'R\fG/[2\u0015\u0005%s\b\"\u0002-\u0012\u0001\u0004I\u0016!D:u_J,W\t\\3nK:$8\u000fF\u0002l\u0003\u0007AQ\u0001\u0017\nA\u0002e\u000b1\"\u001a=ue\u0006\u001cG/T3uCR\u0019\u0011*!\u0003\t\r\u0005-1\u00031\u00015\u0003\u0011AW-\u00193\u0002\t\tLg\u000e\u001a")
public class Buffer<T extends BufferPut>
implements Logging,
Resource {
    private final int target;
    private final int buffer;
    private int capacity;
    private int stride;
    private Logger logger;

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void ocelot$desktop$util$Logging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public int target() {
        return this.target;
    }

    public int buffer() {
        return this.buffer;
    }

    public int capacity() {
        return this.capacity;
    }

    public void capacity_$eq(int x$1) {
        this.capacity = x$1;
    }

    public int stride() {
        return this.stride;
    }

    public void stride_$eq(int x$1) {
        this.stride = x$1;
    }

    @Override
    public void freeResource() {
        Resource.freeResource$(this);
        GL15.glDeleteBuffers(this.buffer());
    }

    public void write(int offset, ByteBuffer buf) {
        this.bind();
        GL15.glBufferSubData(this.target(), (long)offset * (long)this.stride(), buf);
    }

    public void resize(int newCap) {
        this.createDynamic(this.stride(), newCap);
    }

    public void createDynamic(int stride, int cap) {
        this.bind();
        GL15.glBufferData(this.target(), stride * cap, 35048);
        this.stride_$eq(stride);
        this.capacity_$eq(cap);
    }

    public void createStatic(Seq<T> elements) {
        Predef$.MODULE$.assert(elements.nonEmpty(), (Function0<Object>)(Function0<String> & Serializable)() -> "Zero size immutable buffer");
        this.extractMeta((BufferPut)elements.head());
        this.bind();
        ByteBuffer buf = this.storeElements(elements);
        GL15.glBufferData(this.target(), buf, 35044);
        this.capacity_$eq(elements.length());
    }

    private ByteBuffer storeElements(Seq<T> elements) {
        ByteBuffer data = BufferUtils.createByteBuffer(elements.length() * ((BufferPut)elements.head()).stride());
        elements.foreach((Function1<BufferPut, Object> & Serializable)element -> {
            element.put(data);
            return BoxedUnit.UNIT;
        });
        data.flip();
        return data;
    }

    public void extractMeta(T head) {
        this.stride_$eq(head.stride());
    }

    public void bind() {
        GL15.glBindBuffer(this.target(), this.buffer());
    }

    public Buffer() {
        Logging.$init$(this);
        Resource.$init$(this);
        this.target = 34962;
        this.buffer = GL15.glGenBuffers();
        Statics.releaseFence();
    }

    public Buffer(Seq<T> elements) {
        this();
        this.createStatic(elements);
    }
}

