/*
 * Decompiled with CFR 0.152.
 */
package ocelot.desktop.graphics.mesh;

import java.io.Serializable;
import ocelot.desktop.graphics.ShaderProgram;
import ocelot.desktop.graphics.buffer.IndexBuffer;
import ocelot.desktop.graphics.buffer.VertexBuffer;
import ocelot.desktop.graphics.mesh.Attribute;
import ocelot.desktop.graphics.mesh.Vertex;
import ocelot.desktop.util.Logging;
import ocelot.desktop.util.Resource;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.APPLEVertexArrayObject;
import org.lwjgl.opengl.ARBInstancedArrays;
import org.lwjgl.opengl.ARBVertexArrayObject;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GLContext;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005i4Aa\u0004\t\u00013!A\u0011\u0006\u0001B\u0001B\u0003%!\u0006C\u0003/\u0001\u0011\u0005q\u0006C\u00044\u0001\t\u0007I\u0011\u0002\u001b\t\ra\u0002\u0001\u0015!\u00036\u0011\u001dI\u0004\u00011A\u0005\niBq\u0001\u0012\u0001A\u0002\u0013%Q\t\u0003\u0004L\u0001\u0001\u0006Ka\u000f\u0005\b\u0019\u0002\u0011\r\u0011\"\u0001N\u0011\u0019\t\u0006\u0001)A\u0005\u001d\")!\u000b\u0001C\u0001'\"9a\rAI\u0001\n\u00039\u0007\"\u0002;\u0001\t\u0003)\b\"B<\u0001\t\u0003A\b\"B=\u0001\t\u0003B(a\u0003,feR,\u00070\u0011:sCfT!!\u0005\n\u0002\t5,7\u000f\u001b\u0006\u0003'Q\t\u0001b\u001a:ba\"L7m\u001d\u0006\u0003+Y\tq\u0001Z3tWR|\u0007OC\u0001\u0018\u0003\u0019y7-\u001a7pi\u000e\u00011\u0003\u0002\u0001\u001bA\u0019\u0002\"a\u0007\u0010\u000e\u0003qQ\u0011!H\u0001\u0006g\u000e\fG.Y\u0005\u0003?q\u0011a!\u00118z%\u00164\u0007CA\u0011%\u001b\u0005\u0011#BA\u0012\u0015\u0003\u0011)H/\u001b7\n\u0005\u0015\u0012#a\u0002'pO\u001eLgn\u001a\t\u0003C\u001dJ!\u0001\u000b\u0012\u0003\u0011I+7o\\;sG\u0016\faa\u001d5bI\u0016\u0014\bCA\u0016-\u001b\u0005\u0011\u0012BA\u0017\u0013\u00055\u0019\u0006.\u00193feB\u0013xn\u001a:b[\u00061A(\u001b8jiz\"\"\u0001\r\u001a\u0011\u0005E\u0002Q\"\u0001\t\t\u000b%\u0012\u0001\u0019\u0001\u0016\u0002\u000f%\u001cX*Y2P'V\tQ\u0007\u0005\u0002\u001cm%\u0011q\u0007\b\u0002\b\u0005>|G.Z1o\u0003!I7/T1d\u001fN\u0003\u0013aC5oI\u0016D()\u001e4gKJ,\u0012a\u000f\t\u00047qr\u0014BA\u001f\u001d\u0005\u0019y\u0005\u000f^5p]B\u0011qHQ\u0007\u0002\u0001*\u0011\u0011IE\u0001\u0007EV4g-\u001a:\n\u0005\r\u0003%aC%oI\u0016D()\u001e4gKJ\fq\"\u001b8eKb\u0014UO\u001a4fe~#S-\u001d\u000b\u0003\r&\u0003\"aG$\n\u0005!c\"\u0001B+oSRDqA\u0013\u0004\u0002\u0002\u0003\u00071(A\u0002yIE\nA\"\u001b8eKb\u0014UO\u001a4fe\u0002\nQ!\u0019:sCf,\u0012A\u0014\t\u00037=K!\u0001\u0015\u000f\u0003\u0007%sG/\u0001\u0004beJ\f\u0017\u0010I\u0001\u0010C\u0012$g+\u001a:uKb\u0014UO\u001a4feV\u0011Ak\u0017\u000b\u0004\rV#\u0007\"B!\u000b\u0001\u00041\u0006cA X3&\u0011\u0001\f\u0011\u0002\r-\u0016\u0014H/\u001a=Ck\u001a4WM\u001d\t\u00035nc\u0001\u0001B\u0003]\u0015\t\u0007QLA\u0001W#\tq\u0016\r\u0005\u0002\u001c?&\u0011\u0001\r\b\u0002\b\u001d>$\b.\u001b8h!\t\t$-\u0003\u0002d!\t1a+\u001a:uKbDq!\u001a\u0006\u0011\u0002\u0003\u0007Q'A\u0005j]N$\u0018M\\2fI\u0006I\u0012\r\u001a3WKJ$X\r\u001f\"vM\u001a,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\tA7/F\u0001jU\t)$nK\u0001l!\ta\u0017/D\u0001n\u0015\tqw.A\u0005v]\u000eDWmY6fI*\u0011\u0001\u000fH\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001:n\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0003\u00069.\u0011\r!X\u0001\u000fC\u0012$\u0017J\u001c3fq\n+hMZ3s)\t1e\u000fC\u0003B\u0019\u0001\u0007a(\u0001\u0003cS:$G#\u0001$\u0002\u0019\u0019\u0014X-\u001a*fg>,(oY3")
public class VertexArray
implements Logging,
Resource {
    private final ShaderProgram shader;
    private final boolean isMacOS;
    private Option<IndexBuffer> indexBuffer;
    private final int array;
    private Logger logger;

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void ocelot$desktop$util$Logging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private boolean isMacOS() {
        return this.isMacOS;
    }

    private Option<IndexBuffer> indexBuffer() {
        return this.indexBuffer;
    }

    private void indexBuffer_$eq(Option<IndexBuffer> x$1) {
        this.indexBuffer = x$1;
    }

    public int array() {
        return this.array;
    }

    public <V extends Vertex> void addVertexBuffer(VertexBuffer<V> buffer, boolean instanced) {
        this.bind();
        buffer.ty().attributes().foreach((Function1<Attribute, Object> & Serializable)attr -> {
            VertexArray.$anonfun$addVertexBuffer$1(this, buffer, instanced, attr);
            return BoxedUnit.UNIT;
        });
    }

    public <V extends Vertex> boolean addVertexBuffer$default$2() {
        return false;
    }

    public void addIndexBuffer(IndexBuffer buffer) {
        this.bind();
        buffer.bind();
        this.indexBuffer_$eq(new Some<IndexBuffer>(buffer));
    }

    public void bind() {
        if (this.isMacOS()) {
            APPLEVertexArrayObject.glBindVertexArrayAPPLE(this.array());
        } else {
            ARBVertexArrayObject.glBindVertexArray(this.array());
        }
        this.indexBuffer().foreach((Function1<IndexBuffer, Object> & Serializable)x$1 -> {
            x$1.bind();
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void freeResource() {
        Resource.freeResource$(this);
        if (this.isMacOS()) {
            APPLEVertexArrayObject.glDeleteVertexArraysAPPLE(this.array());
            return;
        }
        ARBVertexArrayObject.glDeleteVertexArrays(this.array());
    }

    public static final /* synthetic */ void $anonfun$addVertexBuffer$1(VertexArray $this, VertexBuffer buffer$1, boolean instanced$1, Attribute attr) {
        int location = $this.shader.getAttributeLocation(attr.name());
        buffer$1.bind();
        GL20.glEnableVertexAttribArray(location);
        GL20.glVertexAttribPointer(location, attr.size(), attr.ty(), attr.normalized(), attr.stride(), attr.pointer());
        if (instanced$1) {
            ARBInstancedArrays.glVertexAttribDivisorARB(location, 1);
            return;
        }
    }

    public VertexArray(ShaderProgram shader) {
        this.shader = shader;
        Logging.$init$(this);
        Resource.$init$(this);
        this.isMacOS = GLContext.getCapabilities().GL_APPLE_vertex_array_object;
        this.indexBuffer = None$.MODULE$;
        this.array = this.isMacOS() ? APPLEVertexArrayObject.glGenVertexArraysAPPLE() : ARBVertexArrayObject.glGenVertexArrays();
        Statics.releaseFence();
    }
}

