/*
 * Decompiled with CFR 0.152.
 */
package ocelot.desktop.inventory;

import java.io.Serializable;
import ocelot.desktop.graphics.IconSource;
import ocelot.desktop.graphics.IconSource$Items$;
import ocelot.desktop.inventory.Item;
import ocelot.desktop.inventory.ItemFactory;
import ocelot.desktop.inventory.ItemRecoverer;
import ocelot.desktop.inventory.Items;
import ocelot.desktop.inventory.item.ApuItem;
import ocelot.desktop.inventory.item.ComponentBusItem;
import ocelot.desktop.inventory.item.CpuItem;
import ocelot.desktop.inventory.item.DataCardItem$Tier1$Factory$;
import ocelot.desktop.inventory.item.DataCardItem$Tier2$Factory$;
import ocelot.desktop.inventory.item.DataCardItem$Tier3$Factory$;
import ocelot.desktop.inventory.item.DiskDriveMountableItem$Factory$;
import ocelot.desktop.inventory.item.EepromItem;
import ocelot.desktop.inventory.item.EepromItem$Factory$Empty$;
import ocelot.desktop.inventory.item.FloppyItem;
import ocelot.desktop.inventory.item.FloppyItem$Factory$Empty$;
import ocelot.desktop.inventory.item.GraphicsCardItem;
import ocelot.desktop.inventory.item.HddItem;
import ocelot.desktop.inventory.item.InternetCardItem$Factory$;
import ocelot.desktop.inventory.item.LinkedCardItem$Factory$;
import ocelot.desktop.inventory.item.MagicalMemoryItem;
import ocelot.desktop.inventory.item.MemoryItem;
import ocelot.desktop.inventory.item.NetworkCardItem$Factory$;
import ocelot.desktop.inventory.item.OcelotCardItem$Factory$;
import ocelot.desktop.inventory.item.RedstoneCardItem$Tier1$Factory$;
import ocelot.desktop.inventory.item.RedstoneCardItem$Tier2$Factory$;
import ocelot.desktop.inventory.item.SelfDestructingCardItem$Factory$;
import ocelot.desktop.inventory.item.ServerItem;
import ocelot.desktop.inventory.item.SoundCardItem$Factory$;
import ocelot.desktop.inventory.item.TapeItem;
import ocelot.desktop.inventory.item.WirelessNetworkCardItem$Tier1$Factory$;
import ocelot.desktop.inventory.item.WirelessNetworkCardItem$Tier2$Factory$;
import ocelot.desktop.util.Logging;
import ocelot.desktop.util.ReflectionUtils$;
import org.apache.logging.log4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import totoro.ocelot.brain.entity.tape.Tape$;
import totoro.ocelot.brain.entity.tape.Tape$Kind$;
import totoro.ocelot.brain.loot.Loot;
import totoro.ocelot.brain.loot.Loot$;
import totoro.ocelot.brain.util.ExtendedTier;
import totoro.ocelot.brain.util.ExtendedTier$;
import totoro.ocelot.brain.util.Tier;
import totoro.ocelot.brain.util.Tier$;

public final class Items$
implements Logging {
    public static final Items$ MODULE$ = new Items$();
    private static final ArrayBuffer<Items.ItemGroup> _groups;
    private static final Map<Class<?>, ItemRecoverer<?, ?>> _recoverers;
    private static Logger logger;

    static {
        Logging.$init$(MODULE$);
        _groups = ArrayBuffer$.MODULE$.empty();
        _recoverers = (Map)Map$.MODULE$.empty();
        MODULE$.logger().debug("Initialize item serialization...");
        MODULE$.registerTiered("CPU", Tier$.MODULE$.One().to(Tier$.MODULE$.Three()), (Function1<Tier.TierVal, ItemFactory>)(Function1<Tier.TierVal, CpuItem.Factory> & Serializable)x$1 -> new CpuItem.Factory((Tier.TierVal)x$1));
        MODULE$.registerTiered("APU", Tier$.MODULE$.Two().to(Tier$.MODULE$.Creative()), (Function1<Tier.TierVal, ItemFactory>)(Function1<Tier.TierVal, ApuItem.Factory> & Serializable)tier -> new ApuItem.Factory(tier.saturatingSub(1)));
        MODULE$.registerArbitrary("Memory", IconSource$Items$.MODULE$.Memory().apply(ExtendedTier$.MODULE$.ThreeHalf()), ExtendedTier$.MODULE$.One().to(ExtendedTier$.MODULE$.Creative()).iterator().map((Function1<ExtendedTier.ExtendedTierVal, ItemFactory> & Serializable)x0$1 -> {
            ExtendedTier.ExtendedTierVal extendedTierVal = x0$1;
            ExtendedTier.ExtendedTierVal extendedTierVal2 = ExtendedTier$.MODULE$.Creative();
            ExtendedTier.ExtendedTierVal extendedTierVal3 = extendedTierVal;
            if (!(extendedTierVal2 != null ? !((Object)extendedTierVal2).equals(extendedTierVal3) : extendedTierVal3 != null)) {
                return new MagicalMemoryItem.Factory();
            }
            return new MemoryItem.Factory(extendedTierVal);
        }).map((Function1<ItemFactory, Tuple2> & Serializable)factory -> new Tuple2<String, ItemFactory>(factory.name(), (ItemFactory)factory)));
        MODULE$.registerTiered("HDD", Tier$.MODULE$.One().to(Tier$.MODULE$.Three()), (Function1<Tier.TierVal, ItemFactory>)(Function1<Tier.TierVal, HddItem.Factory> & Serializable)x$2 -> new HddItem.Factory(true, (Tier.TierVal)x$2));
        MODULE$.registerArbitrary("Floppy", FloppyItem$Factory$Empty$.MODULE$.icon(), Loot$.MODULE$.Floppies().iterator().map((Function1<Loot.FloppyFactory, FloppyItem.Factory.Loot> & Serializable)x$3 -> new FloppyItem.Factory.Loot((Loot.FloppyFactory)x$3)).map((Function1<FloppyItem.Factory.Loot, Tuple2> & Serializable)factory -> new Tuple2<String, FloppyItem.Factory.Loot>(factory.name(), (FloppyItem.Factory.Loot)factory)).$plus$plus((Function0<Some> & Serializable)() -> new Some<Tuple2<String, FloppyItem$Factory$Empty$>>(new Tuple2<String, FloppyItem$Factory$Empty$>("Empty", FloppyItem$Factory$Empty$.MODULE$))));
        MODULE$.registerArbitrary("EEPROM", EepromItem$Factory$Empty$.MODULE$.icon(), Loot$.MODULE$.Eeproms().iterator().map((Function1<Loot.EEPROMFactory, EepromItem.Factory.Loot> & Serializable)x$4 -> new EepromItem.Factory.Loot((Loot.EEPROMFactory)x$4)).map((Function1<EepromItem.Factory.Loot, Tuple2> & Serializable)factory -> new Tuple2<String, EepromItem.Factory.Loot>(factory.name(), (EepromItem.Factory.Loot)factory)).$plus$plus((Function0<Some> & Serializable)() -> new Some<Tuple2<String, EepromItem$Factory$Empty$>>(new Tuple2<String, EepromItem$Factory$Empty$>("Empty", EepromItem$Factory$Empty$.MODULE$))));
        MODULE$.registerTiered("Graphics Card", Tier$.MODULE$.One().to(Tier$.MODULE$.Three()), (Function1<Tier.TierVal, ItemFactory>)(Function1<Tier.TierVal, GraphicsCardItem.Factory> & Serializable)x$5 -> new GraphicsCardItem.Factory((Tier.TierVal)x$5));
        MODULE$.registerSingleton(NetworkCardItem$Factory$.MODULE$);
        MODULE$.registerTiered("Wireless Net. Card", Tier$.MODULE$.One().to(Tier$.MODULE$.Two()), (Function1<Tier.TierVal, ItemFactory> & Serializable)x0$2 -> {
            Tier.TierVal tierVal = x0$2;
            Tier.TierVal tierVal2 = Tier$.MODULE$.One();
            Tier.TierVal tierVal3 = tierVal;
            if (!(tierVal2 != null ? !((Object)tierVal2).equals(tierVal3) : tierVal3 != null)) {
                return WirelessNetworkCardItem$Tier1$Factory$.MODULE$;
            }
            Tier.TierVal tierVal4 = Tier$.MODULE$.Two();
            Tier.TierVal tierVal5 = tierVal;
            if (!(tierVal4 != null ? !((Object)tierVal4).equals(tierVal5) : tierVal5 != null)) {
                return WirelessNetworkCardItem$Tier2$Factory$.MODULE$;
            }
            throw new MatchError(tierVal);
        });
        MODULE$.registerSingleton(LinkedCardItem$Factory$.MODULE$);
        MODULE$.registerSingleton(InternetCardItem$Factory$.MODULE$);
        MODULE$.registerTiered("Redstone Card", Tier$.MODULE$.One().to(Tier$.MODULE$.Two()), (Function1<Tier.TierVal, ItemFactory> & Serializable)x0$3 -> {
            Tier.TierVal tierVal = x0$3;
            Tier.TierVal tierVal2 = Tier$.MODULE$.One();
            Tier.TierVal tierVal3 = tierVal;
            if (!(tierVal2 != null ? !((Object)tierVal2).equals(tierVal3) : tierVal3 != null)) {
                return RedstoneCardItem$Tier1$Factory$.MODULE$;
            }
            Tier.TierVal tierVal4 = Tier$.MODULE$.Two();
            Tier.TierVal tierVal5 = tierVal;
            if (!(tierVal4 != null ? !((Object)tierVal4).equals(tierVal5) : tierVal5 != null)) {
                return RedstoneCardItem$Tier2$Factory$.MODULE$;
            }
            throw new MatchError(tierVal);
        });
        MODULE$.registerTiered("Data Card", Tier$.MODULE$.One().to(Tier$.MODULE$.Three()), (Function1<Tier.TierVal, ItemFactory> & Serializable)x0$4 -> {
            Tier.TierVal tierVal = x0$4;
            Tier.TierVal tierVal2 = Tier$.MODULE$.One();
            Tier.TierVal tierVal3 = tierVal;
            if (!(tierVal2 != null ? !((Object)tierVal2).equals(tierVal3) : tierVal3 != null)) {
                return DataCardItem$Tier1$Factory$.MODULE$;
            }
            Tier.TierVal tierVal4 = Tier$.MODULE$.Two();
            Tier.TierVal tierVal5 = tierVal;
            if (!(tierVal4 != null ? !((Object)tierVal4).equals(tierVal5) : tierVal5 != null)) {
                return DataCardItem$Tier2$Factory$.MODULE$;
            }
            Tier.TierVal tierVal6 = Tier$.MODULE$.Three();
            Tier.TierVal tierVal7 = tierVal;
            if (!(tierVal6 != null ? !((Object)tierVal6).equals(tierVal7) : tierVal7 != null)) {
                return DataCardItem$Tier3$Factory$.MODULE$;
            }
            throw new MatchError(tierVal);
        });
        MODULE$.registerSingleton(SoundCardItem$Factory$.MODULE$);
        MODULE$.registerSingleton(SelfDestructingCardItem$Factory$.MODULE$);
        MODULE$.registerSingleton(OcelotCardItem$Factory$.MODULE$);
        MODULE$.registerTiered("Server", Tier$.MODULE$.One().to(Tier$.MODULE$.Creative()), (Function1<Tier.TierVal, ItemFactory>)(Function1<Tier.TierVal, ServerItem.Factory> & Serializable)x$6 -> new ServerItem.Factory((Tier.TierVal)x$6));
        MODULE$.registerTiered("Component bus", Tier$.MODULE$.One().to(Tier$.MODULE$.Creative()), (Function1<Tier.TierVal, ItemFactory>)(Function1<Tier.TierVal, ComponentBusItem.Factory> & Serializable)x$7 -> new ComponentBusItem.Factory((Tier.TierVal)x$7));
        MODULE$.registerSingleton(DiskDriveMountableItem$Factory$.MODULE$);
        MODULE$.registerArbitrary("Tape", new TapeItem.Factory(Tape$Kind$.MODULE$.Iron()).icon(), Tape$Kind$.MODULE$.values().iterator().map((Function1<Enumeration.Value, TapeItem.Factory> & Serializable)x$8 -> new TapeItem.Factory((Enumeration.Value)x$8)).map((Function1<TapeItem.Factory, Tuple2> & Serializable)factory -> new Tuple2<String, TapeItem.Factory>(StringOps$.MODULE$.format$extension("%s (%.0f min)", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{factory.name(), BoxesRunTime.boxToFloat(Tape$.MODULE$.lengthMinutes(factory.kind()))})), (TapeItem.Factory)factory)));
        MODULE$.logger().debug("Item serialization initialization finished.");
    }

    @Override
    public Logger logger() {
        return logger;
    }

    @Override
    public void ocelot$desktop$util$Logging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    private ArrayBuffer<Items.ItemGroup> _groups() {
        return _groups;
    }

    private Map<Class<?>, ItemRecoverer<?, ?>> _recoverers() {
        return _recoverers;
    }

    public void init() {
    }

    private void registerRecoverer(ItemRecoverer<?, ?> recoverer) {
        if (!this._recoverers().contains(recoverer.sourceClass())) {
            this._recoverers().update(recoverer.sourceClass(), recoverer);
            this.logger().debug(new StringBuilder(27).append("Registered a recoverer for ").append(recoverer.sourceClass().getName()).toString());
            return;
        }
    }

    private void registerItemFactoryRecoverers(ItemFactory factory) {
        factory.recoverers().foreach((Function1<ItemRecoverer, Object> & Serializable)recoverer -> {
            Items$.MODULE$.registerRecoverer(recoverer);
            return BoxedUnit.UNIT;
        });
    }

    public void registerSingleton(ItemFactory factory) {
        this._groups().$plus$eq(new Items.SingletonItemGroup(factory.name(), factory));
        this.registerItemFactoryRecoverers(factory);
    }

    public void registerTiered(String name, IterableOnce<Tier.TierVal> tiers, Function1<Tier.TierVal, ItemFactory> factory) {
        Items.TieredItemGroup group = new Items.TieredItemGroup(name, tiers.iterator().map((Function1<Tier.TierVal, Tuple2> & Serializable)tier -> new Tuple2((Tier.TierVal)tier, factory.apply((Tier.TierVal)tier))).toSeq());
        this._groups().$plus$eq(group);
        group.factories().withFilter((Function1<Tuple2, Object> & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(Items$.$anonfun$registerTiered$2(check$ifrefutable$1))).foreach((Function1<Tuple2, Object> & Serializable)x$9 -> {
            Items$.$anonfun$registerTiered$3(x$9);
            return BoxedUnit.UNIT;
        });
    }

    public void registerExtendedTiered(String name, IterableOnce<ExtendedTier.ExtendedTierVal> tiers, Function1<ExtendedTier.ExtendedTierVal, ItemFactory> factory) {
        Items.ExtendedTieredItemGroup group = new Items.ExtendedTieredItemGroup(name, tiers.iterator().map((Function1<ExtendedTier.ExtendedTierVal, Tuple2> & Serializable)tier -> new Tuple2((ExtendedTier.ExtendedTierVal)tier, factory.apply((ExtendedTier.ExtendedTierVal)tier))).toSeq());
        this._groups().$plus$eq(group);
        group.factories().withFilter((Function1<Tuple2, Object> & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean(Items$.$anonfun$registerExtendedTiered$2(check$ifrefutable$2))).foreach((Function1<Tuple2, Object> & Serializable)x$10 -> {
            Items$.$anonfun$registerExtendedTiered$3(x$10);
            return BoxedUnit.UNIT;
        });
    }

    public void registerArbitrary(String name, IconSource icon, IterableOnce<Tuple2<String, ItemFactory>> factories) {
        Items.ArbitraryItemGroup group = new Items.ArbitraryItemGroup(name, icon, factories.iterator().toSeq());
        this._groups().$plus$eq(group);
        group.factories().withFilter((Function1<Tuple2, Object> & Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean(Items$.$anonfun$registerArbitrary$1(check$ifrefutable$3))).foreach((Function1<Tuple2, Object> & Serializable)x$11 -> {
            Items$.$anonfun$registerArbitrary$2(x$11);
            return BoxedUnit.UNIT;
        });
    }

    public Iterable<Items.ItemGroup> groups() {
        return this._groups();
    }

    public <A> Option<Item> recover(A source) {
        return ReflectionUtils$.MODULE$.linearizationOrder(source.getClass()).flatMap((Function1<Class, Option> & Serializable)key -> MODULE$._recoverers().get((Class<?>)key)).map((Function1<ItemRecoverer, Item> & Serializable)x$12 -> x$12.recover(source)).nextOption();
    }

    public static final /* synthetic */ boolean $anonfun$registerTiered$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$registerTiered$3(Tuple2 x$9) {
        Tuple2 tuple2 = x$9;
        if (tuple2 != null) {
            ItemFactory factory = (ItemFactory)tuple2._2();
            MODULE$.registerItemFactoryRecoverers(factory);
            return;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$registerExtendedTiered$2(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$registerExtendedTiered$3(Tuple2 x$10) {
        Tuple2 tuple2 = x$10;
        if (tuple2 != null) {
            ItemFactory factory = (ItemFactory)tuple2._2();
            MODULE$.registerItemFactoryRecoverers(factory);
            return;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$registerArbitrary$1(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$registerArbitrary$2(Tuple2 x$11) {
        Tuple2 tuple2 = x$11;
        if (tuple2 != null) {
            ItemFactory factory = (ItemFactory)tuple2._2();
            MODULE$.registerItemFactoryRecoverers(factory);
            return;
        }
        throw new MatchError(tuple2);
    }

    private Items$() {
    }
}

