/*
 * Decompiled with CFR 0.152.
 */
package ocelot.desktop.ui;

import buildinfo.BuildInfo$;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.file.Paths;
import javax.imageio.ImageIO;
import ocelot.desktop.OcelotDesktop$;
import ocelot.desktop.Settings;
import ocelot.desktop.Settings$;
import ocelot.desktop.audio.Audio$;
import ocelot.desktop.audio.SoundBuffers$;
import ocelot.desktop.audio.SoundSource$;
import ocelot.desktop.geometry.Rect2D;
import ocelot.desktop.geometry.Size2D;
import ocelot.desktop.geometry.Size2D$;
import ocelot.desktop.geometry.Vector2D;
import ocelot.desktop.graphics.Font$;
import ocelot.desktop.graphics.Graphics;
import ocelot.desktop.graphics.Texture;
import ocelot.desktop.ui.UiHandler;
import ocelot.desktop.ui.UiHandler$DispatchOrder$;
import ocelot.desktop.ui.event.Capturing;
import ocelot.desktop.ui.event.CapturingEvent;
import ocelot.desktop.ui.event.Dispatchable;
import ocelot.desktop.ui.event.HoverEvent;
import ocelot.desktop.ui.event.HoverEvent$State$;
import ocelot.desktop.ui.event.KeyEvent;
import ocelot.desktop.ui.event.MouseEvent;
import ocelot.desktop.ui.event.MouseEvent$State$;
import ocelot.desktop.ui.event.handlers.HoverHandler;
import ocelot.desktop.ui.event.sources.BrainEvents$;
import ocelot.desktop.ui.event.sources.KeyEvents$;
import ocelot.desktop.ui.event.sources.MouseEvents$;
import ocelot.desktop.ui.event.sources.ScrollEvents$;
import ocelot.desktop.ui.widget.RootWidget;
import ocelot.desktop.ui.widget.Widget;
import ocelot.desktop.util.FPSCalculator;
import ocelot.desktop.util.Keybind$;
import ocelot.desktop.util.Logging;
import ocelot.desktop.util.OcelotPaths$;
import ocelot.desktop.util.Profiler$;
import ocelot.desktop.util.Spritesheet$;
import ocelot.desktop.util.TaskQueue;
import ocelot.desktop.util.Ticker;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.Logger;
import org.lwjgl.BufferUtils;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.ContextAttribs;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.PixelFormat;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.AbstractIterable;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnce$;
import scala.collection.IterableOnceExtensionMethods$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.mutable.AbstractBuffer;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Stack;
import scala.collection.mutable.Stack$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichFloat$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.util.Try;
import scala.util.Try$;
import totoro.ocelot.brain.event.Event;

public final class UiHandler$
implements Logging {
    public static final UiHandler$ MODULE$ = new UiHandler$();
    private static RootWidget root;
    private static Graphics graphics;
    private static boolean _terminating;
    private static final ArrayBuffer<Widget> ocelot$desktop$ui$UiHandler$$hierarchy;
    private static boolean shouldUpdateHierarchy;
    private static final FPSCalculator fpsCalculator;
    private static final Ticker ticker;
    private static float scalingFactor;
    private static final TaskQueue UiThreadTasks;
    private static final Clipboard _clipboard;
    private static Option<String> _windowTitleSuffix;
    private static boolean exitRequested;
    private static Logger logger;

    static {
        Logging.$init$(MODULE$);
        _terminating = false;
        ocelot$desktop$ui$UiHandler$$hierarchy = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Widget[]{MODULE$.root()}));
        shouldUpdateHierarchy = true;
        fpsCalculator = new FPSCalculator();
        ticker = new Ticker();
        scalingFactor = 1.0f;
        MODULE$.ticker().tickInterval_$eq(new package.DurationInt(package$.MODULE$.DurationInt(1)).second().$div(144L));
        UiThreadTasks = new TaskQueue();
        _clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        _windowTitleSuffix = None$.MODULE$;
        exitRequested = false;
    }

    @Override
    public Logger logger() {
        return logger;
    }

    @Override
    public void ocelot$desktop$util$Logging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    public RootWidget root() {
        return root;
    }

    public void root_$eq(RootWidget x$1) {
        root = x$1;
    }

    public Graphics graphics() {
        return graphics;
    }

    public void graphics_$eq(Graphics x$1) {
        graphics = x$1;
    }

    private boolean _terminating() {
        return _terminating;
    }

    private void _terminating_$eq(boolean x$1) {
        _terminating = x$1;
    }

    public boolean terminating() {
        return this._terminating();
    }

    public ArrayBuffer<Widget> ocelot$desktop$ui$UiHandler$$hierarchy() {
        return ocelot$desktop$ui$UiHandler$$hierarchy;
    }

    private boolean shouldUpdateHierarchy() {
        return shouldUpdateHierarchy;
    }

    private void shouldUpdateHierarchy_$eq(boolean x$1) {
        shouldUpdateHierarchy = x$1;
    }

    private FPSCalculator fpsCalculator() {
        return fpsCalculator;
    }

    private Ticker ticker() {
        return ticker;
    }

    public float scalingFactor() {
        return scalingFactor;
    }

    public void scalingFactor_$eq(float x$1) {
        scalingFactor = x$1;
    }

    public TaskQueue UiThreadTasks() {
        return UiThreadTasks;
    }

    public Widget[] getHierarchy() {
        return (Widget[])this.ocelot$desktop$ui$UiHandler$$hierarchy().toArray(ClassTag$.MODULE$.apply(Widget.class));
    }

    public void updateHierarchy() {
        this.shouldUpdateHierarchy_$eq(true);
    }

    private void _updateHierarchy() {
        Stack stack = (Stack)Stack$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Widget[]{this.root()}));
        this.ocelot$desktop$ui$UiHandler$$hierarchy().clear();
        while (stack.nonEmpty()) {
            Widget widget = (Widget)stack.pop();
            this.ocelot$desktop$ui$UiHandler$$hierarchy().$plus$eq(widget);
            widget.hierarchy().reverseIterator().foreach((Function1<Widget, Stack> & Serializable)child -> stack.push(child));
        }
        this.shouldUpdateHierarchy_$eq(false);
    }

    public float fps() {
        return this.fpsCalculator().fps();
    }

    public float dt() {
        return this.fpsCalculator().dt();
    }

    public Vector2D mousePosition() {
        return new Vector2D(Mouse.getX(), Display.getHeight() - Mouse.getY()).$div(this.scalingFactor());
    }

    private Clipboard _clipboard() {
        return _clipboard;
    }

    public String clipboard() {
        String string;
        try {
            string = this._clipboard().getData(DataFlavor.stringFlavor).toString();
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            this.logger().debug("Trying to paste non-Unicode content from clipboard! Replaced with an empty string.");
            string = "";
        }
        return string;
    }

    public void clipboard_$eq(String value) {
        StringSelection data = new StringSelection(value);
        this._clipboard().setContents(data, data);
    }

    public boolean fullScreen() {
        return Display.isFullscreen();
    }

    public void fullScreen_$eq(boolean value) {
        if (value) {
            Display.setDisplayModeAndFullscreen(Display.getDesktopDisplayMode());
        } else {
            Settings.Int2D settingsSize = Settings$.MODULE$.get().windowSize();
            Size2D unscaledSize = this.sanitizeWindowSize(settingsSize.isSet() ? Size2D$.MODULE$.apply(settingsSize.x(), settingsSize.y()) : Size2D$.MODULE$.apply(800, 600));
            if (this.root() != null) {
                this.root().size_$eq(unscaledSize.$div(this.scalingFactor()));
            }
            Display.setDisplayMode(new DisplayMode((int)unscaledSize.width(), (int)unscaledSize.height()));
            if (Settings$.MODULE$.get().windowPosition().isSet()) {
                if (Settings$.MODULE$.get().windowValidatePosition()) {
                    DisplayMode desktop = Display.getDesktopDisplayMode();
                    if (Settings$.MODULE$.get().windowPosition().x() < -Settings$.MODULE$.get().windowSize().x()) {
                        Settings$.MODULE$.get().windowPosition().x_$eq(0);
                    }
                    if (Settings$.MODULE$.get().windowPosition().x() > desktop.getWidth()) {
                        Settings$.MODULE$.get().windowPosition().x_$eq(desktop.getWidth() - Settings$.MODULE$.get().windowSize().x());
                    }
                    if (Settings$.MODULE$.get().windowPosition().y() < -Settings$.MODULE$.get().windowSize().y()) {
                        Settings$.MODULE$.get().windowPosition().y_$eq(0);
                    }
                    if (Settings$.MODULE$.get().windowPosition().y() > desktop.getHeight()) {
                        Settings$.MODULE$.get().windowPosition().y_$eq(desktop.getHeight() - Settings$.MODULE$.get().windowSize().y());
                    }
                }
                Display.setLocation(Settings$.MODULE$.get().windowPosition().x(), Settings$.MODULE$.get().windowPosition().y());
            }
            Display.setResizable(false);
            Display.setResizable(true);
        }
        Settings$.MODULE$.get().windowFullscreen_$eq(value);
    }

    private String formatRect(Rect2D rect) {
        Rect2D rect2D = rect;
        if (rect2D == null) {
            throw new MatchError(rect2D);
        }
        float x = rect2D.x();
        float y = rect2D.y();
        float w = rect2D.w();
        float h2 = rect2D.h();
        Tuple4<Float, Float, Float, Float> tuple4 = new Tuple4<Float, Float, Float, Float>(BoxesRunTime.boxToFloat(x), BoxesRunTime.boxToFloat(y), BoxesRunTime.boxToFloat(w), BoxesRunTime.boxToFloat(h2));
        float x2 = BoxesRunTime.unboxToFloat(tuple4._1());
        float y2 = BoxesRunTime.unboxToFloat(tuple4._2());
        float w2 = BoxesRunTime.unboxToFloat(tuple4._3());
        float h3 = BoxesRunTime.unboxToFloat(tuple4._4());
        return StringOps$.MODULE$.format$extension("%.0f\u00d7%.0f%+.0f%+.0f", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToFloat(w2), BoxesRunTime.boxToFloat(h3), BoxesRunTime.boxToFloat(x2), BoxesRunTime.boxToFloat(y2)}));
    }

    private Rect2D windowGeometry() {
        return new Rect2D(Display.getX(), Display.getY(), Display.getWidth(), Display.getHeight());
    }

    private Size2D sanitizeWindowSize(Size2D size) {
        return new Size2D(size.width() < (float)10 ? 800.0f : size.width(), size.height() < (float)10 ? 600.0f : size.height());
    }

    private Rect2D sanitizeWindowGeometry(Rect2D currentGeometry) {
        Rect2D rect2D = currentGeometry;
        if (rect2D == null) {
            throw new MatchError(rect2D);
        }
        float x = rect2D.x();
        float y = rect2D.y();
        float w = rect2D.w();
        float h2 = rect2D.h();
        Tuple4<Float, Float, Float, Float> tuple4 = new Tuple4<Float, Float, Float, Float>(BoxesRunTime.boxToFloat(x), BoxesRunTime.boxToFloat(y), BoxesRunTime.boxToFloat(w), BoxesRunTime.boxToFloat(h2));
        float x2 = BoxesRunTime.unboxToFloat(tuple4._1());
        float y2 = BoxesRunTime.unboxToFloat(tuple4._2());
        float w2 = BoxesRunTime.unboxToFloat(tuple4._3());
        float h3 = BoxesRunTime.unboxToFloat(tuple4._4());
        Size2D newSize = this.sanitizeWindowSize(new Size2D(w2, h3));
        return new Rect2D(RichFloat$.MODULE$.max$extension(Predef$.MODULE$.floatWrapper(x2), 0.0f), RichFloat$.MODULE$.max$extension(Predef$.MODULE$.floatWrapper(y2), 0.0f), newSize.width(), newSize.height());
    }

    private void fixInsaneInitialWindowGeometry() {
        Rect2D geometry;
        Rect2D currentGeometry = this.windowGeometry();
        Rect2D rect2D = geometry = this.sanitizeWindowGeometry(currentGeometry);
        Rect2D rect2D2 = currentGeometry;
        if (rect2D == null ? rect2D2 != null : !((Object)rect2D).equals(rect2D2)) {
            this.logger().warn(new StringBuilder(58).append("Window geometry sanity check failed: ").append(this.formatRect(currentGeometry)).append(" is officially insane").toString());
            this.logger().warn(new StringBuilder(13).append("Resetting to ").append(this.formatRect(geometry)).toString());
            Display.setDisplayMode(new DisplayMode((int)geometry.w(), (int)geometry.h()));
            Display.setLocation((int)geometry.x(), (int)geometry.y());
            return;
        }
    }

    public void init() {
        this.scalingFactor_$eq(Settings$.MODULE$.get().scaleFactor());
        this.fullScreen_$eq(Settings$.MODULE$.get().windowFullscreen());
        Display.setTitle(this.windowTitleBase());
        this.loadIcons();
        if (!Settings$.MODULE$.get().disableVsync()) {
            this.logger().info("VSync enabled");
            Display.setVSyncEnabled(true);
        } else {
            this.logger().info("VSync disabled (via config)");
        }
        ContextAttribs attrs = new ContextAttribs(3, 2, 1, 2);
        PixelFormat pf = new PixelFormat().withDepthBits(24).withStencilBits(8).withAlphaBits(8).withSRGB(true);
        this.logger().info(new StringBuilder(28).append("Creating an OpenGL context: ").append(attrs).toString());
        Display.create(pf, attrs);
        if (Settings$.MODULE$.get().windowValidatePosition()) {
            this.fixInsaneInitialWindowGeometry();
        }
        KeyEvents$.MODULE$.init();
        MouseEvents$.MODULE$.init();
        this.logger().info(new StringBuilder(16).append("Created window: ").append(this.formatRect(this.windowGeometry())).toString());
        this.logger().info(new StringBuilder(15).append("OpenGL vendor: ").append(GL11.glGetString(7936)).toString());
        this.logger().info(new StringBuilder(17).append("OpenGL renderer: ").append(GL11.glGetString(7937)).toString());
        this.logger().info(new StringBuilder(16).append("OpenGL version: ").append(GL11.glGetString(7938)).toString());
        Spritesheet$.MODULE$.load();
        this.graphics_$eq(new Graphics(Display.getWidth(), Display.getHeight(), this.scalingFactor()));
        if (Settings$.MODULE$.get().audioDisable()) {
            this.logger().warn("Sound disabled (via config)");
            return;
        }
        Audio$.MODULE$.init();
    }

    public void setRoot(RootWidget widget) {
        this.root_$eq(widget);
        this.root().relayout();
    }

    public void loadLibraries() {
        String[] stringArray;
        boolean isArm64;
        String librariesPath = ((Object)OcelotPaths$.MODULE$.libraries()).toString();
        String arch = System.getProperty("os.arch");
        boolean is64bit = arch.startsWith("amd64");
        boolean bl = isArm64 = arch.startsWith("aarch64") || arch.startsWith("arm64");
        if (SystemUtils.IS_OS_WINDOWS) {
            stringArray = is64bit ? (String[])((Object[])new String[]{"jinput-dx8_64.dll", "jinput-raw_64.dll", "jinput-wintab.dll", "lwjgl64.dll", "OpenAL64.dll"}) : (String[])((Object[])new String[]{"jinput-dx8.dll", "jinput-raw.dll", "jinput-wintab.dll", "lwjgl.dll", "OpenAL32.dll"});
        } else if (SystemUtils.IS_OS_MAC_OSX) {
            stringArray = isArm64 ? (String[])((Object[])new String[]{"liblwjgl-arm64.dylib"}) : (String[])((Object[])new String[]{"liblwjgl.dylib"});
        } else if (SystemUtils.IS_OS_LINUX) {
            stringArray = is64bit ? (String[])((Object[])new String[]{"libjinput-linux64.so", "liblwjgl64.so", "libopenal64.so"}) : (String[])((Object[])new String[]{"libjinput-linux.so", "liblwjgl.so", "libopenal.so"});
        } else {
            throw new Exception("Unsupported OS");
        }
        String[] libs = stringArray;
        this.logger().debug(new StringBuilder(31).append("Unpacking native libraries to: ").append(librariesPath).toString());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(libs), (Function1<String, Object> & Serializable)lib -> {
            UiHandler$.$anonfun$loadLibraries$1(librariesPath, lib);
            return BoxedUnit.UNIT;
        });
        System.setProperty("org.lwjgl.librarypath", librariesPath);
        if (Settings$.MODULE$.get().debugLwjgl()) {
            this.logger().info("Enabling LWJGL debug mode");
            System.setProperty("org.lwjgl.util.Debug", Boolean.toString(true));
            return;
        }
    }

    private void loadIcons() {
        int[] sizes = new int[]{256, 128, 64, 32, 16};
        ByteBuffer[] list2 = new ByteBuffer[sizes.length];
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps(ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.intArrayOps(sizes))), (Function1<Tuple2, Object> & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(UiHandler$.$anonfun$loadIcons$1(check$ifrefutable$1))).foreach((Function1<Tuple2, Object> & Serializable)x$5 -> {
            UiHandler$.$anonfun$loadIcons$2(list2, x$5);
            return BoxedUnit.UNIT;
        });
        Display.setIcon(list2);
        this.logger().info(new StringBuilder(29).append("Loaded window icons of sizes ").append(Predef$.MODULE$.wrapIntArray(sizes).mkString(", ")).toString());
    }

    private String windowTitleBase() {
        return new StringBuilder(18).append("Ocelot Desktop ").append(BuildInfo$.MODULE$.version()).append(" (").append(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(BuildInfo$.MODULE$.commit()), 7)).append(")").toString();
    }

    private Option<String> _windowTitleSuffix() {
        return _windowTitleSuffix;
    }

    private void _windowTitleSuffix_$eq(Option<String> x$1) {
        _windowTitleSuffix = x$1;
    }

    public Option<String> windowTitleSuffix() {
        return this._windowTitleSuffix();
    }

    public void windowTitleSuffix_$eq(Option<String> value) {
        Option<String> option = value;
        Option<String> option2 = this._windowTitleSuffix();
        if (!(option != null ? !option.equals(option2) : option2 != null)) {
            return;
        }
        this._windowTitleSuffix_$eq(value);
        this.UiThreadTasks().add(() -> MODULE$.updateWindowTitle());
    }

    private void updateWindowTitle() {
        Display.setTitle(this._windowTitleSuffix().isEmpty() ? this.windowTitleBase() : new StringBuilder(3).append(this.windowTitleBase()).append(" - ").append((Object)this._windowTitleSuffix().get()).toString());
    }

    private boolean exitRequested() {
        return exitRequested;
    }

    private void exitRequested_$eq(boolean x$1) {
        exitRequested = x$1;
    }

    public void exit() {
        this.exitRequested_$eq(true);
    }

    public void start() {
        while (!this.exitRequested()) {
            if (Display.isCloseRequested()) {
                OcelotDesktop$.MODULE$.exit();
            }
            OcelotDesktop$.MODULE$.withTickLockAcquired(() -> {
                MODULE$.updateWindowSizeAndPosition();
                MODULE$.UiThreadTasks().run();
                Audio$.MODULE$.update();
                KeyEvents$.MODULE$.update();
                MouseEvents$.MODULE$.update();
                OcelotDesktop$.MODULE$.updateAutosave();
                Profiler$.MODULE$.measure("000_update", () -> MODULE$.update());
                Profiler$.MODULE$.measure("001_draw", () -> MODULE$.draw());
                if (KeyEvents$.MODULE$.isReleased(Settings$.MODULE$.get().keymap().apply(Keybind$.MODULE$.Screenshot()))) {
                    SoundSource$.MODULE$.InterfaceShutter().play();
                    BufferedImage image = MODULE$.graphics().screenshot();
                    MODULE$.root().flash().bang();
                    OcelotDesktop$.MODULE$.showFileChooserDialog(1, 1, (Function1<Option<File>, Try<BoxedUnit>>)(Function1<Option, Try> & Serializable)dir -> Try$.MODULE$.apply(() -> dir.foreach((Function1<File, Object> & Serializable)dir -> {
                        UiHandler$.$anonfun$start$6(image, dir);
                        return BoxedUnit.UNIT;
                    })));
                    return;
                }
            });
            Profiler$.MODULE$.measure("002_sleep", () -> MODULE$.ticker().waitNext(MODULE$.ticker().waitNext$default$1()));
            Display.update();
            this.fpsCalculator().tick();
        }
    }

    public void terminate() {
        this._terminating_$eq(true);
        this.root().workspaceView().dispose();
        BrainEvents$.MODULE$.destroy();
        KeyEvents$.MODULE$.destroy();
        MouseEvents$.MODULE$.destroy();
        this.graphics().freeResource();
        Font$.MODULE$.freeResource();
        Audio$.MODULE$.removeAllSources();
        SoundBuffers$.MODULE$.freeResource();
        Display.destroy();
        Audio$.MODULE$.destroy();
    }

    private void dispatchEvent(Function0<IterableOnce<Widget>> iter, Dispatchable event) {
        IterableOnceExtensionMethods$.MODULE$.withFilter$extension(IterableOnce$.MODULE$.iterableOnceExtensionMethods(iter.apply()), (Function1<Widget, Object> & Serializable)widget -> BoxesRunTime.boxToBoolean(UiHandler$.$anonfun$dispatchEvent$1(event, widget))).foreach((Function1<Widget, Object> & Serializable)widget -> {
            widget.handleEvent(event);
            return BoxedUnit.UNIT;
        });
    }

    private IterableOnce<Widget> dispatchEvent$default$1() {
        return this.ocelot$desktop$ui$UiHandler$$hierarchy().reverseIterator();
    }

    private void dispatchCapturing(UiHandler.DispatchOrder dispatchOrder, CapturingEvent event) {
        this.dispatchEvent((Function0<IterableOnce<Widget>>)(Function0<Seq> & Serializable)() -> dispatchOrder.capture(), new Capturing<CapturingEvent>(event));
        this.dispatchEvent((Function0<IterableOnce<Widget>>)(Function0<Iterator> & Serializable)() -> dispatchOrder.targets().reverseIterator(), event);
    }

    private void dispatchBrainEvents() {
        Event cutoff = BrainEvents$.MODULE$.events().peekLast();
        if (cutoff == null) {
            return;
        }
        boolean cutoffReached = false;
        Object events = ArrayBuffer$.MODULE$.empty();
        while (!cutoffReached) {
            Event event2 = BrainEvents$.MODULE$.events().poll();
            cutoffReached = event2 == cutoff;
            ((AbstractBuffer)events).$plus$eq(event2);
        }
        ((AbstractIterable)events).foreach((Function1<Event, Object> & Serializable)event -> {
            UiHandler$.$anonfun$dispatchBrainEvents$1(event);
            return BoxedUnit.UNIT;
        });
    }

    private void update() {
        if (this.shouldUpdateHierarchy()) {
            this._updateHierarchy();
        }
        this.dispatchBrainEvents();
        Vector2D mousePos = this.mousePosition();
        if (mousePos.x() < 0.0f || mousePos.y() < 0.0f || mousePos.x() > this.root().width() || mousePos.y() > this.root().height()) {
            KeyEvents$.MODULE$.releaseKeys();
            MouseEvents$.MODULE$.releaseButtons();
        }
        UiHandler.DispatchOrder broadcastDispatchOrder = UiHandler$DispatchOrder$.MODULE$.broadcast();
        KeyEvents$.MODULE$.events().foreach((Function1<KeyEvent, Object> & Serializable)event -> {
            UiHandler$.MODULE$.dispatchCapturing(broadcastDispatchOrder, event);
            return BoxedUnit.UNIT;
        });
        Option scrollTarget2 = this.ocelot$desktop$ui$UiHandler$$hierarchy().reverseIterator().find((Function1<Widget, Object> & Serializable)w -> BoxesRunTime.boxToBoolean(UiHandler$.$anonfun$update$2(mousePos, w)));
        Option mouseTarget = this.ocelot$desktop$ui$UiHandler$$hierarchy().reverseIterator().find((Function1<Widget, Object> & Serializable)w -> BoxesRunTime.boxToBoolean(UiHandler$.$anonfun$update$3(mousePos, w)));
        scrollTarget2.foreach((Function1<Widget, Object> & Serializable)scrollTarget -> {
            UiHandler$.$anonfun$update$4(scrollTarget);
            return BoxedUnit.UNIT;
        });
        UiHandler.DispatchOrder mouseEventDispatchOrder = UiHandler$DispatchOrder$.MODULE$.resolve(this.ocelot$desktop$ui$UiHandler$$hierarchy().iterator().filter((Function1<Widget, Object> & Serializable)w -> BoxesRunTime.boxToBoolean(UiHandler$.$anonfun$update$6(mouseTarget, w))).toSeq());
        MouseEvents$.MODULE$.events().foreach((Function1<MouseEvent, Object> & Serializable)event -> {
            UiHandler$.$anonfun$update$7(mouseEventDispatchOrder, broadcastDispatchOrder, event);
            return BoxedUnit.UNIT;
        });
        UiHandler.DispatchOrder hoverLeaveDispatchOrder = UiHandler$DispatchOrder$.MODULE$.resolve(this.ocelot$desktop$ui$UiHandler$$hierarchy().iterator().collect(new Serializable(mouseTarget){
            private static final long serialVersionUID = 0L;
            private final Option mouseTarget$1;

            public final <A1 extends Widget, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                HoverHandler hoverHandler;
                A1 A1 = x1;
                if (A1 instanceof HoverHandler && !this.mouseTarget$1.contains(hoverHandler = (HoverHandler)((Object)A1)) && hoverHandler._mouseOver().update(BoxesRunTime.boxToBoolean(false))) {
                    return (B1)hoverHandler;
                }
                return function1.apply(x1);
            }

            public final boolean isDefinedAt(Widget x1) {
                HoverHandler hoverHandler;
                Widget widget = x1;
                return widget instanceof HoverHandler && !this.mouseTarget$1.contains(hoverHandler = (HoverHandler)((Object)widget)) && hoverHandler._mouseOver().update(BoxesRunTime.boxToBoolean(false));
            }
            {
                this.mouseTarget$1 = mouseTarget$1;
            }
        }).toSeq());
        this.dispatchCapturing(hoverLeaveDispatchOrder, new HoverEvent(HoverEvent$State$.MODULE$.Leave()));
        mouseTarget.foreach((Function1<Widget, Object> & Serializable)x0$1 -> {
            UiHandler$.$anonfun$update$8(x0$1);
            return BoxedUnit.UNIT;
        });
        this.root().update();
    }

    private void updateWindowSizeAndPosition() {
        int width = Display.getWidth();
        int height = Display.getHeight();
        if (this.graphics().resize(width, height, this.scalingFactor())) {
            this.root().size_$eq(new Size2D((float)width / this.scalingFactor(), (float)height / this.scalingFactor()));
        }
        if (!this.fullScreen()) {
            Settings$.MODULE$.get().windowSize().set(width, height);
            Settings$.MODULE$.get().windowPosition().set(Display.getX(), Display.getY());
            return;
        }
    }

    private void draw() {
        this.graphics().begin();
        this.graphics().clear();
        this.root().draw(this.graphics());
        Graphics qual$1 = this.graphics();
        Texture x$1 = qual$1.flush$default$1();
        boolean x$2 = qual$1.flush$default$2();
        qual$1.flush(x$1, x$2);
        this.graphics().update();
    }

    public static final /* synthetic */ void $anonfun$loadLibraries$1(String librariesPath$1, String lib) {
        String destinationFilename = SystemUtils.IS_OS_MAC_OSX ? "liblwjgl.dylib" : lib;
        File dest = new File(((Object)Paths.get(librariesPath$1, destinationFilename)).toString());
        if (!dest.exists()) {
            InputStream source = MODULE$.getClass().getResourceAsStream(new StringBuilder(1).append("/").append(lib).toString());
            Serializable serializable = !dest.getParentFile().exists() ? BoxesRunTime.boxToBoolean(dest.getParentFile().mkdirs()) : BoxedUnit.UNIT;
            FileOutputStream output = new FileOutputStream(dest);
            output.getChannel().transferFrom(Channels.newChannel(source), 0L, Long.MAX_VALUE);
            output.flush();
            output.close();
            source.close();
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$loadIcons$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ ByteBuffer $anonfun$loadIcons$4(int[] pixels$1, int y$1, BufferedImage image$1, ByteBuffer buf$1, int x) {
        int pixel = pixels$1[y$1 * image$1.getWidth() + x];
        buf$1.put((byte)(pixel >> 16 & 0xFF));
        buf$1.put((byte)(pixel >> 8 & 0xFF));
        buf$1.put((byte)(pixel & 0xFF));
        return buf$1.put((byte)(pixel >> 24 & 0xFF));
    }

    public static final /* synthetic */ void $anonfun$loadIcons$2(ByteBuffer[] list$1, Tuple2 x$5) {
        Tuple2 tuple2 = x$5;
        if (tuple2 != null) {
            int size = tuple2._1$mcI$sp();
            int i2 = tuple2._2$mcI$sp();
            URL imageURL = MODULE$.getClass().getResource(new StringBuilder(31).append("/ocelot/desktop/images/icon").append(size).append(".png").toString());
            BufferedImage image = ImageIO.read(imageURL);
            int[] pixels = new int[image.getWidth() * image.getHeight()];
            image.getRGB(0, 0, image.getWidth(), image.getHeight(), pixels, 0, image.getWidth());
            ByteBuffer buf = BufferUtils.createByteBuffer(image.getWidth() * image.getHeight() * 4);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), image.getHeight()).foreach$mVc$sp(y -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), image.getWidth()).foreach((Function1<Object, ByteBuffer> & Serializable)x -> UiHandler$.$anonfun$loadIcons$4(pixels, y, image, buf, BoxesRunTime.unboxToInt(x))));
            buf.flip();
            list$1[i2] = buf;
            return;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ void $anonfun$start$6(BufferedImage image$2, File dir) {
        File file = new File(dir, new StringBuilder(11).append("ocelot-").append(System.currentTimeMillis()).append(".png").toString());
        ImageIO.write((RenderedImage)image$2, "PNG", file);
        MODULE$.logger().debug(new StringBuilder(21).append("Saved screenshot to: ").append(file).toString());
    }

    public static final /* synthetic */ boolean $anonfun$dispatchEvent$1(Dispatchable event$1, Widget widget) {
        return !event$1.consumed();
    }

    public static final /* synthetic */ void $anonfun$dispatchBrainEvents$1(Event event) {
        MODULE$.root().workspaceView().dispatchBrainEvent(event);
    }

    public static final /* synthetic */ boolean $anonfun$update$2(Vector2D mousePos$1, Widget w) {
        return w.receiveScrollEvents() && w.clippedBounds().contains(mousePos$1);
    }

    public static final /* synthetic */ boolean $anonfun$update$3(Vector2D mousePos$1, Widget w) {
        return w.enabled() && w.receiveMouseEvents() && w.clippedBounds().contains(mousePos$1);
    }

    public static final /* synthetic */ void $anonfun$update$4(Widget scrollTarget) {
        UiHandler.DispatchOrder dispatchOrder = UiHandler$DispatchOrder$.MODULE$.resolve(scrollTarget);
        ScrollEvents$.MODULE$.events().foreach((Function1<CapturingEvent, Object> & Serializable)event -> {
            UiHandler$.MODULE$.dispatchCapturing(dispatchOrder, event);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$update$6(Option mouseTarget$1, Widget w) {
        return mouseTarget$1.contains(w) || w.enabled() && w.receiveAllMouseEvents();
    }

    public static final /* synthetic */ void $anonfun$update$7(UiHandler.DispatchOrder mouseEventDispatchOrder$1, UiHandler.DispatchOrder broadcastDispatchOrder$1, MouseEvent event) {
        Enumeration.Value value = event.state();
        Enumeration.Value value2 = MouseEvent$State$.MODULE$.Pressed();
        if (!(value != null ? !((Object)value).equals(value2) : value2 != null)) {
            MODULE$.dispatchCapturing(mouseEventDispatchOrder$1, event);
            return;
        }
        MODULE$.dispatchCapturing(broadcastDispatchOrder$1, event);
    }

    public static final /* synthetic */ void $anonfun$update$8(Widget x0$1) {
        HoverHandler hoverHandler;
        Widget widget = x0$1;
        if (widget instanceof HoverHandler && (hoverHandler = (HoverHandler)((Object)widget))._mouseOver().update(BoxesRunTime.boxToBoolean(true))) {
            MODULE$.dispatchCapturing(UiHandler$DispatchOrder$.MODULE$.resolve((Widget)((Object)hoverHandler)), new HoverEvent(HoverEvent$State$.MODULE$.Enter()));
            return;
        }
    }

    private UiHandler$() {
    }
}

