/*
 * Decompiled with CFR 0.152.
 */
package ocelot.desktop.ui.widget.window;

import java.io.Serializable;
import ocelot.desktop.geometry.Rect2D;
import ocelot.desktop.geometry.Vector2D;
import ocelot.desktop.ui.event.handlers.MouseHandler;
import ocelot.desktop.ui.layout.Layout;
import ocelot.desktop.ui.widget.Widget;
import ocelot.desktop.ui.widget.window.Window;
import ocelot.desktop.util.Disposable;
import ocelot.desktop.util.Persistable;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeqOps;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.ArraySeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import totoro.ocelot.brain.nbt.NBTTagCompound;
import totoro.ocelot.brain.workspace.Workspace;

@ScalaSignature(bytes="\u0006\u0005\u001d4A!\u0005\n\u0001;!)!\u0005\u0001C\u0001G!9a\u0005\u0001b\u0001\n#:\u0003BB\u0017\u0001A\u0003%\u0001\u0006C\u0003/\u0001\u0011%q\u0006C\u0003>\u0001\u0011%a\b\u0003\u0004F\u0001\u0011\u0005!C\u0012\u0005\u0007\u0011\u0002!\tAE%\t\r-\u0003A\u0011\u0001\nM\u0011\u0019q\u0005\u0001\"\u0001\u0013\u001f\"1\u0011\u000b\u0001C\u0001%ICQ\u0001\u0016\u0001\u0005\nUCQA\u0016\u0001\u0005\u0002UCQa\u0016\u0001\u0005\u0002aCQ!\u0019\u0001\u0005\u0002U3AA\u0019\u0001\u0005G\")!e\u0004C\u0001I\nQq+\u001b8e_^\u0004vn\u001c7\u000b\u0005M!\u0012AB<j]\u0012|wO\u0003\u0002\u0016-\u00051q/\u001b3hKRT!a\u0006\r\u0002\u0005UL'BA\r\u001b\u0003\u001d!Wm]6u_BT\u0011aG\u0001\u0007_\u000e,Gn\u001c;\u0004\u0001M\u0011\u0001A\b\t\u0003?\u0001j\u0011\u0001F\u0005\u0003CQ\u0011aaV5eO\u0016$\u0018A\u0002\u001fj]&$h\bF\u0001%!\t)\u0003!D\u0001\u0013\u0003\u0019a\u0017-_8viV\t\u0001\u0006\u0005\u0002*W5\t!F\u0003\u0002'-%\u0011AF\u000b\u0002\u0007\u0019\u0006Lx.\u001e;\u0002\u000f1\f\u0017p\\;uA\u00059q/\u001b8e_^\u001cX#\u0001\u0019\u0011\u0007EB$(D\u00013\u0015\t\u0019D'A\u0005j[6,H/\u00192mK*\u0011QGN\u0001\u000bG>dG.Z2uS>t'\"A\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005e\u0012$\u0001C!se\u0006L8+Z9\u0011\u0005\u0015Z\u0014B\u0001\u001f\u0013\u0005\u00199\u0016N\u001c3po\u0006Yq/\u001b8e_^\u001cx\fJ3r)\ty4\t\u0005\u0002A\u00036\ta'\u0003\u0002Cm\t!QK\\5u\u0011\u0015!U\u00011\u00011\u0003)qWm^,j]\u0012|wo]\u0001\nC\u0012$w+\u001b8e_^$\"aP$\t\u000bM1\u0001\u0019\u0001\u001e\u0002\u0019I,Wn\u001c<f/&tGm\\<\u0015\u0005}R\u0005\"B\n\b\u0001\u0004Q\u0014a\u00034pGV\u001cx+\u001b8e_^$\"aP'\t\u000bMA\u0001\u0019\u0001\u001e\u0002\u001bUtgm\\2vg^Kg\u000eZ8x)\ty\u0004\u000bC\u0003\u0014\u0013\u0001\u0007!(A\nsK\u000e|g/\u001a:M_\u0006$W\rZ,j]\u0012|w\u000f\u0006\u0002@'\")1C\u0003a\u0001u\u0005YQ\u000f\u001d3bi\u00164unY;t)\u0005y\u0014A\u0004:fMJ,7\u000f[,j]\u0012|wo]\u0001\u0012[>4X\rU5o]\u0016$w+\u001b8e_^\u001cHCA Z\u0011\u0015QV\u00021\u0001\\\u0003\u0015!W\r\u001c;b!\tav,D\u0001^\u0015\tq\u0006$\u0001\u0005hK>lW\r\u001e:z\u0013\t\u0001WL\u0001\u0005WK\u000e$xN\u001d\u001aE\u0003A!W\r\\3uK\u0006cGnV5oI><8OA\tQY\u0006\u001cW\r[8mI\u0016\u0014x+\u001b8e_^\u001c2a\u0004\u0010;)\u0005)\u0007C\u00014\u0010\u001b\u0005\u0001\u0001")
public class WindowPool
extends Widget {
    private final Layout layout = new Layout(this);

    @Override
    public Layout layout() {
        return this.layout;
    }

    private ArraySeq<Window> windows() {
        return this.children().map((Function1<Widget, Window> & Serializable)x$1 -> (Window)((Object)x$1));
    }

    private void windows_$eq(ArraySeq<Window> newWindows) {
        this.children_$eq(newWindows);
    }

    public void addWindow(Window window) {
        if (this.windows().contains(window)) {
            return;
        }
        this.windows_$eq((ArraySeq)this.windows().$colon$plus(window));
        this.updateFocus();
    }

    public void removeWindow(Window window) {
        int idx = this.windows().indexOf(window);
        if (idx == -1) {
            return;
        }
        this.windows_$eq((ArraySeq)this.windows().patch(idx, (IterableOnce)Nil$.MODULE$, 1));
        this.updateFocus();
    }

    public void focusWindow(Window window) {
        if (!this.windows().contains(window)) {
            return;
        }
        int idx = this.windows().indexWhere((Function1<Window, Object> & Serializable)x$2 -> BoxesRunTime.boxToBoolean(WindowPool.$anonfun$focusWindow$1(window, x$2)));
        this.windows_$eq((ArraySeq)((SeqOps)this.windows().patch(idx, (IterableOnce)Nil$.MODULE$, 1)).$colon$plus(window));
        this.updateFocus();
    }

    public void unfocusWindow(Window window) {
        if (!this.windows().contains(window)) {
            return;
        }
        if (this.windows().length() >= 2) {
            Window window2 = window;
            Window window3 = this.windows().last();
            if (!(window2 != null ? !window2.equals(window3) : window3 != null)) {
                this.windows_$eq((ArraySeq)((SeqOps)((SeqOps)((IterableOps)this.windows().init()).init()).$colon$plus(window)).$colon$plus(((IndexedSeqOps)this.windows().init()).last()));
            }
        }
        this.updateFocus();
    }

    public void recoverLoadedWindow(Window window) {
        if (window.isClosed()) {
            return;
        }
        int index = window.poolIndex();
        if (index == -1) {
            this.windows_$eq((ArraySeq)this.windows().$colon$plus(window));
            return;
        }
        if (index > this.windows().size()) {
            while (index > this.windows().size()) {
                this.windows_$eq((ArraySeq)this.windows().$colon$plus(new PlaceholderWindow()));
            }
            this.windows_$eq((ArraySeq)this.windows().$colon$plus(window));
            return;
        }
        if (this.windows().apply(window.poolIndex()) instanceof PlaceholderWindow) {
            this.windows_$eq((ArraySeq)this.windows().patch(index, new Some<Window>(window), 1));
            return;
        }
        this.windows_$eq((ArraySeq)this.windows().$colon$plus(window));
    }

    private void updateFocus() {
        if (this.windows().isEmpty()) {
            return;
        }
        ((IterableOnceOps)this.windows().init()).foreach((Function1<Window, Object> & Serializable)x$3 -> {
            x$3.setUnfocused();
            return BoxedUnit.UNIT;
        });
        this.windows().last().setFocused();
        ((IterableOnceOps)this.windows().zipWithIndex()).foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> {
            WindowPool.$anonfun$updateFocus$2(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void refreshWindows() {
        this.windows().foreach((Function1<Window, Object> & Serializable)x$4 -> {
            x$4.refresh();
            return BoxedUnit.UNIT;
        });
    }

    public void movePinnedWindows(Vector2D delta) {
        ((IterableOnceOps)this.windows().filter((Function1<Window, Object> & Serializable)x$5 -> BoxesRunTime.boxToBoolean(x$5.isPinned()))).foreach((Function1<Window, Object> & Serializable)x$6 -> {
            WindowPool.$anonfun$movePinnedWindows$2(delta, x$6);
            return BoxedUnit.UNIT;
        });
    }

    public void deleteAllWindows() {
        this.windows().foreach((Function1<Window, Object> & Serializable)x$7 -> {
            x$7.dispose();
            return BoxedUnit.UNIT;
        });
        this.windows_$eq(ArraySeq$.MODULE$.empty(ClassTag$.MODULE$.Nothing()));
    }

    public static final /* synthetic */ boolean $anonfun$focusWindow$1(Window window$1, Window x$2) {
        Window window = x$2;
        Window window2 = window$1;
        return !(window != null ? !window.equals(window2) : window2 != null);
    }

    public static final /* synthetic */ void $anonfun$updateFocus$2(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Window window = (Window)tuple2._1();
            int index = tuple2._2$mcI$sp();
            window.poolIndex_$eq(index);
            return;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ void $anonfun$movePinnedWindows$2(Vector2D delta$1, Window x$6) {
        ((Widget)((Object)x$6)).position_$eq(((Widget)((Object)x$6)).position().$plus(delta$1));
    }

    private class PlaceholderWindow
    extends Widget
    implements Window {
        private Enumeration.Value ocelot$desktop$ui$widget$window$Window$$_state;
        private boolean ocelot$desktop$ui$widget$window$Window$$_isFocused;
        private boolean ocelot$desktop$ui$widget$window$Window$$_isPinned;
        private Option<Vector2D> ocelot$desktop$ui$widget$window$Window$$grabPoint;
        private boolean ocelot$desktop$ui$widget$window$Window$$disposeOnClose;
        private boolean ocelot$desktop$ui$widget$window$Window$$isDisposed;
        private boolean ocelot$desktop$ui$widget$window$Window$$isFitToCenterRequired;
        private int poolIndex;
        private HashMap<Enumeration.Value, Vector2D> ocelot$desktop$ui$event$handlers$MouseHandler$$startPositions;
        private HashMap<Enumeration.Value, Vector2D> ocelot$desktop$ui$event$handlers$MouseHandler$$prevPositions;
        private HashSet<Enumeration.Value> ocelot$desktop$ui$event$handlers$MouseHandler$$dragButtons;
        private Option<MouseHandler.ClickInfo> ocelot$desktop$ui$event$handlers$MouseHandler$$lastClickInfo;

        @Override
        public /* synthetic */ void ocelot$desktop$ui$widget$window$Window$$super$dispose() {
            Disposable.dispose$(this);
        }

        @Override
        public /* synthetic */ void ocelot$desktop$ui$widget$window$Window$$super$update() {
            MouseHandler.update$(this);
        }

        @Override
        public boolean receiveDragEvents() {
            return Window.receiveDragEvents$(this);
        }

        @Override
        public final WindowPool windowPool() {
            return Window.windowPool$(this);
        }

        @Override
        public final Enumeration.Value state() {
            return Window.state$(this);
        }

        @Override
        public final void state_$eq(Enumeration.Value newState) {
            Window.state_$eq$(this, newState);
        }

        @Override
        public final boolean isOpening() {
            return Window.isOpening$(this);
        }

        @Override
        public final boolean isOpen() {
            return Window.isOpen$(this);
        }

        @Override
        public final boolean isClosing() {
            return Window.isClosing$(this);
        }

        @Override
        public final boolean isClosed() {
            return Window.isClosed$(this);
        }

        @Override
        public void fitToCenter() {
            Window.fitToCenter$(this);
        }

        @Override
        public Enumeration.Value onOpening() {
            return Window.onOpening$(this);
        }

        @Override
        public Enumeration.Value onOpen() {
            return Window.onOpen$(this);
        }

        @Override
        public Enumeration.Value onClosing() {
            return Window.onClosing$(this);
        }

        @Override
        public Enumeration.Value onClosed() {
            return Window.onClosed$(this);
        }

        @Override
        public final void open() {
            Window.open$(this);
        }

        @Override
        public final void close() {
            Window.close$(this);
        }

        @Override
        public final boolean isFocused() {
            return Window.isFocused$(this);
        }

        @Override
        public void onFocused() {
            Window.onFocused$(this);
        }

        @Override
        public void onUnfocused() {
            Window.onUnfocused$(this);
        }

        @Override
        public final void setFocused() {
            Window.setFocused$(this);
        }

        @Override
        public final void setUnfocused() {
            Window.setUnfocused$(this);
        }

        @Override
        public final void focus() {
            Window.focus$(this);
        }

        @Override
        public final void unfocus() {
            Window.unfocus$(this);
        }

        @Override
        public final boolean isPinned() {
            return Window.isPinned$(this);
        }

        @Override
        public void onPinned() {
            Window.onPinned$(this);
        }

        @Override
        public void onUnpinned() {
            Window.onUnpinned$(this);
        }

        @Override
        public final void pin() {
            Window.pin$(this);
        }

        @Override
        public final void unpin() {
            Window.unpin$(this);
        }

        @Override
        public void refresh() {
            Window.refresh$(this);
        }

        @Override
        public void dispose() {
            Window.dispose$(this);
        }

        @Override
        public void closeAndDispose() {
            Window.closeAndDispose$(this);
        }

        @Override
        public Iterator<Rect2D> dragRegions() {
            return Window.dragRegions$(this);
        }

        @Override
        public void save(NBTTagCompound nbt) {
            Window.save$(this, nbt);
        }

        @Override
        public void load(NBTTagCompound nbt) {
            Window.load$(this, nbt);
        }

        @Override
        public void update() {
            Window.update$(this);
        }

        @Override
        public /* synthetic */ void ocelot$desktop$ui$event$handlers$MouseHandler$$super$update() {
            super.update();
        }

        @Override
        public boolean receiveMouseEvents() {
            return MouseHandler.receiveMouseEvents$(this);
        }

        @Override
        public boolean receiveClickEvents() {
            return MouseHandler.receiveClickEvents$(this);
        }

        @Override
        public boolean spamDragEvents() {
            return MouseHandler.spamDragEvents$(this);
        }

        @Override
        public boolean allowClickReleaseOutsideThreshold() {
            return MouseHandler.allowClickReleaseOutsideThreshold$(this);
        }

        @Override
        public final void load(NBTTagCompound nbt, Workspace workspace) {
            Persistable.load$(this, nbt, workspace);
        }

        @Override
        public final Enumeration.Value ocelot$desktop$ui$widget$window$Window$$_state() {
            return this.ocelot$desktop$ui$widget$window$Window$$_state;
        }

        @Override
        public final void ocelot$desktop$ui$widget$window$Window$$_state_$eq(Enumeration.Value x$1) {
            this.ocelot$desktop$ui$widget$window$Window$$_state = x$1;
        }

        @Override
        public final boolean ocelot$desktop$ui$widget$window$Window$$_isFocused() {
            return this.ocelot$desktop$ui$widget$window$Window$$_isFocused;
        }

        @Override
        public final void ocelot$desktop$ui$widget$window$Window$$_isFocused_$eq(boolean x$1) {
            this.ocelot$desktop$ui$widget$window$Window$$_isFocused = x$1;
        }

        @Override
        public final boolean ocelot$desktop$ui$widget$window$Window$$_isPinned() {
            return this.ocelot$desktop$ui$widget$window$Window$$_isPinned;
        }

        @Override
        public final void ocelot$desktop$ui$widget$window$Window$$_isPinned_$eq(boolean x$1) {
            this.ocelot$desktop$ui$widget$window$Window$$_isPinned = x$1;
        }

        @Override
        public Option<Vector2D> ocelot$desktop$ui$widget$window$Window$$grabPoint() {
            return this.ocelot$desktop$ui$widget$window$Window$$grabPoint;
        }

        @Override
        public void ocelot$desktop$ui$widget$window$Window$$grabPoint_$eq(Option<Vector2D> x$1) {
            this.ocelot$desktop$ui$widget$window$Window$$grabPoint = x$1;
        }

        @Override
        public boolean ocelot$desktop$ui$widget$window$Window$$disposeOnClose() {
            return this.ocelot$desktop$ui$widget$window$Window$$disposeOnClose;
        }

        @Override
        public void ocelot$desktop$ui$widget$window$Window$$disposeOnClose_$eq(boolean x$1) {
            this.ocelot$desktop$ui$widget$window$Window$$disposeOnClose = x$1;
        }

        @Override
        public boolean ocelot$desktop$ui$widget$window$Window$$isDisposed() {
            return this.ocelot$desktop$ui$widget$window$Window$$isDisposed;
        }

        @Override
        public void ocelot$desktop$ui$widget$window$Window$$isDisposed_$eq(boolean x$1) {
            this.ocelot$desktop$ui$widget$window$Window$$isDisposed = x$1;
        }

        @Override
        public boolean ocelot$desktop$ui$widget$window$Window$$isFitToCenterRequired() {
            return this.ocelot$desktop$ui$widget$window$Window$$isFitToCenterRequired;
        }

        @Override
        public void ocelot$desktop$ui$widget$window$Window$$isFitToCenterRequired_$eq(boolean x$1) {
            this.ocelot$desktop$ui$widget$window$Window$$isFitToCenterRequired = x$1;
        }

        @Override
        public int poolIndex() {
            return this.poolIndex;
        }

        @Override
        public void poolIndex_$eq(int x$1) {
            this.poolIndex = x$1;
        }

        @Override
        public HashMap<Enumeration.Value, Vector2D> ocelot$desktop$ui$event$handlers$MouseHandler$$startPositions() {
            return this.ocelot$desktop$ui$event$handlers$MouseHandler$$startPositions;
        }

        @Override
        public HashMap<Enumeration.Value, Vector2D> ocelot$desktop$ui$event$handlers$MouseHandler$$prevPositions() {
            return this.ocelot$desktop$ui$event$handlers$MouseHandler$$prevPositions;
        }

        @Override
        public HashSet<Enumeration.Value> ocelot$desktop$ui$event$handlers$MouseHandler$$dragButtons() {
            return this.ocelot$desktop$ui$event$handlers$MouseHandler$$dragButtons;
        }

        @Override
        public Option<MouseHandler.ClickInfo> ocelot$desktop$ui$event$handlers$MouseHandler$$lastClickInfo() {
            return this.ocelot$desktop$ui$event$handlers$MouseHandler$$lastClickInfo;
        }

        @Override
        public void ocelot$desktop$ui$event$handlers$MouseHandler$$lastClickInfo_$eq(Option<MouseHandler.ClickInfo> x$1) {
            this.ocelot$desktop$ui$event$handlers$MouseHandler$$lastClickInfo = x$1;
        }

        @Override
        public final void ocelot$desktop$ui$event$handlers$MouseHandler$_setter_$ocelot$desktop$ui$event$handlers$MouseHandler$$startPositions_$eq(HashMap<Enumeration.Value, Vector2D> x$1) {
            this.ocelot$desktop$ui$event$handlers$MouseHandler$$startPositions = x$1;
        }

        @Override
        public final void ocelot$desktop$ui$event$handlers$MouseHandler$_setter_$ocelot$desktop$ui$event$handlers$MouseHandler$$prevPositions_$eq(HashMap<Enumeration.Value, Vector2D> x$1) {
            this.ocelot$desktop$ui$event$handlers$MouseHandler$$prevPositions = x$1;
        }

        @Override
        public final void ocelot$desktop$ui$event$handlers$MouseHandler$_setter_$ocelot$desktop$ui$event$handlers$MouseHandler$$dragButtons_$eq(HashSet<Enumeration.Value> x$1) {
            this.ocelot$desktop$ui$event$handlers$MouseHandler$$dragButtons = x$1;
        }

        public /* synthetic */ WindowPool ocelot$desktop$ui$widget$window$WindowPool$PlaceholderWindow$$$outer() {
            return WindowPool.this;
        }

        public PlaceholderWindow() {
            if (WindowPool.this == null) {
                throw null;
            }
            totoro.ocelot.brain.util.Persistable.$init$(this);
            Persistable.$init$(this);
            MouseHandler.$init$(this);
            Window.$init$(this);
            Statics.releaseFence();
        }
    }
}

