/*
 * Decompiled with CFR 0.152.
 */
package ocelot.desktop.util;

import java.io.Serializable;
import ocelot.desktop.ColorScheme$;
import ocelot.desktop.color.Color;
import ocelot.desktop.color.RGBAColor;
import ocelot.desktop.color.RGBAColor$;
import ocelot.desktop.color.RGBAColorNorm;
import ocelot.desktop.color.RGBAColorNorm$;
import ocelot.desktop.geometry.Rect2D;
import ocelot.desktop.geometry.Vector2D;
import ocelot.desktop.graphics.Graphics;
import ocelot.desktop.graphics.IconSource;
import ocelot.desktop.graphics.IconSource$;
import ocelot.desktop.graphics.IconSource$Panel$;
import ocelot.desktop.graphics.IconSource$Screen$;
import ocelot.desktop.graphics.IconSource$Window$;
import ocelot.desktop.node.Node$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.NonLocalReturnControl$mcZ$sp;
import scala.runtime.ObjectRef;
import scala.runtime.RichDouble$;
import scala.runtime.RichFloat$;
import totoro.ocelot.brain.entity.machine.Machine;
import totoro.ocelot.brain.entity.traits.DiskActivityAware;
import totoro.ocelot.brain.entity.traits.NetworkActivityAware;

public final class DrawUtils$ {
    public static final DrawUtils$ MODULE$ = new DrawUtils$();

    public void screenBorder(Graphics g2, Rect2D outer, Rect2D inner, Color color) {
        int thicknessOuterTop = 12;
        int thickness = 8;
        int top = thickness + thicknessOuterTop;
        int side = 2 * thickness;
        int horizontal = 2 * side;
        int vertical = top + side;
        float rightBorderX = outer.max().x() - (float)side;
        float bottomBorderY = outer.max().y() - (float)side;
        g2.rect(outer.x() + (float)thickness, outer.y() + (float)thicknessOuterTop, outer.w() - (float)(2 * thickness), outer.h() - (float)thickness - (float)thicknessOuterTop, ColorScheme$.MODULE$.apply("WindowBackground").withAlpha(color.toRGBANorm().a()));
        g2.sprite(IconSource$Screen$.MODULE$.InnerCornerTL(), inner.x() - (float)thickness, inner.y() - (float)thickness, thickness, thickness, color);
        g2.sprite(IconSource$Screen$.MODULE$.InnerCornerTR(), inner.max().x(), inner.y() - (float)thickness, thickness, thickness, color);
        g2.sprite(IconSource$Screen$.MODULE$.InnerCornerBL(), inner.x() - (float)thickness, inner.max().y(), thickness, thickness, color);
        g2.sprite(IconSource$Screen$.MODULE$.InnerCornerBR(), inner.max().x(), inner.max().y(), thickness, thickness, color);
        g2.sprite(IconSource$Screen$.MODULE$.InnerBorderT(), inner.x(), inner.y() - (float)thickness, inner.w(), thickness, color);
        g2.sprite(IconSource$Screen$.MODULE$.InnerBorderB(), inner.x(), inner.max().y(), inner.w(), thickness, color);
        g2.save();
        g2.translate(inner.x() - (float)thickness, inner.y());
        g2.rotate(RichFloat$.MODULE$.toRadians$extension(Predef$.MODULE$.floatWrapper(270.0f)));
        g2.sprite(IconSource$Screen$.MODULE$.InnerBorderT(), -inner.h(), 0.0f, inner.h(), thickness, color);
        g2.restore();
        g2.save();
        g2.translate(inner.max().x(), inner.y());
        g2.rotate(RichFloat$.MODULE$.toRadians$extension(Predef$.MODULE$.floatWrapper(270.0f)));
        g2.sprite(IconSource$Screen$.MODULE$.InnerBorderB(), -inner.h(), 0.0f, inner.h(), thickness, color);
        g2.restore();
        g2.sprite(IconSource$Screen$.MODULE$.OuterCornerTL(), outer.x(), outer.y(), side, top, color);
        g2.sprite(IconSource$Screen$.MODULE$.OuterCornerTR(), rightBorderX, outer.y(), side, top, color);
        g2.sprite(IconSource$Screen$.MODULE$.OuterCornerBL(), outer.x(), bottomBorderY, side, side, color);
        g2.sprite(IconSource$Screen$.MODULE$.OuterCornerBR(), rightBorderX, bottomBorderY, side, side, color);
        g2.sprite(IconSource$Screen$.MODULE$.OuterBorderT(), outer.x() + (float)side, outer.y(), outer.w() - (float)horizontal, thicknessOuterTop, color);
        g2.sprite(IconSource$Screen$.MODULE$.InnerBorderT(), outer.x() + (float)side, outer.max().y() - (float)thickness, outer.w() - (float)horizontal, thickness, color);
        g2.save();
        g2.translate(outer.x(), outer.y() + (float)top);
        g2.rotate(RichFloat$.MODULE$.toRadians$extension(Predef$.MODULE$.floatWrapper(270.0f)));
        g2.sprite(IconSource$Screen$.MODULE$.InnerBorderB(), -outer.h() + (float)vertical, 0.0f, outer.h() - (float)vertical, thickness, color);
        g2.restore();
        g2.save();
        g2.translate(outer.max().x() - (float)thickness, outer.y() + (float)top);
        g2.rotate(RichFloat$.MODULE$.toRadians$extension(Predef$.MODULE$.floatWrapper(270.0f)));
        g2.sprite(IconSource$Screen$.MODULE$.InnerBorderT(), -outer.h() + (float)vertical, 0.0f, outer.h() - (float)vertical, thickness, color);
        g2.restore();
    }

    public Color screenBorder$default$4() {
        return new RGBAColor(255, 255, 255, RGBAColor$.MODULE$.apply$default$4());
    }

    public void panel(Graphics g2, float x, float y, float w, float h2) {
        g2.sprite(IconSource$Panel$.MODULE$.CornerTL(), x, y, 4.0f, 4.0f);
        g2.sprite(IconSource$Panel$.MODULE$.CornerTR(), x + w - (float)4, y, 4.0f, 4.0f);
        g2.sprite(IconSource$Panel$.MODULE$.CornerBL(), x, y + h2 - (float)4, 4.0f, 4.0f);
        g2.sprite(IconSource$Panel$.MODULE$.CornerBR(), x + w - (float)4, y + h2 - (float)4, 4.0f, 4.0f);
        g2.sprite(IconSource$Panel$.MODULE$.BorderT(), x + (float)4, y, w - (float)8, 4.0f);
        g2.sprite(IconSource$Panel$.MODULE$.BorderB(), x + (float)4, y + h2 - (float)4, w - (float)8, 4.0f);
        g2.sprite(IconSource$Panel$.MODULE$.BorderL(), x, y + (float)4, 4.0f, h2 - (float)8);
        g2.sprite(IconSource$Panel$.MODULE$.BorderR(), x + w - (float)4, y + (float)4, 4.0f, h2 - (float)8);
        g2.sprite(IconSource$Panel$.MODULE$.Fill(), x + (float)4, y + (float)4, w - (float)8, h2 - (float)8);
    }

    public boolean isValidPolyline(Vector2D[] points) {
        boolean bl;
        Object object = new Object();
        try {
            if (points.length < 3) {
                return true;
            }
            ObjectRef<Vector2D> start = ObjectRef.create(points[0]);
            ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.refArrayOps(points)).zipWithIndex().slice(1, points.length - 1).withFilter((Function1<Tuple2, Object> & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(DrawUtils$.$anonfun$isValidPolyline$1(check$ifrefutable$1))).foreach((Function1<Tuple2, Object> & Serializable)x$1 -> {
                DrawUtils$.$anonfun$isValidPolyline$2(start, points, object, x$1);
                return BoxedUnit.UNIT;
            });
            bl = true;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    public void polyline(Graphics g2, Vector2D[] points, float thickness, Color color) {
        if (points.length < 2) {
            return;
        }
        if (!this.isValidPolyline(points)) {
            return;
        }
        float alpha = color.toRGBANorm().a();
        RGBAColorNorm qual$1 = color.toRGBANorm();
        float x$1 = 1.0f;
        float x$22 = qual$1.copy$default$1();
        float x$3 = qual$1.copy$default$2();
        float x$4 = qual$1.copy$default$3();
        RGBAColorNorm col = qual$1.copy(x$22, x$3, x$4, 1.0f);
        if (alpha < 1.0f) {
            g2.beginGroupAlpha();
        }
        ObjectRef<Vector2D> start = ObjectRef.create(points[0]);
        ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.refArrayOps(points)).zipWithIndex().drop(1).withFilter((Function1<Tuple2, Object> & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean(DrawUtils$.$anonfun$polyline$1(check$ifrefutable$2))).foreach((Function1<Tuple2, Object> & Serializable)x$2 -> {
            DrawUtils$.$anonfun$polyline$2(points, start, thickness, g2, col, x$2);
            return BoxedUnit.UNIT;
        });
        if (alpha < 1.0f) {
            g2.endGroupAlpha(alpha);
            return;
        }
    }

    public float polyline$default$3() {
        return 4.0f;
    }

    public Color polyline$default$4() {
        return new RGBAColor(255, 255, 255, RGBAColor$.MODULE$.apply$default$4());
    }

    public void windowWithShadow(Graphics g2, float x, float y, float w, float h2, float backgroundAlpha, float shadowAlpha) {
        this.shadow(g2, x - (float)8, y - (float)8, w + (float)16, h2 + (float)20, shadowAlpha);
        this.windowBorder(g2, x, y, w, h2, new RGBAColorNorm(1.0f, 1.0f, 1.0f, backgroundAlpha));
    }

    public void ring(Graphics g2, float x, float y, float w, float h2, float thickness, Color color) {
        g2.rect(x, y, thickness, h2, color);
        g2.rect(x + w - thickness, y, thickness, h2, color);
        g2.rect(x + thickness, y, w - thickness * 2.0f, thickness, color);
        g2.rect(x + thickness, y + h2 - thickness, w - thickness * 2.0f, thickness, color);
    }

    public float ring$default$6() {
        return 4.0f;
    }

    public Color ring$default$7() {
        return new RGBAColor(255, 255, 255, RGBAColor$.MODULE$.apply$default$4());
    }

    public void windowBorder(Graphics g2, float x, float y, float w, float h2, Color color) {
        g2.sprite(IconSource$Window$.MODULE$.CornerTL(), x, y, 8.0f, 8.0f, color);
        g2.sprite(IconSource$Window$.MODULE$.CornerTR(), x + w - (float)8, y, 8.0f, 8.0f, color);
        g2.sprite(IconSource$Window$.MODULE$.CornerBL(), x, y + h2 - (float)8, 8.0f, 8.0f, color);
        g2.sprite(IconSource$Window$.MODULE$.CornerBR(), x + w - (float)8, y + h2 - (float)8, 8.0f, 8.0f, color);
        g2.sprite(IconSource$Window$.MODULE$.BorderLight(), x + (float)8, y, w - (float)16, 8.0f, color);
        g2.sprite(IconSource$Window$.MODULE$.BorderDark(), x + (float)8, y + h2 - (float)8, w - (float)16, 8.0f, color);
        g2.save();
        g2.translate(x, y + (float)8);
        g2.rotate(RichFloat$.MODULE$.toRadians$extension(Predef$.MODULE$.floatWrapper(270.0f)));
        g2.sprite(IconSource$Window$.MODULE$.BorderLight(), 0.0f, 0.0f, -h2 + (float)16, 8.0f, color);
        g2.sprite(IconSource$Window$.MODULE$.BorderDark(), 0.0f, w - (float)8, -h2 + (float)16, 8.0f, color);
        g2.restore();
        g2.rect(x + (float)8, y + (float)8, w - (float)16, h2 - (float)16, new RGBAColor(198, 198, 198, color.toRGBA().a()));
    }

    public Color windowBorder$default$6() {
        return new RGBAColor(255, 255, 255, RGBAColor$.MODULE$.apply$default$4());
    }

    public void shadow(Graphics g2, float x, float y, float w, float h2, float a2) {
        RGBAColorNorm col = new RGBAColorNorm(1.0f, 1.0f, 1.0f, a2);
        this.rotSprite(g2, IconSource$.MODULE$.ShadowCorner(), x, y, 24.0f, 24.0f, RichFloat$.MODULE$.toRadians$extension(Predef$.MODULE$.floatWrapper(180.0f)), col);
        this.rotSprite(g2, IconSource$.MODULE$.ShadowCorner(), x + w - (float)24, y, 24.0f, 24.0f, RichFloat$.MODULE$.toRadians$extension(Predef$.MODULE$.floatWrapper(270.0f)), col);
        this.rotSprite(g2, IconSource$.MODULE$.ShadowCorner(), x, y + h2 - (float)24, 24.0f, 24.0f, RichFloat$.MODULE$.toRadians$extension(Predef$.MODULE$.floatWrapper(90.0f)), col);
        g2.sprite(IconSource$.MODULE$.ShadowCorner(), x + w - (float)24, y + h2 - (float)24, 24.0f, 24.0f, col);
        g2.sprite(IconSource$.MODULE$.ShadowBorder(), x + (float)24, y + (float)24, w - (float)48, -24.0f, col);
        g2.sprite(IconSource$.MODULE$.ShadowBorder(), x + (float)24, y + h2 - (float)24, w - (float)48, 24.0f, col);
        g2.save();
        g2.translate(x + (float)24, y + (float)24);
        g2.rotate(RichFloat$.MODULE$.toRadians$extension(Predef$.MODULE$.floatWrapper(90.0f)));
        g2.sprite(IconSource$.MODULE$.ShadowBorder(), 0.0f, 0.0f, h2 - (float)48, 24.0f, col);
        g2.restore();
        g2.save();
        g2.translate(x + w - (float)24, y + h2 - (float)24);
        g2.rotate(RichFloat$.MODULE$.toRadians$extension(Predef$.MODULE$.floatWrapper(270.0f)));
        g2.sprite(IconSource$.MODULE$.ShadowBorder(), 0.0f, 0.0f, h2 - (float)48, 24.0f, col);
        g2.restore();
        g2.rect(x + (float)24, y + (float)24, w - (float)48, h2 - (float)48, new RGBAColorNorm(0.0f, 0.0f, 0.0f, a2));
    }

    public float shadow$default$6() {
        return 0.8f;
    }

    private void rotSprite(Graphics g2, IconSource icon, float x, float y, float w, float h2, float angle, Color col) {
        g2.save();
        g2.translate(x + w / 2.0f, y + h2 / 2.0f);
        g2.rotate(angle);
        g2.sprite(icon, -w / 2.0f, -h2 / 2.0f, w, h2, col);
        g2.restore();
    }

    private Color rotSprite$default$8() {
        return new RGBAColorNorm(1.0f, 1.0f, 1.0f, RGBAColorNorm$.MODULE$.apply$default$4());
    }

    public void borderedText(Graphics g2, float x, float y, String text, Color borderColor) {
        RGBAColorNorm col = g2.foreground();
        g2.foreground_$eq(borderColor);
        g2.text(x + 1.0f, y, text, g2.text$default$4());
        g2.text(x - 1.0f, y, text, g2.text$default$4());
        g2.text(x, y + 1.0f, text, g2.text$default$4());
        g2.text(x, y - 1.0f, text, g2.text$default$4());
        g2.text(x + 1.0f, y + 1.0f, text, g2.text$default$4());
        g2.text(x - 1.0f, y + 1.0f, text, g2.text$default$4());
        g2.text(x + 1.0f, y - 1.0f, text, g2.text$default$4());
        g2.text(x - 1.0f, y - 1.0f, text, g2.text$default$4());
        g2.foreground_$eq(col);
        g2.text(x, y, text, g2.text$default$4());
    }

    public Color borderedText$default$5() {
        return new RGBAColor(0, 0, 0, RGBAColor$.MODULE$.apply$default$4());
    }

    public void drawPowerOrError(Graphics g2, float x, float y, Machine machine, IconSource.PowerIconSource iconSource) {
        boolean hasErred = machine.lastError() != null;
        DrawUtils$.tryDraw$1(iconSource.On(), machine.isRunning() && !hasErred, g2, x, y);
        DrawUtils$.tryDraw$1(iconSource.Error(), !machine.isRunning() && hasErred, g2, x, y);
    }

    public void drawFilesystemActivity(Graphics g2, float x, float y, IconSource.DiskActivityIconSource iconSource) {
        g2.sprite(iconSource.DiskActivity(), x, y, Node$.MODULE$.NoHighlightSize(), Node$.MODULE$.NoHighlightSize());
    }

    public void drawFilesystemActivity(Graphics g2, float x, float y, DiskActivityAware diskActivityAware, IconSource.DiskActivityIconSource iconSource) {
        if (diskActivityAware.shouldVisualizeDiskActivity()) {
            this.drawFilesystemActivity(g2, x, y, iconSource);
            return;
        }
    }

    public void drawNetworkActivity(Graphics g2, float x, float y, NetworkActivityAware networkActivityAware, IconSource.NetworkActivityIconSource iconSource) {
        if (networkActivityAware.shouldVisualizeNetworkActivity()) {
            g2.sprite(iconSource.NetworkActivity(), x, y, Node$.MODULE$.NoHighlightSize(), Node$.MODULE$.NoHighlightSize());
            return;
        }
    }

    public void drawTextLines(Graphics g2, float x, float y, Iterable<String> lines) {
        ((IterableOps)lines.zipWithIndex()).withFilter((Function1<Tuple2, Object> & Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean(DrawUtils$.$anonfun$drawTextLines$1(check$ifrefutable$3))).foreach((Function1<Tuple2, Object> & Serializable)x$3 -> {
            DrawUtils$.$anonfun$drawTextLines$2(g2, x, y, x$3);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$isValidPolyline$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$isValidPolyline$2(ObjectRef start$1, Vector2D[] points$1, Object nonLocalReturnKey1$1, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            Vector2D b2;
            Vector2D end = (Vector2D)tuple2._1();
            int i2 = tuple2._2$mcI$sp();
            Vector2D a2 = end.$minus((Vector2D)start$1.elem);
            if ((double)RichFloat$.MODULE$.abs$extension(Predef$.MODULE$.floatWrapper(a2.angle(b2 = end.$minus(points$1[i2 + 1])))) < 1.5707963267948966) {
                throw new NonLocalReturnControl$mcZ$sp(nonLocalReturnKey1$1, false);
            }
            start$1.elem = end;
            return;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$polyline$1(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$polyline$2(Vector2D[] points$2, ObjectRef start$2, float thickness$1, Graphics g$1, RGBAColorNorm col$1, Tuple2 x$2) {
        Tuple2 tuple2 = x$2;
        if (tuple2 != null) {
            Vector2D end = (Vector2D)tuple2._1();
            int i2 = tuple2._2$mcI$sp();
            Vector2D vector2D = end;
            Object a2 = ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps(points$2));
            if (vector2D == null ? a2 != null : !((Object)vector2D).equals(a2)) {
                Vector2D a3 = end.$minus((Vector2D)start$2.elem);
                Vector2D b2 = end.$minus(points$2[i2 + 1]);
                float addition = thickness$1 / (2.0f * (float)RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(package$.MODULE$.tan(a3.angle(b2) / 2.0f))));
                g$1.line((Vector2D)start$2.elem, end.$plus(a3.normalize().$times(addition)), thickness$1, col$1);
                start$2.elem = end.$plus(b2.normalize().$times(addition));
                return;
            }
            g$1.line((Vector2D)start$2.elem, end, thickness$1, col$1);
            return;
        }
        throw new MatchError(tuple2);
    }

    private static final void tryDraw$1(IconSource icon, boolean state, Graphics g$2, float x$4, float y$1) {
        if (state) {
            g$2.sprite(icon, x$4, y$1, Node$.MODULE$.NoHighlightSize(), Node$.MODULE$.NoHighlightSize());
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$drawTextLines$1(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$drawTextLines$2(Graphics g$3, float x$5, float y$2, Tuple2 x$3) {
        Tuple2 tuple2 = x$3;
        if (tuple2 != null) {
            String line = (String)tuple2._1();
            int idx = tuple2._2$mcI$sp();
            g$3.text(x$5, y$2 + (float)(idx * g$3.font().fontSize()), line, g$3.text$default$4());
            return;
        }
        throw new MatchError(tuple2);
    }

    private DrawUtils$() {
    }
}

