/*
 * Decompiled with CFR 0.152.
 */
package ocelot.desktop.util;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import org.apache.commons.lang3.SystemUtils;

public final class OcelotPaths$ {
    public static final OcelotPaths$ MODULE$ = new OcelotPaths$();

    public String windowsAppDataDirectoryName() {
        return Objects.requireNonNull(System.getenv("APPDATA"), "%APPDATA% is null");
    }

    public String linuxHomeDirectoryName() {
        return Objects.requireNonNull(SystemUtils.USER_HOME, "USER_HOME is null");
    }

    public String openComputersConfigName() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return "OpenComputers.conf";
        }
        return "opencomputers.conf";
    }

    public Path libraries() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return Paths.get(this.windowsAppDataDirectoryName(), "Ocelot", "Libraries");
        }
        return Paths.get(this.linuxHomeDirectoryName(), ".local", "lib", "ocelot");
    }

    public Path openComputersConfig() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return Paths.get(this.windowsAppDataDirectoryName(), "Ocelot", "Config", this.openComputersConfigName());
        }
        return Paths.get(this.linuxHomeDirectoryName(), ".config", "ocelot", this.openComputersConfigName());
    }

    public Path desktopConfig() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return Paths.get(this.windowsAppDataDirectoryName(), "Ocelot", "Config", "Desktop.conf");
        }
        return Paths.get(this.linuxHomeDirectoryName(), ".config", "ocelot", "desktop.conf");
    }

    public Path desktopLog() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return Paths.get(this.windowsAppDataDirectoryName(), "Ocelot", "Logs", "Desktop.log");
        }
        return Paths.get(this.linuxHomeDirectoryName(), ".local", "share", "ocelot", "desktop.log");
    }

    private OcelotPaths$() {
    }
}

