/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.solvers;

import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.solvers.AllowedSolution;
import org.apache.commons.math3.analysis.solvers.BracketedUnivariateSolver;
import org.apache.commons.math3.analysis.solvers.BrentSolver;
import org.apache.commons.math3.exception.NoBracketingException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.util.FastMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnivariateSolverUtils {
    private UnivariateSolverUtils() {
    }

    public static double solve(UnivariateFunction function, double x0, double x1) throws NullArgumentException, NoBracketingException {
        if (function == null) {
            throw new NullArgumentException(LocalizedFormats.FUNCTION, new Object[0]);
        }
        BrentSolver solver = new BrentSolver();
        return solver.solve(Integer.MAX_VALUE, function, x0, x1);
    }

    public static double solve(UnivariateFunction function, double x0, double x1, double absoluteAccuracy) throws NullArgumentException, NoBracketingException {
        if (function == null) {
            throw new NullArgumentException(LocalizedFormats.FUNCTION, new Object[0]);
        }
        BrentSolver solver = new BrentSolver(absoluteAccuracy);
        return solver.solve(Integer.MAX_VALUE, function, x0, x1);
    }

    public static double forceSide(int maxEval, UnivariateFunction f2, BracketedUnivariateSolver<UnivariateFunction> bracketing, double baseRoot, double min2, double max2, AllowedSolution allowedSolution) throws NoBracketingException {
        if (allowedSolution == AllowedSolution.ANY_SIDE) {
            return baseRoot;
        }
        double step = FastMath.max(bracketing.getAbsoluteAccuracy(), FastMath.abs(baseRoot * bracketing.getRelativeAccuracy()));
        double xLo = FastMath.max(min2, baseRoot - step);
        double fLo = f2.value(xLo);
        double xHi = FastMath.min(max2, baseRoot + step);
        double fHi = f2.value(xHi);
        int remainingEval = maxEval - 2;
        while (remainingEval > 0) {
            if (fLo >= 0.0 && fHi <= 0.0 || fLo <= 0.0 && fHi >= 0.0) {
                return bracketing.solve(remainingEval, f2, xLo, xHi, baseRoot, allowedSolution);
            }
            boolean changeLo = false;
            boolean changeHi = false;
            if (fLo < fHi) {
                if (fLo >= 0.0) {
                    changeLo = true;
                } else {
                    changeHi = true;
                }
            } else if (fLo > fHi) {
                if (fLo <= 0.0) {
                    changeLo = true;
                } else {
                    changeHi = true;
                }
            } else {
                changeLo = true;
                changeHi = true;
            }
            if (changeLo) {
                xLo = FastMath.max(min2, xLo - step);
                fLo = f2.value(xLo);
                --remainingEval;
            }
            if (!changeHi) continue;
            xHi = FastMath.min(max2, xHi + step);
            fHi = f2.value(xHi);
            --remainingEval;
        }
        throw new NoBracketingException((Localizable)LocalizedFormats.FAILED_BRACKETING, xLo, xHi, fLo, fHi, new Object[]{maxEval - remainingEval, maxEval, baseRoot, min2, max2});
    }

    public static double[] bracket(UnivariateFunction function, double initial, double lowerBound, double upperBound) throws NullArgumentException, NotStrictlyPositiveException, NoBracketingException {
        return UnivariateSolverUtils.bracket(function, initial, lowerBound, upperBound, 1.0, 1.0, Integer.MAX_VALUE);
    }

    public static double[] bracket(UnivariateFunction function, double initial, double lowerBound, double upperBound, int maximumIterations) throws NullArgumentException, NotStrictlyPositiveException, NoBracketingException {
        return UnivariateSolverUtils.bracket(function, initial, lowerBound, upperBound, 1.0, 1.0, maximumIterations);
    }

    public static double[] bracket(UnivariateFunction function, double initial, double lowerBound, double upperBound, double q, double r, int maximumIterations) throws NoBracketingException {
        if (function == null) {
            throw new NullArgumentException(LocalizedFormats.FUNCTION, new Object[0]);
        }
        if (q <= 0.0) {
            throw new NotStrictlyPositiveException(q);
        }
        if (maximumIterations <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.INVALID_MAX_ITERATIONS, maximumIterations);
        }
        UnivariateSolverUtils.verifySequence(lowerBound, initial, upperBound);
        double a2 = initial;
        double b2 = initial;
        double fa = Double.NaN;
        double fb = Double.NaN;
        double delta = 0.0;
        for (int numIterations = 0; numIterations < maximumIterations && (a2 > lowerBound || b2 < upperBound); ++numIterations) {
            double previousA = a2;
            double previousFa = fa;
            double previousB = b2;
            double previousFb = fb;
            delta = r * delta + q;
            a2 = FastMath.max(initial - delta, lowerBound);
            b2 = FastMath.min(initial + delta, upperBound);
            fa = function.value(a2);
            fb = function.value(b2);
            if (numIterations == 0) {
                if (!(fa * fb <= 0.0)) continue;
                return new double[]{a2, b2};
            }
            if (fa * previousFa <= 0.0) {
                return new double[]{a2, previousA};
            }
            if (!(fb * previousFb <= 0.0)) continue;
            return new double[]{previousB, b2};
        }
        throw new NoBracketingException(a2, b2, fa, fb);
    }

    public static double midpoint(double a2, double b2) {
        return (a2 + b2) * 0.5;
    }

    public static boolean isBracketing(UnivariateFunction function, double lower2, double upper2) throws NullArgumentException {
        if (function == null) {
            throw new NullArgumentException(LocalizedFormats.FUNCTION, new Object[0]);
        }
        double fLo = function.value(lower2);
        double fHi = function.value(upper2);
        return fLo >= 0.0 && fHi <= 0.0 || fLo <= 0.0 && fHi >= 0.0;
    }

    public static boolean isSequence(double start, double mid, double end) {
        return start < mid && mid < end;
    }

    public static void verifyInterval(double lower2, double upper2) throws NumberIsTooLargeException {
        if (lower2 >= upper2) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.ENDPOINTS_NOT_AN_INTERVAL, (Number)lower2, upper2, false);
        }
    }

    public static void verifySequence(double lower2, double initial, double upper2) throws NumberIsTooLargeException {
        UnivariateSolverUtils.verifyInterval(lower2, initial);
        UnivariateSolverUtils.verifyInterval(initial, upper2);
    }

    public static void verifyBracketing(UnivariateFunction function, double lower2, double upper2) throws NullArgumentException, NoBracketingException {
        if (function == null) {
            throw new NullArgumentException(LocalizedFormats.FUNCTION, new Object[0]);
        }
        UnivariateSolverUtils.verifyInterval(lower2, upper2);
        if (!UnivariateSolverUtils.isBracketing(function, lower2, upper2)) {
            throw new NoBracketingException(lower2, upper2, function.value(lower2), function.value(upper2));
        }
    }
}

