/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ml.neuralnet;

import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.function.Constant;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.distribution.UniformRealDistribution;
import org.apache.commons.math3.ml.neuralnet.FeatureInitializer;
import org.apache.commons.math3.random.RandomGenerator;

public class FeatureInitializerFactory {
    private FeatureInitializerFactory() {
    }

    public static FeatureInitializer uniform(RandomGenerator rng, double min2, double max2) {
        return FeatureInitializerFactory.randomize(new UniformRealDistribution(rng, min2, max2), FeatureInitializerFactory.function(new Constant(0.0), 0.0, 0.0));
    }

    public static FeatureInitializer uniform(double min2, double max2) {
        return FeatureInitializerFactory.randomize(new UniformRealDistribution(min2, max2), FeatureInitializerFactory.function(new Constant(0.0), 0.0, 0.0));
    }

    public static FeatureInitializer function(final UnivariateFunction f2, final double init, final double inc) {
        return new FeatureInitializer(){
            private double arg;
            {
                this.arg = init;
            }

            public double value() {
                double result2 = f2.value(this.arg);
                this.arg += inc;
                return result2;
            }
        };
    }

    public static FeatureInitializer randomize(final RealDistribution random2, final FeatureInitializer orig) {
        return new FeatureInitializer(){

            public double value() {
                return orig.value() + random2.sample();
            }
        };
    }
}

