/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.commons.math3.ode.AbstractIntegrator;
import org.apache.commons.math3.ode.EquationsMapper;
import org.apache.commons.math3.ode.sampling.AbstractStepInterpolator;

abstract class RungeKuttaStepInterpolator
extends AbstractStepInterpolator {
    protected double[] previousState;
    protected double[][] yDotK;
    protected AbstractIntegrator integrator;

    protected RungeKuttaStepInterpolator() {
        this.previousState = null;
        this.yDotK = null;
        this.integrator = null;
    }

    public RungeKuttaStepInterpolator(RungeKuttaStepInterpolator interpolator) {
        super(interpolator);
        if (interpolator.currentState != null) {
            this.previousState = (double[])interpolator.previousState.clone();
            this.yDotK = new double[interpolator.yDotK.length][];
            for (int k2 = 0; k2 < interpolator.yDotK.length; ++k2) {
                this.yDotK[k2] = (double[])interpolator.yDotK[k2].clone();
            }
        } else {
            this.previousState = null;
            this.yDotK = null;
        }
        this.integrator = null;
    }

    public void reinitialize(AbstractIntegrator rkIntegrator, double[] y, double[][] yDotArray, boolean forward, EquationsMapper primaryMapper, EquationsMapper[] secondaryMappers) {
        this.reinitialize(y, forward, primaryMapper, secondaryMappers);
        this.previousState = null;
        this.yDotK = yDotArray;
        this.integrator = rkIntegrator;
    }

    public void shift() {
        this.previousState = (double[])this.currentState.clone();
        super.shift();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeBaseExternal(out);
        int n2 = this.currentState == null ? -1 : this.currentState.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            out.writeDouble(this.previousState[i2]);
        }
        int kMax = this.yDotK == null ? -1 : this.yDotK.length;
        out.writeInt(kMax);
        for (int k2 = 0; k2 < kMax; ++k2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                out.writeDouble(this.yDotK[k2][i3]);
            }
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int n2;
        double t = this.readBaseExternal(in);
        int n3 = n2 = this.currentState == null ? -1 : this.currentState.length;
        if (n2 < 0) {
            this.previousState = null;
        } else {
            this.previousState = new double[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                this.previousState[i2] = in.readDouble();
            }
        }
        int kMax = in.readInt();
        this.yDotK = kMax < 0 ? (double[][])null : (double[][])new double[kMax][];
        for (int k2 = 0; k2 < kMax; ++k2) {
            this.yDotK[k2] = n2 < 0 ? null : new double[n2];
            for (int i3 = 0; i3 < n2; ++i3) {
                this.yDotK[k2][i3] = in.readDouble();
            }
        }
        this.integrator = null;
        if (this.currentState != null) {
            this.setInterpolatedTime(t);
        } else {
            this.interpolatedTime = t;
        }
    }
}

