/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optimization.direct;

import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.function.Logit;
import org.apache.commons.math3.analysis.function.Sigmoid;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathUtils;

@Deprecated
public class MultivariateFunctionMappingAdapter
implements MultivariateFunction {
    private final MultivariateFunction bounded;
    private final Mapper[] mappers;

    public MultivariateFunctionMappingAdapter(MultivariateFunction bounded, double[] lower2, double[] upper2) {
        int i2;
        MathUtils.checkNotNull(lower2);
        MathUtils.checkNotNull(upper2);
        if (lower2.length != upper2.length) {
            throw new DimensionMismatchException(lower2.length, upper2.length);
        }
        for (i2 = 0; i2 < lower2.length; ++i2) {
            if (upper2[i2] >= lower2[i2]) continue;
            throw new NumberIsTooSmallException(upper2[i2], (Number)lower2[i2], true);
        }
        this.bounded = bounded;
        this.mappers = new Mapper[lower2.length];
        for (i2 = 0; i2 < this.mappers.length; ++i2) {
            if (Double.isInfinite(lower2[i2])) {
                if (Double.isInfinite(upper2[i2])) {
                    this.mappers[i2] = new NoBoundsMapper();
                    continue;
                }
                this.mappers[i2] = new UpperBoundMapper(upper2[i2]);
                continue;
            }
            this.mappers[i2] = Double.isInfinite(upper2[i2]) ? new LowerBoundMapper(lower2[i2]) : new LowerUpperBoundMapper(lower2[i2], upper2[i2]);
        }
    }

    public double[] unboundedToBounded(double[] point) {
        double[] mapped = new double[this.mappers.length];
        for (int i2 = 0; i2 < this.mappers.length; ++i2) {
            mapped[i2] = this.mappers[i2].unboundedToBounded(point[i2]);
        }
        return mapped;
    }

    public double[] boundedToUnbounded(double[] point) {
        double[] mapped = new double[this.mappers.length];
        for (int i2 = 0; i2 < this.mappers.length; ++i2) {
            mapped[i2] = this.mappers[i2].boundedToUnbounded(point[i2]);
        }
        return mapped;
    }

    public double value(double[] point) {
        return this.bounded.value(this.unboundedToBounded(point));
    }

    private static class LowerUpperBoundMapper
    implements Mapper {
        private final UnivariateFunction boundingFunction;
        private final UnivariateFunction unboundingFunction;

        public LowerUpperBoundMapper(double lower2, double upper2) {
            this.boundingFunction = new Sigmoid(lower2, upper2);
            this.unboundingFunction = new Logit(lower2, upper2);
        }

        public double unboundedToBounded(double y) {
            return this.boundingFunction.value(y);
        }

        public double boundedToUnbounded(double x) {
            return this.unboundingFunction.value(x);
        }
    }

    private static class UpperBoundMapper
    implements Mapper {
        private final double upper;

        public UpperBoundMapper(double upper2) {
            this.upper = upper2;
        }

        public double unboundedToBounded(double y) {
            return this.upper - FastMath.exp(-y);
        }

        public double boundedToUnbounded(double x) {
            return -FastMath.log(this.upper - x);
        }
    }

    private static class LowerBoundMapper
    implements Mapper {
        private final double lower;

        public LowerBoundMapper(double lower2) {
            this.lower = lower2;
        }

        public double unboundedToBounded(double y) {
            return this.lower + FastMath.exp(y);
        }

        public double boundedToUnbounded(double x) {
            return FastMath.log(x - this.lower);
        }
    }

    private static class NoBoundsMapper
    implements Mapper {
        public double unboundedToBounded(double y) {
            return y;
        }

        public double boundedToUnbounded(double x) {
            return x;
        }
    }

    private static interface Mapper {
        public double unboundedToBounded(double var1);

        public double boundedToUnbounded(double var1);
    }
}

