/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.clustering;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.commons.math3.exception.ConvergenceException;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.stat.clustering.Cluster;
import org.apache.commons.math3.stat.clustering.Clusterable;
import org.apache.commons.math3.stat.descriptive.moment.Variance;
import org.apache.commons.math3.util.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class KMeansPlusPlusClusterer<T extends Clusterable<T>> {
    private final Random random;
    private final EmptyClusterStrategy emptyStrategy;

    public KMeansPlusPlusClusterer(Random random2) {
        this(random2, EmptyClusterStrategy.LARGEST_VARIANCE);
    }

    public KMeansPlusPlusClusterer(Random random2, EmptyClusterStrategy emptyStrategy) {
        this.random = random2;
        this.emptyStrategy = emptyStrategy;
    }

    public List<Cluster<T>> cluster(Collection<T> points, int k2, int numTrials, int maxIterationsPerTrial) throws MathIllegalArgumentException, ConvergenceException {
        List<Cluster<T>> best = null;
        double bestVarianceSum = Double.POSITIVE_INFINITY;
        for (int i2 = 0; i2 < numTrials; ++i2) {
            List<Cluster<T>> clusters = this.cluster(points, k2, maxIterationsPerTrial);
            double varianceSum = 0.0;
            for (Cluster<T> cluster : clusters) {
                if (cluster.getPoints().isEmpty()) continue;
                T center = cluster.getCenter();
                Variance stat = new Variance();
                for (Clusterable point : cluster.getPoints()) {
                    stat.increment(point.distanceFrom(center));
                }
                varianceSum += stat.getResult();
            }
            if (!(varianceSum <= bestVarianceSum)) continue;
            best = clusters;
            bestVarianceSum = varianceSum;
        }
        return best;
    }

    public List<Cluster<T>> cluster(Collection<T> points, int k2, int maxIterations) throws MathIllegalArgumentException, ConvergenceException {
        MathUtils.checkNotNull(points);
        if (points.size() < k2) {
            throw new NumberIsTooSmallException(points.size(), (Number)k2, false);
        }
        List<Cluster<T>> clusters = KMeansPlusPlusClusterer.chooseInitialCenters(points, k2, this.random);
        int[] assignments = new int[points.size()];
        KMeansPlusPlusClusterer.assignPointsToClusters(clusters, points, assignments);
        int max2 = maxIterations < 0 ? Integer.MAX_VALUE : maxIterations;
        for (int count = 0; count < max2; ++count) {
            boolean emptyCluster = false;
            ArrayList<Cluster<T>> newClusters = new ArrayList<Cluster<T>>();
            for (Cluster<T> cluster : clusters) {
                Clusterable newCenter;
                if (cluster.getPoints().isEmpty()) {
                    switch (this.emptyStrategy) {
                        case LARGEST_VARIANCE: {
                            newCenter = this.getPointFromLargestVarianceCluster(clusters);
                            break;
                        }
                        case LARGEST_POINTS_NUMBER: {
                            newCenter = this.getPointFromLargestNumberCluster(clusters);
                            break;
                        }
                        case FARTHEST_POINT: {
                            newCenter = this.getFarthestPoint(clusters);
                            break;
                        }
                        default: {
                            throw new ConvergenceException(LocalizedFormats.EMPTY_CLUSTER_IN_K_MEANS, new Object[0]);
                        }
                    }
                    emptyCluster = true;
                } else {
                    newCenter = (Clusterable)cluster.getCenter().centroidOf(cluster.getPoints());
                }
                newClusters.add(new Cluster<Clusterable>(newCenter));
            }
            int changes = KMeansPlusPlusClusterer.assignPointsToClusters(newClusters, points, assignments);
            clusters = newClusters;
            if (changes != 0 || emptyCluster) continue;
            return clusters;
        }
        return clusters;
    }

    private static <T extends Clusterable<T>> int assignPointsToClusters(List<Cluster<T>> clusters, Collection<T> points, int[] assignments) {
        int assignedDifferently = 0;
        int pointIndex = 0;
        for (Clusterable p : points) {
            int clusterIndex = KMeansPlusPlusClusterer.getNearestCluster(clusters, p);
            if (clusterIndex != assignments[pointIndex]) {
                ++assignedDifferently;
            }
            Cluster<Clusterable> cluster = clusters.get(clusterIndex);
            cluster.addPoint(p);
            assignments[pointIndex++] = clusterIndex;
        }
        return assignedDifferently;
    }

    private static <T extends Clusterable<T>> List<Cluster<T>> chooseInitialCenters(Collection<T> points, int k2, Random random2) {
        List<T> pointList = Collections.unmodifiableList(new ArrayList<T>(points));
        int numPoints = pointList.size();
        boolean[] taken = new boolean[numPoints];
        ArrayList<Cluster<T>> resultSet = new ArrayList<Cluster<T>>();
        int firstPointIndex = random2.nextInt(numPoints);
        Clusterable firstPoint = (Clusterable)pointList.get(firstPointIndex);
        resultSet.add(new Cluster<Clusterable>(firstPoint));
        taken[firstPointIndex] = true;
        double[] minDistSquared = new double[numPoints];
        for (int i2 = 0; i2 < numPoints; ++i2) {
            if (i2 == firstPointIndex) continue;
            double d2 = firstPoint.distanceFrom(pointList.get(i2));
            minDistSquared[i2] = d2 * d2;
        }
        while (resultSet.size() < k2) {
            int i3;
            double distSqSum = 0.0;
            for (int i4 = 0; i4 < numPoints; ++i4) {
                if (taken[i4]) continue;
                distSqSum += minDistSquared[i4];
            }
            double r = random2.nextDouble() * distSqSum;
            int nextPointIndex = -1;
            double sum = 0.0;
            for (i3 = 0; i3 < numPoints; ++i3) {
                if (taken[i3] || !((sum += minDistSquared[i3]) >= r)) continue;
                nextPointIndex = i3;
                break;
            }
            if (nextPointIndex == -1) {
                for (i3 = numPoints - 1; i3 >= 0; --i3) {
                    if (taken[i3]) continue;
                    nextPointIndex = i3;
                    break;
                }
            }
            if (nextPointIndex < 0) break;
            Clusterable p = (Clusterable)pointList.get(nextPointIndex);
            resultSet.add(new Cluster<Clusterable>(p));
            taken[nextPointIndex] = true;
            if (resultSet.size() >= k2) continue;
            for (int j2 = 0; j2 < numPoints; ++j2) {
                double d3;
                double d2;
                if (taken[j2] || !((d2 = (d3 = p.distanceFrom(pointList.get(j2))) * d3) < minDistSquared[j2])) continue;
                minDistSquared[j2] = d2;
            }
        }
        return resultSet;
    }

    private T getPointFromLargestVarianceCluster(Collection<Cluster<T>> clusters) throws ConvergenceException {
        double maxVariance = Double.NEGATIVE_INFINITY;
        Cluster<T> selected = null;
        for (Cluster<T> cluster : clusters) {
            if (cluster.getPoints().isEmpty()) continue;
            T center = cluster.getCenter();
            Variance stat = new Variance();
            for (Clusterable point : cluster.getPoints()) {
                stat.increment(point.distanceFrom(center));
            }
            double variance = stat.getResult();
            if (!(variance > maxVariance)) continue;
            maxVariance = variance;
            selected = cluster;
        }
        if (selected == null) {
            throw new ConvergenceException(LocalizedFormats.EMPTY_CLUSTER_IN_K_MEANS, new Object[0]);
        }
        List selectedPoints = selected.getPoints();
        return (T)((Clusterable)selectedPoints.remove(this.random.nextInt(selectedPoints.size())));
    }

    private T getPointFromLargestNumberCluster(Collection<Cluster<T>> clusters) throws ConvergenceException {
        int maxNumber = 0;
        Cluster<T> selected = null;
        for (Cluster<T> cluster : clusters) {
            int number = cluster.getPoints().size();
            if (number <= maxNumber) continue;
            maxNumber = number;
            selected = cluster;
        }
        if (selected == null) {
            throw new ConvergenceException(LocalizedFormats.EMPTY_CLUSTER_IN_K_MEANS, new Object[0]);
        }
        List selectedPoints = selected.getPoints();
        return (T)((Clusterable)selectedPoints.remove(this.random.nextInt(selectedPoints.size())));
    }

    private T getFarthestPoint(Collection<Cluster<T>> clusters) throws ConvergenceException {
        double maxDistance = Double.NEGATIVE_INFINITY;
        Cluster<T> selectedCluster = null;
        int selectedPoint = -1;
        for (Cluster<T> cluster : clusters) {
            T center = cluster.getCenter();
            List<T> points = cluster.getPoints();
            for (int i2 = 0; i2 < points.size(); ++i2) {
                double distance = ((Clusterable)points.get(i2)).distanceFrom(center);
                if (!(distance > maxDistance)) continue;
                maxDistance = distance;
                selectedCluster = cluster;
                selectedPoint = i2;
            }
        }
        if (selectedCluster == null) {
            throw new ConvergenceException(LocalizedFormats.EMPTY_CLUSTER_IN_K_MEANS, new Object[0]);
        }
        return (T)((Clusterable)selectedCluster.getPoints().remove(selectedPoint));
    }

    private static <T extends Clusterable<T>> int getNearestCluster(Collection<Cluster<T>> clusters, T point) {
        double minDistance = Double.MAX_VALUE;
        int clusterIndex = 0;
        int minCluster = 0;
        for (Cluster<T> c2 : clusters) {
            double distance = point.distanceFrom(c2.getCenter());
            if (distance < minDistance) {
                minDistance = distance;
                minCluster = clusterIndex;
            }
            ++clusterIndex;
        }
        return minCluster;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EmptyClusterStrategy {
        LARGEST_VARIANCE,
        LARGEST_POINTS_NUMBER,
        FARTHEST_POINT,
        ERROR;

    }
}

