/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.inference;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.math3.Field;
import org.apache.commons.math3.FieldElement;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.exception.InsufficientDataException;
import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.TooManyIterationsException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.fraction.BigFraction;
import org.apache.commons.math3.fraction.BigFractionField;
import org.apache.commons.math3.fraction.FractionConversionException;
import org.apache.commons.math3.linear.Array2DRowFieldMatrix;
import org.apache.commons.math3.linear.FieldMatrix;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;
import org.apache.commons.math3.util.CombinatoricsUtils;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathArrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KolmogorovSmirnovTest {
    protected static final int MAXIMUM_PARTIAL_SUM_COUNT = 100000;
    protected static final double KS_SUM_CAUCHY_CRITERION = 1.0E-20;
    protected static final double PG_SUM_RELATIVE_ERROR = 1.0E-10;
    protected static final int SMALL_SAMPLE_PRODUCT = 200;
    protected static final int LARGE_SAMPLE_PRODUCT = 10000;
    protected static final int MONTE_CARLO_ITERATIONS = 1000000;
    private final RandomGenerator rng;

    public KolmogorovSmirnovTest() {
        this.rng = new Well19937c();
    }

    public KolmogorovSmirnovTest(RandomGenerator rng) {
        this.rng = rng;
    }

    public double kolmogorovSmirnovTest(RealDistribution distribution, double[] data, boolean exact) {
        return 1.0 - this.cdf(this.kolmogorovSmirnovStatistic(distribution, data), data.length, exact);
    }

    public double kolmogorovSmirnovStatistic(RealDistribution distribution, double[] data) {
        this.checkArray(data);
        int n2 = data.length;
        double nd = n2;
        double[] dataCopy = new double[n2];
        System.arraycopy(data, 0, dataCopy, 0, n2);
        Arrays.sort(dataCopy);
        double d2 = 0.0;
        for (int i2 = 1; i2 <= n2; ++i2) {
            double yi = distribution.cumulativeProbability(dataCopy[i2 - 1]);
            double currD = FastMath.max(yi - (double)(i2 - 1) / nd, (double)i2 / nd - yi);
            if (!(currD > d2)) continue;
            d2 = currD;
        }
        return d2;
    }

    public double kolmogorovSmirnovTest(double[] x, double[] y, boolean strict) {
        long lengthProduct = (long)x.length * (long)y.length;
        if (lengthProduct < 200L) {
            return this.exactP(this.kolmogorovSmirnovStatistic(x, y), x.length, y.length, strict);
        }
        if (lengthProduct < 10000L) {
            return this.monteCarloP(this.kolmogorovSmirnovStatistic(x, y), x.length, y.length, strict, 1000000);
        }
        return this.approximateP(this.kolmogorovSmirnovStatistic(x, y), x.length, y.length);
    }

    public double kolmogorovSmirnovTest(double[] x, double[] y) {
        return this.kolmogorovSmirnovTest(x, y, true);
    }

    public double kolmogorovSmirnovStatistic(double[] x, double[] y) {
        double curD;
        int i2;
        this.checkArray(x);
        this.checkArray(y);
        double[] sx = MathArrays.copyOf(x);
        double[] sy = MathArrays.copyOf(y);
        Arrays.sort(sx);
        Arrays.sort(sy);
        int n2 = sx.length;
        int m2 = sy.length;
        double supD = 0.0;
        for (i2 = 0; i2 < n2; ++i2) {
            double cdf_x = ((double)i2 + 1.0) / (double)n2;
            int yIndex = Arrays.binarySearch(sy, sx[i2]);
            double cdf_y = yIndex >= 0 ? ((double)yIndex + 1.0) / (double)m2 : ((double)(-yIndex) - 1.0) / (double)m2;
            curD = FastMath.abs(cdf_x - cdf_y);
            if (!(curD > supD)) continue;
            supD = curD;
        }
        for (i2 = 0; i2 < m2; ++i2) {
            double cdf_y = ((double)i2 + 1.0) / (double)m2;
            int xIndex = Arrays.binarySearch(sx, sy[i2]);
            double cdf_x = xIndex >= 0 ? ((double)xIndex + 1.0) / (double)n2 : ((double)(-xIndex) - 1.0) / (double)n2;
            curD = FastMath.abs(cdf_x - cdf_y);
            if (!(curD > supD)) continue;
            supD = curD;
        }
        return supD;
    }

    public double kolmogorovSmirnovTest(RealDistribution distribution, double[] data) {
        return this.kolmogorovSmirnovTest(distribution, data, false);
    }

    public boolean kolmogorovSmirnovTest(RealDistribution distribution, double[] data, double alpha) {
        if (alpha <= 0.0 || alpha > 0.5) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.OUT_OF_BOUND_SIGNIFICANCE_LEVEL, (Number)alpha, 0, 0.5);
        }
        return this.kolmogorovSmirnovTest(distribution, data) < alpha;
    }

    public double cdf(double d2, int n2) throws MathArithmeticException {
        return this.cdf(d2, n2, false);
    }

    public double cdfExact(double d2, int n2) throws MathArithmeticException {
        return this.cdf(d2, n2, true);
    }

    public double cdf(double d2, int n2, boolean exact) throws MathArithmeticException {
        double ninv = 1.0 / (double)n2;
        double ninvhalf = 0.5 * ninv;
        if (d2 <= ninvhalf) {
            return 0.0;
        }
        if (ninvhalf < d2 && d2 <= ninv) {
            double res = 1.0;
            double f2 = 2.0 * d2 - ninv;
            for (int i2 = 1; i2 <= n2; ++i2) {
                res *= (double)i2 * f2;
            }
            return res;
        }
        if (1.0 - ninv <= d2 && d2 < 1.0) {
            return 1.0 - 2.0 * Math.pow(1.0 - d2, n2);
        }
        if (1.0 <= d2) {
            return 1.0;
        }
        if (exact) {
            return this.exactK(d2, n2);
        }
        if (n2 <= 140) {
            return this.roundedK(d2, n2);
        }
        return this.pelzGood(d2, n2);
    }

    private double exactK(double d2, int n2) throws MathArithmeticException {
        int k2 = (int)Math.ceil((double)n2 * d2);
        FieldMatrix<BigFraction> H = this.createExactH(d2, n2);
        FieldMatrix<BigFraction> Hpower = H.power(n2);
        BigFraction pFrac = Hpower.getEntry(k2 - 1, k2 - 1);
        for (int i2 = 1; i2 <= n2; ++i2) {
            pFrac = pFrac.multiply(i2).divide(n2);
        }
        return pFrac.bigDecimalValue(20, 4).doubleValue();
    }

    private double roundedK(double d2, int n2) {
        int k2 = (int)Math.ceil((double)n2 * d2);
        RealMatrix H = this.createRoundedH(d2, n2);
        RealMatrix Hpower = H.power(n2);
        double pFrac = Hpower.getEntry(k2 - 1, k2 - 1);
        for (int i2 = 1; i2 <= n2; ++i2) {
            pFrac *= (double)i2 / (double)n2;
        }
        return pFrac;
    }

    public double pelzGood(double d2, int n2) {
        int k2;
        double sqrtN = FastMath.sqrt(n2);
        double z = d2 * sqrtN;
        double z2 = d2 * d2 * (double)n2;
        double z4 = z2 * z2;
        double z6 = z4 * z2;
        double z8 = z4 * z4;
        double ret = 0.0;
        double sum = 0.0;
        double increment = 0.0;
        double kTerm = 0.0;
        double z2Term = Math.PI * Math.PI / (8.0 * z2);
        for (k2 = 1; k2 < 100000 && !((increment = FastMath.exp(-z2Term * (kTerm = (double)(2 * k2 - 1)) * kTerm)) <= 1.0E-10 * (sum += increment)); ++k2) {
        }
        if (k2 == 100000) {
            throw new TooManyIterationsException(100000);
        }
        ret = sum * FastMath.sqrt(Math.PI * 2) / z;
        double twoZ2 = 2.0 * z2;
        sum = 0.0;
        kTerm = 0.0;
        double kTerm2 = 0.0;
        for (k2 = 0; k2 < 100000; ++k2) {
            kTerm = (double)k2 + 0.5;
            kTerm2 = kTerm * kTerm;
            increment = (Math.PI * Math.PI * kTerm2 - z2) * FastMath.exp(-9.869604401089358 * kTerm2 / twoZ2);
            if (FastMath.abs(increment) < 1.0E-10 * FastMath.abs(sum += increment)) break;
        }
        if (k2 == 100000) {
            throw new TooManyIterationsException(100000);
        }
        double sqrtHalfPi = FastMath.sqrt(1.5707963267948966);
        ret += sum * sqrtHalfPi / (3.0 * z4 * sqrtN);
        double z4Term = 2.0 * z4;
        double z6Term = 6.0 * z6;
        z2Term = 5.0 * z2;
        double pi4 = 97.40909103400243;
        sum = 0.0;
        kTerm = 0.0;
        kTerm2 = 0.0;
        for (k2 = 0; k2 < 100000; ++k2) {
            kTerm = (double)k2 + 0.5;
            kTerm2 = kTerm * kTerm;
            increment = (z6Term + z4Term + Math.PI * Math.PI * (z4Term - z2Term) * kTerm2 + 97.40909103400243 * (1.0 - twoZ2) * kTerm2 * kTerm2) * FastMath.exp(-9.869604401089358 * kTerm2 / twoZ2);
            if (FastMath.abs(increment) < 1.0E-10 * FastMath.abs(sum += increment)) break;
        }
        if (k2 == 100000) {
            throw new TooManyIterationsException(100000);
        }
        double sum2 = 0.0;
        kTerm2 = 0.0;
        for (k2 = 1; k2 < 100000; ++k2) {
            kTerm2 = k2 * k2;
            increment = Math.PI * Math.PI * kTerm2 * FastMath.exp(-9.869604401089358 * kTerm2 / twoZ2);
            if (FastMath.abs(increment) < 1.0E-10 * FastMath.abs(sum2 += increment)) break;
        }
        if (k2 == 100000) {
            throw new TooManyIterationsException(100000);
        }
        ret += sqrtHalfPi / (double)n2 * (sum / (36.0 * z2 * z2 * z2 * z) - sum2 / (18.0 * z2 * z));
        double pi6 = 961.3891935753043;
        sum = 0.0;
        double kTerm4 = 0.0;
        double kTerm6 = 0.0;
        for (k2 = 0; k2 < 100000; ++k2) {
            kTerm = (double)k2 + 0.5;
            kTerm2 = kTerm * kTerm;
            kTerm4 = kTerm2 * kTerm2;
            kTerm6 = kTerm4 * kTerm2;
            increment = (961.3891935753043 * kTerm6 * (5.0 - 30.0 * z2) + 97.40909103400243 * kTerm4 * (-60.0 * z2 + 212.0 * z4) + Math.PI * Math.PI * kTerm2 * (135.0 * z4 - 96.0 * z6) - 30.0 * z6 - 90.0 * z8) * FastMath.exp(-9.869604401089358 * kTerm2 / twoZ2);
            if (FastMath.abs(increment) < 1.0E-10 * FastMath.abs(sum += increment)) break;
        }
        if (k2 == 100000) {
            throw new TooManyIterationsException(100000);
        }
        sum2 = 0.0;
        for (k2 = 1; k2 < 100000; ++k2) {
            kTerm2 = k2 * k2;
            kTerm4 = kTerm2 * kTerm2;
            increment = (-97.40909103400243 * kTerm4 + 29.608813203268074 * kTerm2 * z2) * FastMath.exp(-9.869604401089358 * kTerm2 / twoZ2);
            if (FastMath.abs(increment) < 1.0E-10 * FastMath.abs(sum2 += increment)) break;
        }
        if (k2 == 100000) {
            throw new TooManyIterationsException(100000);
        }
        return ret + sqrtHalfPi / (sqrtN * (double)n2) * (sum / (3240.0 * z6 * z4) + sum2 / (108.0 * z6));
    }

    private FieldMatrix<BigFraction> createExactH(double d2, int n2) throws NumberIsTooLargeException, FractionConversionException {
        int i2;
        int k2 = (int)Math.ceil((double)n2 * d2);
        int m2 = 2 * k2 - 1;
        double hDouble = (double)k2 - (double)n2 * d2;
        if (hDouble >= 1.0) {
            throw new NumberIsTooLargeException(hDouble, (Number)1.0, false);
        }
        BigFraction h2 = null;
        try {
            h2 = new BigFraction(hDouble, 1.0E-20, 10000);
        }
        catch (FractionConversionException e1) {
            try {
                h2 = new BigFraction(hDouble, 1.0E-10, 10000);
            }
            catch (FractionConversionException e2) {
                h2 = new BigFraction(hDouble, 1.0E-5, 10000);
            }
        }
        FieldElement[][] Hdata = new BigFraction[m2][m2];
        for (int i3 = 0; i3 < m2; ++i3) {
            for (int j2 = 0; j2 < m2; ++j2) {
                Hdata[i3][j2] = i3 - j2 + 1 < 0 ? BigFraction.ZERO : BigFraction.ONE;
            }
        }
        BigFraction[] hPowers = new BigFraction[m2];
        hPowers[0] = h2;
        for (i2 = 1; i2 < m2; ++i2) {
            hPowers[i2] = h2.multiply(hPowers[i2 - 1]);
        }
        for (i2 = 0; i2 < m2; ++i2) {
            Hdata[i2][0] = Hdata[i2][0].subtract(hPowers[i2]);
            Hdata[m2 - 1][i2] = ((BigFraction)Hdata[m2 - 1][i2]).subtract(hPowers[m2 - i2 - 1]);
        }
        if (h2.compareTo(BigFraction.ONE_HALF) == 1) {
            Hdata[m2 - 1][0] = ((BigFraction)Hdata[m2 - 1][0]).add(h2.multiply(2).subtract(1).pow(m2));
        }
        for (i2 = 0; i2 < m2; ++i2) {
            for (int j3 = 0; j3 < i2 + 1; ++j3) {
                if (i2 - j3 + 1 <= 0) continue;
                for (int g2 = 2; g2 <= i2 - j3 + 1; ++g2) {
                    Hdata[i2][j3] = ((BigFraction)Hdata[i2][j3]).divide(g2);
                }
            }
        }
        return new Array2DRowFieldMatrix((Field)BigFractionField.getInstance(), Hdata);
    }

    private RealMatrix createRoundedH(double d2, int n2) throws NumberIsTooLargeException {
        int i2;
        int k2 = (int)Math.ceil((double)n2 * d2);
        int m2 = 2 * k2 - 1;
        double h2 = (double)k2 - (double)n2 * d2;
        if (h2 >= 1.0) {
            throw new NumberIsTooLargeException(h2, (Number)1.0, false);
        }
        double[][] Hdata = new double[m2][m2];
        for (int i3 = 0; i3 < m2; ++i3) {
            for (int j2 = 0; j2 < m2; ++j2) {
                Hdata[i3][j2] = i3 - j2 + 1 < 0 ? 0.0 : 1.0;
            }
        }
        double[] hPowers = new double[m2];
        hPowers[0] = h2;
        for (i2 = 1; i2 < m2; ++i2) {
            hPowers[i2] = h2 * hPowers[i2 - 1];
        }
        for (i2 = 0; i2 < m2; ++i2) {
            Hdata[i2][0] = Hdata[i2][0] - hPowers[i2];
            double[] dArray = Hdata[m2 - 1];
            int n3 = i2;
            dArray[n3] = dArray[n3] - hPowers[m2 - i2 - 1];
        }
        if (Double.compare(h2, 0.5) > 0) {
            double[] dArray = Hdata[m2 - 1];
            dArray[0] = dArray[0] + FastMath.pow(2.0 * h2 - 1.0, m2);
        }
        for (i2 = 0; i2 < m2; ++i2) {
            for (int j3 = 0; j3 < i2 + 1; ++j3) {
                if (i2 - j3 + 1 <= 0) continue;
                for (int g2 = 2; g2 <= i2 - j3 + 1; ++g2) {
                    double[] dArray = Hdata[i2];
                    int n4 = j3;
                    dArray[n4] = dArray[n4] / (double)g2;
                }
            }
        }
        return MatrixUtils.createRealMatrix(Hdata);
    }

    private void checkArray(double[] array) {
        if (array == null) {
            throw new NullArgumentException(LocalizedFormats.NULL_NOT_ALLOWED, new Object[0]);
        }
        if (array.length < 2) {
            throw new InsufficientDataException(LocalizedFormats.INSUFFICIENT_OBSERVED_POINTS_IN_SAMPLE, array.length, 2);
        }
    }

    public double ksSum(double t, double tolerance, int maxIterations) {
        long i2;
        double x = -2.0 * t * t;
        int sign = -1;
        double partialSum = 0.5;
        double delta = 1.0;
        for (i2 = 1L; delta > tolerance && i2 < (long)maxIterations; ++i2) {
            delta = FastMath.exp(x * (double)i2 * (double)i2);
            partialSum += (double)sign * delta;
            sign *= -1;
        }
        if (i2 == (long)maxIterations) {
            throw new TooManyIterationsException(maxIterations);
        }
        return partialSum * 2.0;
    }

    public double exactP(double d2, int n2, int m2, boolean strict) {
        Iterator<int[]> combinationsIterator = CombinatoricsUtils.combinationsIterator(n2 + m2, n2);
        long tail = 0L;
        double[] nSet = new double[n2];
        double[] mSet = new double[m2];
        while (combinationsIterator.hasNext()) {
            int[] nSetI = combinationsIterator.next();
            int j2 = 0;
            int k2 = 0;
            for (int i2 = 0; i2 < n2 + m2; ++i2) {
                if (j2 < n2 && nSetI[j2] == i2) {
                    nSet[j2++] = i2;
                    continue;
                }
                mSet[k2++] = i2;
            }
            double curD = this.kolmogorovSmirnovStatistic(nSet, mSet);
            if (curD > d2) {
                ++tail;
                continue;
            }
            if (curD != d2 || strict) continue;
            ++tail;
        }
        return (double)tail / (double)CombinatoricsUtils.binomialCoefficient(n2 + m2, n2);
    }

    public double approximateP(double d2, int n2, int m2) {
        double dm = m2;
        double dn = n2;
        return 1.0 - this.ksSum(d2 * FastMath.sqrt(dm * dn / (dm + dn)), 1.0E-20, 100000);
    }

    public double monteCarloP(double d2, int n2, int m2, boolean strict, int iterations) {
        int[] nPlusMSet = MathArrays.natural(m2 + n2);
        double[] nSet = new double[n2];
        double[] mSet = new double[m2];
        int tail = 0;
        for (int i2 = 0; i2 < iterations; ++i2) {
            this.copyPartition(nSet, mSet, nPlusMSet, n2, m2);
            double curD = this.kolmogorovSmirnovStatistic(nSet, mSet);
            if (curD > d2) {
                ++tail;
            } else if (curD == d2 && !strict) {
                ++tail;
            }
            MathArrays.shuffle(nPlusMSet, this.rng);
            Arrays.sort(nPlusMSet, 0, n2);
        }
        return (double)tail / (double)iterations;
    }

    private void copyPartition(double[] nSet, double[] mSet, int[] nSetI, int n2, int m2) {
        int j2 = 0;
        int k2 = 0;
        for (int i2 = 0; i2 < n2 + m2; ++i2) {
            if (j2 < n2 && nSetI[j2] == i2) {
                nSet[j2++] = i2;
                continue;
            }
            mSet[k2++] = i2;
        }
    }
}

