/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net.ssl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import org.apache.logging.log4j.core.net.ssl.PasswordProvider;

class FilePasswordProvider
implements PasswordProvider {
    private final Path passwordPath;

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="The file name comes from a configuration option.")
    public FilePasswordProvider(String passwordFile) throws NoSuchFileException {
        this.passwordPath = Paths.get(passwordFile, new String[0]);
        if (!Files.exists(this.passwordPath, new LinkOption[0])) {
            throw new NoSuchFileException("PasswordFile '" + passwordFile + "' does not exist");
        }
    }

    @Override
    public char[] getPassword() {
        byte[] bytes = null;
        try {
            bytes = Files.readAllBytes(this.passwordPath);
            ByteBuffer bb = ByteBuffer.wrap(bytes);
            CharBuffer decoded = Charset.defaultCharset().decode(bb);
            char[] result2 = new char[decoded.limit()];
            decoded.get(result2, 0, result2.length);
            decoded.rewind();
            decoded.put(new char[result2.length]);
            char[] cArray = result2;
            return cArray;
        }
        catch (IOException e2) {
            throw new IllegalStateException("Could not read password from " + this.passwordPath + ": " + e2, e2);
        }
        finally {
            if (bytes != null) {
                Arrays.fill(bytes, (byte)0);
            }
        }
    }
}

