/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.util.List;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import org.apache.logging.log4j.core.pattern.PatternParser;
import org.apache.logging.log4j.util.EnglishEnums;
import org.apache.logging.log4j.util.PerformanceSensitive;
import org.apache.logging.log4j.util.StringBuilders;

@Plugin(name="encode", category="Converter")
@ConverterKeys(value={"enc", "encode"})
@PerformanceSensitive(value={"allocation"})
public final class EncodingPatternConverter
extends LogEventPatternConverter {
    private final List<PatternFormatter> formatters;
    private final EscapeFormat escapeFormat;

    private EncodingPatternConverter(List<PatternFormatter> formatters, EscapeFormat escapeFormat) {
        super("encode", "encode");
        this.formatters = formatters;
        this.escapeFormat = escapeFormat;
    }

    @Override
    public boolean handlesThrowable() {
        return this.formatters != null && this.formatters.stream().map(PatternFormatter::getConverter).anyMatch(LogEventPatternConverter::handlesThrowable);
    }

    public static EncodingPatternConverter newInstance(Configuration config, String[] options) {
        if (options.length > 2 || options.length == 0) {
            LOGGER.error("Incorrect number of options on escape. Expected 1 or 2, but received {}", (Object)options.length);
            return null;
        }
        if (options[0] == null) {
            LOGGER.error("No pattern supplied on escape");
            return null;
        }
        EscapeFormat escapeFormat = options.length < 2 ? EscapeFormat.HTML : EnglishEnums.valueOf(EscapeFormat.class, options[1], EscapeFormat.HTML);
        PatternParser parser = PatternLayout.createPatternParser(config);
        List<PatternFormatter> formatters = parser.parse(options[0]);
        return new EncodingPatternConverter(formatters, escapeFormat);
    }

    @Override
    public void format(LogEvent event, StringBuilder toAppendTo) {
        int start = toAppendTo.length();
        for (int i2 = 0; i2 < this.formatters.size(); ++i2) {
            this.formatters.get(i2).format(event, toAppendTo);
        }
        this.escapeFormat.escape(toAppendTo, start);
    }

    private static enum EscapeFormat {
        HTML{

            @Override
            void escape(StringBuilder toAppendTo, int start) {
                int i2;
                int origLength;
                int firstSpecialChar = origLength = toAppendTo.length();
                for (i2 = origLength - 1; i2 >= start; --i2) {
                    char c2 = toAppendTo.charAt(i2);
                    String escaped = this.escapeChar(c2);
                    if (escaped == null) continue;
                    firstSpecialChar = i2;
                    for (int j2 = 0; j2 < escaped.length() - 1; ++j2) {
                        toAppendTo.append(' ');
                    }
                }
                int j3 = toAppendTo.length();
                for (i2 = origLength - 1; i2 >= firstSpecialChar; --i2) {
                    char c3 = toAppendTo.charAt(i2);
                    String escaped = this.escapeChar(c3);
                    if (escaped == null) {
                        toAppendTo.setCharAt(--j3, c3);
                        continue;
                    }
                    toAppendTo.replace(j3 - escaped.length(), j3, escaped);
                    j3 -= escaped.length();
                }
            }

            private String escapeChar(char c2) {
                switch (c2) {
                    case '\r': {
                        return "\\r";
                    }
                    case '\n': {
                        return "\\n";
                    }
                    case '&': {
                        return "&amp;";
                    }
                    case '<': {
                        return "&lt;";
                    }
                    case '>': {
                        return "&gt;";
                    }
                    case '\"': {
                        return "&quot;";
                    }
                    case '\'': {
                        return "&apos;";
                    }
                    case '/': {
                        return "&#x2F;";
                    }
                }
                return null;
            }
        }
        ,
        JSON{

            @Override
            void escape(StringBuilder toAppendTo, int start) {
                StringBuilders.escapeJson(toAppendTo, start);
            }
        }
        ,
        CRLF{

            @Override
            void escape(StringBuilder toAppendTo, int start) {
                int i2;
                int origLength;
                int firstSpecialChar = origLength = toAppendTo.length();
                for (i2 = origLength - 1; i2 >= start; --i2) {
                    char c2 = toAppendTo.charAt(i2);
                    if (c2 != '\r' && c2 != '\n') continue;
                    firstSpecialChar = i2;
                    toAppendTo.append(' ');
                }
                int j2 = toAppendTo.length();
                block5: for (i2 = origLength - 1; i2 >= firstSpecialChar; --i2) {
                    char c3 = toAppendTo.charAt(i2);
                    switch (c3) {
                        case '\r': {
                            toAppendTo.setCharAt(--j2, 'r');
                            toAppendTo.setCharAt(--j2, '\\');
                            continue block5;
                        }
                        case '\n': {
                            toAppendTo.setCharAt(--j2, 'n');
                            toAppendTo.setCharAt(--j2, '\\');
                            continue block5;
                        }
                        default: {
                            toAppendTo.setCharAt(--j2, c3);
                        }
                    }
                }
            }
        }
        ,
        XML{

            @Override
            void escape(StringBuilder toAppendTo, int start) {
                StringBuilders.escapeXml(toAppendTo, start);
            }
        };


        abstract void escape(StringBuilder var1, int var2);
    }
}

