/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.message.AsynchronouslyFormattable;
import org.apache.logging.log4j.message.MapMessageJsonFormatter;
import org.apache.logging.log4j.message.ParameterFormatter;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.EnglishEnums;
import org.apache.logging.log4j.util.IndexedReadOnlyStringMap;
import org.apache.logging.log4j.util.IndexedStringMap;
import org.apache.logging.log4j.util.MultiFormatStringBuilderFormattable;
import org.apache.logging.log4j.util.PerformanceSensitive;
import org.apache.logging.log4j.util.SortedArrayStringMap;
import org.apache.logging.log4j.util.StringBuilders;
import org.apache.logging.log4j.util.TriConsumer;

@AsynchronouslyFormattable
@PerformanceSensitive(value={"allocation"})
public class MapMessage<M extends MapMessage<M, V>, V>
implements MultiFormatStringBuilderFormattable {
    private static final long serialVersionUID = -5031471831131487120L;
    private final IndexedStringMap data;

    public MapMessage() {
        this.data = new SortedArrayStringMap();
    }

    public MapMessage(int initialCapacity) {
        this.data = new SortedArrayStringMap(initialCapacity);
    }

    public MapMessage(Map<String, V> map) {
        this.data = new SortedArrayStringMap(map);
    }

    @Override
    public String[] getFormats() {
        return MapFormat.names();
    }

    @Override
    public Object[] getParameters() {
        Object[] result2 = new Object[this.data.size()];
        for (int i2 = 0; i2 < this.data.size(); ++i2) {
            result2[i2] = this.data.getValueAt(i2);
        }
        return result2;
    }

    @Override
    public String getFormat() {
        return "";
    }

    public Map<String, V> getData() {
        TreeMap result2 = new TreeMap();
        for (int i2 = 0; i2 < this.data.size(); ++i2) {
            result2.put(this.data.getKeyAt(i2), this.data.getValueAt(i2));
        }
        return Collections.unmodifiableMap(result2);
    }

    public IndexedReadOnlyStringMap getIndexedReadOnlyStringMap() {
        return this.data;
    }

    public void clear() {
        this.data.clear();
    }

    public boolean containsKey(String key) {
        return this.data.containsKey(key);
    }

    public void put(String candidateKey, String value) {
        if (value == null) {
            throw new IllegalArgumentException("No value provided for key " + candidateKey);
        }
        String key = this.toKey(candidateKey);
        this.validate(key, value);
        this.data.putValue(key, value);
    }

    public void putAll(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.data.putValue(entry.getKey(), entry.getValue());
        }
    }

    public String get(String key) {
        Object result2 = this.data.getValue(key);
        return ParameterFormatter.deepToString(result2);
    }

    public String remove(String key) {
        String result2 = this.get(key);
        this.data.remove(key);
        return result2;
    }

    public String asString() {
        return this.format(null, new StringBuilder()).toString();
    }

    public String asString(String format2) {
        try {
            return this.format(EnglishEnums.valueOf(MapFormat.class, format2), new StringBuilder()).toString();
        }
        catch (IllegalArgumentException ex) {
            return this.asString();
        }
    }

    public <CV> void forEach(BiConsumer<String, ? super CV> action) {
        this.data.forEach(action);
    }

    public <CV, S> void forEach(TriConsumer<String, ? super CV, S> action, S state) {
        this.data.forEach(action, state);
    }

    private StringBuilder format(MapFormat format2, StringBuilder sb) {
        if (format2 == null) {
            this.appendMap(sb);
        } else {
            switch (format2) {
                case XML: {
                    this.asXml(sb);
                    break;
                }
                case JSON: {
                    this.asJson(sb);
                    break;
                }
                case JAVA: {
                    this.asJava(sb);
                    break;
                }
                case JAVA_UNQUOTED: {
                    this.asJavaUnquoted(sb);
                    break;
                }
                default: {
                    this.appendMap(sb);
                }
            }
        }
        return sb;
    }

    public void asXml(StringBuilder sb) {
        sb.append("<Map>\n");
        for (int i2 = 0; i2 < this.data.size(); ++i2) {
            sb.append("  <Entry key=\"").append(this.data.getKeyAt(i2)).append("\">");
            int size = sb.length();
            ParameterFormatter.recursiveDeepToString(this.data.getValueAt(i2), sb);
            StringBuilders.escapeXml(sb, size);
            sb.append("</Entry>\n");
        }
        sb.append("</Map>");
    }

    @Override
    public String getFormattedMessage() {
        return this.asString();
    }

    @Override
    public String getFormattedMessage(String[] formats) {
        return this.format(this.getFormat(formats), new StringBuilder()).toString();
    }

    private MapFormat getFormat(String[] formats) {
        if (formats == null || formats.length == 0) {
            return null;
        }
        for (int i2 = 0; i2 < formats.length; ++i2) {
            MapFormat mapFormat = MapFormat.lookupIgnoreCase(formats[i2]);
            if (mapFormat == null) continue;
            return mapFormat;
        }
        return null;
    }

    protected void appendMap(StringBuilder sb) {
        for (int i2 = 0; i2 < this.data.size(); ++i2) {
            if (i2 > 0) {
                sb.append(' ');
            }
            sb.append(this.data.getKeyAt(i2)).append('=').append('\"');
            ParameterFormatter.recursiveDeepToString(this.data.getValueAt(i2), sb);
            sb.append('\"');
        }
    }

    protected void asJson(StringBuilder sb) {
        MapMessageJsonFormatter.format(sb, this.data);
    }

    protected void asJavaUnquoted(StringBuilder sb) {
        this.asJava(sb, false);
    }

    protected void asJava(StringBuilder sb) {
        this.asJava(sb, true);
    }

    private void asJava(StringBuilder sb, boolean quoted) {
        sb.append('{');
        for (int i2 = 0; i2 < this.data.size(); ++i2) {
            if (i2 > 0) {
                sb.append(", ");
            }
            sb.append(this.data.getKeyAt(i2)).append('=');
            if (quoted) {
                sb.append('\"');
            }
            ParameterFormatter.recursiveDeepToString(this.data.getValueAt(i2), sb);
            if (!quoted) continue;
            sb.append('\"');
        }
        sb.append('}');
    }

    public M newInstance(Map<String, V> map) {
        return (M)new MapMessage<M, V>(map);
    }

    public String toString() {
        return this.asString();
    }

    @Override
    public void formatTo(StringBuilder buffer) {
        this.format(null, buffer);
    }

    @Override
    public void formatTo(String[] formats, StringBuilder buffer) {
        this.format(this.getFormat(formats), buffer);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof MapMessage)) {
            return false;
        }
        MapMessage that = (MapMessage)o2;
        return this.data.equals(that.data);
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    @Override
    public Throwable getThrowable() {
        return null;
    }

    protected void validate(String key, boolean value) {
    }

    protected void validate(String key, byte value) {
    }

    protected void validate(String key, char value) {
    }

    protected void validate(String key, double value) {
    }

    protected void validate(String key, float value) {
    }

    protected void validate(String key, int value) {
    }

    protected void validate(String key, long value) {
    }

    protected void validate(String key, Object value) {
    }

    protected void validate(String key, short value) {
    }

    protected void validate(String key, String value) {
    }

    protected String toKey(String candidateKey) {
        return candidateKey;
    }

    public M with(String candidateKey, boolean value) {
        String key = this.toKey(candidateKey);
        this.validate(key, value);
        this.data.putValue(key, value);
        return (M)this;
    }

    public M with(String candidateKey, byte value) {
        String key = this.toKey(candidateKey);
        this.validate(key, value);
        this.data.putValue(key, value);
        return (M)this;
    }

    public M with(String candidateKey, char value) {
        String key = this.toKey(candidateKey);
        this.validate(key, value);
        this.data.putValue(key, Character.valueOf(value));
        return (M)this;
    }

    public M with(String candidateKey, double value) {
        String key = this.toKey(candidateKey);
        this.validate(key, value);
        this.data.putValue(key, value);
        return (M)this;
    }

    public M with(String candidateKey, float value) {
        String key = this.toKey(candidateKey);
        this.validate(key, value);
        this.data.putValue(key, Float.valueOf(value));
        return (M)this;
    }

    public M with(String candidateKey, int value) {
        String key = this.toKey(candidateKey);
        this.validate(key, value);
        this.data.putValue(key, value);
        return (M)this;
    }

    public M with(String candidateKey, long value) {
        String key = this.toKey(candidateKey);
        this.validate(key, value);
        this.data.putValue(key, value);
        return (M)this;
    }

    public M with(String candidateKey, Object value) {
        String key = this.toKey(candidateKey);
        this.validate(key, value);
        this.data.putValue(key, value);
        return (M)this;
    }

    public M with(String candidateKey, short value) {
        String key = this.toKey(candidateKey);
        this.validate(key, value);
        this.data.putValue(key, value);
        return (M)this;
    }

    public M with(String candidateKey, String value) {
        String key = this.toKey(candidateKey);
        this.put(key, value);
        return (M)this;
    }

    public static enum MapFormat {
        XML,
        JSON,
        JAVA,
        JAVA_UNQUOTED;


        public static MapFormat lookupIgnoreCase(String format2) {
            return XML.name().equalsIgnoreCase(format2) ? XML : (JSON.name().equalsIgnoreCase(format2) ? JSON : (JAVA.name().equalsIgnoreCase(format2) ? JAVA : (JAVA_UNQUOTED.name().equalsIgnoreCase(format2) ? JAVA_UNQUOTED : null)));
        }

        public static String[] names() {
            return new String[]{XML.name(), JSON.name(), JAVA.name(), JAVA_UNQUOTED.name()};
        }
    }
}

