/*
 * Decompiled with CFR 0.152.
 */
package org.bridj;

import java.util.ArrayList;
import java.util.List;
import org.bridj.StructFieldDescription;

final class SolidRanges {
    public final long[] offsets;
    public final long[] lengths;

    public SolidRanges(long[] offsets, long[] lengths) {
        this.offsets = offsets;
        this.lengths = lengths;
    }

    static class Builder {
        List<Long> offsets = new ArrayList<Long>();
        List<Long> lengths = new ArrayList<Long>();
        long lastOffset = -1L;
        long nextOffset = 0L;
        int count;

        Builder() {
        }

        void add(StructFieldDescription f2) {
            long offset = f2.byteOffset;
            long length = f2.byteLength;
            if (offset == this.lastOffset) {
                length = Math.max(this.lengths.get(this.count - 1), length);
                this.lengths.set(this.count - 1, length);
            } else if (offset == this.nextOffset && this.count != 0) {
                this.lengths.set(this.count - 1, this.lengths.get(this.count - 1) + length);
            } else {
                this.offsets.add(offset);
                this.lengths.add(length);
                ++this.count;
            }
            this.lastOffset = offset;
            this.nextOffset = offset + length;
        }

        SolidRanges toSolidRanges() {
            long[] offsets = new long[this.count];
            long[] lengths = new long[this.count];
            for (int i2 = 0; i2 < this.count; ++i2) {
                offsets[i2] = this.offsets.get(i2);
                lengths[i2] = this.lengths.get(i2);
            }
            return new SolidRanges(offsets, lengths);
        }
    }
}

