/*
 * Decompiled with CFR 0.152.
 */
package org.bridj;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import org.bridj.BridJ;
import org.bridj.SolidRanges;
import org.bridj.StructCustomizer;
import org.bridj.StructFieldDescription;
import org.bridj.StructObject;
import org.bridj.StructUtils;
import org.bridj.ann.Virtual;
import org.bridj.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructDescription {
    protected volatile StructFieldDescription[] fields;
    protected long structSize = -1L;
    protected long structAlignment = -1L;
    protected final Class<?> structClass;
    protected final Type structType;
    protected boolean hasFieldFields;
    StructCustomizer customizer;
    private List<StructFieldDescription> aggregatedFields;
    SolidRanges solidRanges;

    public void prependBytes(long bytes) {
        this.build();
        for (StructFieldDescription field2 : this.fields) {
            field2.offset(bytes);
        }
        this.structSize += bytes;
    }

    public void appendBytes(long bytes) {
        this.build();
        this.structSize += bytes;
    }

    public void setFieldOffset(String fieldName, long fieldOffset, boolean propagateChanges) {
        this.build();
        long propagatedOffsetDelta = 0L;
        long originalOffset = 0L;
        for (StructFieldDescription field2 : this.fields) {
            if (!field2.name.equals(fieldName)) continue;
            originalOffset = field2.byteOffset;
            propagatedOffsetDelta = fieldOffset - field2.byteOffset;
            field2.offset(propagatedOffsetDelta);
            if (propagateChanges) continue;
            long minSize = fieldOffset + field2.byteLength;
            this.structSize = this.structSize < minSize ? minSize : this.structSize;
            return;
        }
        this.structSize += propagatedOffsetDelta;
        for (StructFieldDescription field2 : this.fields) {
            if (field2.name.equals(fieldName) || field2.byteOffset <= originalOffset) continue;
            field2.offset(propagatedOffsetDelta);
        }
    }

    public StructDescription(Class<?> structClass, Type structType, StructCustomizer customizer) {
        this.structClass = structClass;
        this.structType = structType;
        this.customizer = customizer;
        if (Utils.containsTypeVariables(structType)) {
            throw new RuntimeException("Type " + structType + " contains unresolved type variables!");
        }
    }

    boolean isVirtual() {
        for (Method m2 : this.structClass.getMethods()) {
            if (m2.getAnnotation(Virtual.class) == null) continue;
            return true;
        }
        return false;
    }

    public Class<?> getStructClass() {
        return this.structClass;
    }

    public Type getStructType() {
        return this.structType;
    }

    public String toString() {
        return "StructDescription(" + Utils.toString(this.structType) + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void build() {
        if (this.fields == null) {
            StructDescription structDescription = this;
            synchronized (structDescription) {
                if (this.fields == null) {
                    StructUtils.computeStructLayout(this, this.customizer);
                    this.customizer.afterBuild(this);
                    if (BridJ.debug) {
                        BridJ.info(this.describe());
                    }
                }
            }
        }
    }

    public final long getStructSize() {
        this.build();
        return this.structSize;
    }

    public final long getStructAlignment() {
        this.build();
        return this.structAlignment;
    }

    public void setAggregatedFields(List<StructFieldDescription> aggregatedFields) {
        this.aggregatedFields = aggregatedFields;
    }

    public List<StructFieldDescription> getAggregatedFields() {
        this.build();
        return this.aggregatedFields;
    }

    public SolidRanges getSolidRanges() {
        this.build();
        return this.solidRanges;
    }

    public final String describe(StructObject struct) {
        return StructUtils.describe(struct, this.structType, this.fields);
    }

    public final String describe() {
        StringBuilder b2 = new StringBuilder();
        b2.append("// ");
        b2.append("size = ").append(this.structSize).append(", ");
        b2.append("alignment = ").append(this.structAlignment);
        b2.append("\nstruct ");
        b2.append(StructUtils.describe(this.structType)).append(" { ");
        int nFields = this.fields.length;
        for (int iField = 0; iField < nFields; ++iField) {
            StructFieldDescription fd = this.fields[iField];
            b2.append("\n\t");
            b2.append("@Field(").append(iField).append(") ");
            if (fd.isCLong) {
                b2.append("@CLong ");
            } else if (fd.isSizeT) {
                b2.append("@Ptr ");
            }
            b2.append(StructUtils.describe(fd.valueType)).append(" ").append(fd.name).append("; ");
            b2.append("// ");
            b2.append("offset = ").append(fd.byteOffset).append(", ");
            b2.append("length = ").append(fd.byteLength).append(", ");
            if (fd.bitOffset != 0L) {
                b2.append("bitOffset = ").append(fd.bitOffset).append(", ");
            }
            if (fd.bitLength != -1L) {
                b2.append("bitLength = ").append(fd.bitLength).append(", ");
            }
            if (fd.arrayLength != 1L) {
                b2.append("arrayLength = ").append(fd.arrayLength).append(", ");
            }
            if (fd.alignment == 1L) continue;
            b2.append("alignment = ").append(fd.alignment);
        }
        b2.append("\n}");
        return b2.toString();
    }
}

